/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.oauth.service.impl;

import io.meeds.oauth.service.OAuthRegistrationService;
import io.meeds.oauth.spi.AccessTokenContext;
import io.meeds.oauth.spi.OAuthPrincipal;
import io.meeds.oauth.spi.OAuthProviderType;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.image.ImageUtils;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;

public class OAuthRegistrationServiceImpl
implements OAuthRegistrationService {
    private static Log log = ExoLogger.getLogger(OAuthRegistrationServiceImpl.class);
    private static final String REGISTER_ON_FLY_INIT_PARAM = "registerOnFly";
    private static final int IMAGE_WIDTH = 200;
    private static final int IMAGE_HEIGHT = 200;
    private PortalContainer container;
    private OrganizationService organizationService;
    private IdentityManager identityManager;
    private List<String> registerOnFly;

    public OAuthRegistrationServiceImpl(PortalContainer container, OrganizationService organizationService, IdentityManager identityManager, InitParams initParams) {
        this.container = container;
        this.organizationService = organizationService;
        this.identityManager = identityManager;
        if (initParams != null && initParams.containsKey((Object)REGISTER_ON_FLY_INIT_PARAM)) {
            String onFlyProviders = initParams.getValueParam(REGISTER_ON_FLY_INIT_PARAM).getValue();
            this.registerOnFly = StringUtils.isBlank((CharSequence)onFlyProviders) ? Collections.emptyList() : Arrays.asList(onFlyProviders.split(","));
        }
    }

    @Override
    public boolean isRegistrationOnFly(OAuthProviderType<? extends AccessTokenContext> oauthProviderType) {
        return this.registerOnFly.contains(oauthProviderType.getKey());
    }

    @Override
    public User detectGateInUser(HttpServletRequest request, OAuthPrincipal<? extends AccessTokenContext> principal) {
        String email = principal.getEmail();
        String username = principal.getUserName();
        this.startTransaction();
        try {
            User user = this.findUser(username);
            if (user == null) {
                user = this.findUser(email);
            }
            User user2 = user;
            return user2;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error when retrieving user with provider " + principal.getOauthProviderType().getFriendlyName() + " from IDM store", e);
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public User createGateInUser(OAuthPrincipal<? extends AccessTokenContext> principal) {
        User user = principal.getOauthProviderType().getOauthPrincipalProcessor().convertToGateInUser(principal);
        this.createUser(user, principal.getOauthProviderType());
        this.updateUserIdentityAvatar(user.getUserName(), principal);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserProfileAttributes(String username, OAuthProviderType<?> providerType) throws Exception {
        this.startTransaction();
        try {
            UserProfile userProfile = this.organizationService.getUserProfileHandler().findUserProfileByName(username);
            if (userProfile == null) {
                userProfile = this.organizationService.getUserProfileHandler().createUserProfileInstance(username);
            }
            userProfile.setAttribute(providerType.getUserNameAttrName(), username);
            this.organizationService.getUserProfileHandler().saveUserProfile(userProfile, true);
        }
        finally {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateUserIdentityAvatar(String username, OAuthPrincipal<? extends AccessTokenContext> principal) {
        if (principal == null || StringUtils.isBlank((CharSequence)principal.getAvatar())) {
            return;
        }
        String avatar = principal.getAvatar();
        this.startTransaction();
        try {
            String fileName = FilenameUtils.getBaseName((String)avatar);
            MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
            String mimeType = mimeTypeResolver.getMimeType(avatar);
            if (!mimeType.toLowerCase().contains("image")) {
                mimeType = "image/png";
            }
            URL url = new URL(avatar);
            try (InputStream is = url.openStream();){
                if (is != null) {
                    AvatarAttachment avatarAttachment = ImageUtils.createResizedAvatarAttachment((InputStream)is, (int)200, (int)200, null, (String)fileName, (String)mimeType, null);
                    if (avatarAttachment == null) {
                        avatarAttachment = new AvatarAttachment(null, fileName, mimeType, is, System.currentTimeMillis());
                    }
                    Identity identity = this.identityManager.getOrCreateUserIdentity(username);
                    Profile profile = identity.getProfile();
                    profile.setProperty("avatar", (Object)avatarAttachment);
                    Map props = profile.getProperties();
                    for (String key : props.keySet()) {
                        if (!key.startsWith("avatar_")) continue;
                        profile.removeProperty(key);
                    }
                    this.identityManager.updateProfile(profile);
                }
            }
        }
        catch (MalformedURLException ex) {
            log.warn((Object)("Can not fetch Avatar of oauth user because the URL is invalid: " + avatar), (Throwable)ex);
        }
        catch (Exception ex) {
            log.warn((Object)("Can not fetch Avatar at URL: " + avatar), (Throwable)ex);
        }
        finally {
            this.endTransaction();
        }
    }

    private User createUser(User user, OAuthProviderType<?> oAuthProviderType) {
        this.startTransaction();
        try {
            String username;
            if (StringUtils.isBlank((CharSequence)user.getUserName())) {
                username = this.generateUsername(user.getFirstName(), user.getLastName(), user.getEmail());
                user.setUserName(username);
            }
            this.organizationService.getUserHandler().createUser(user, true);
            this.updateUserProfileAttributes(user.getUserName(), oAuthProviderType);
            username = user;
            return username;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error when trying to create authenticated oAuth user " + user.getEmail() + " on-fly with provider " + oAuthProviderType.getFriendlyName(), e);
        }
        finally {
            this.endTransaction();
        }
    }

    private String generateUsername(String firstname, String lastname, String email) throws Exception {
        String userNameBase = StringUtils.isNotBlank((CharSequence)firstname) && StringUtils.isNotBlank((CharSequence)lastname) ? new StringBuffer(firstname.replaceAll("\\s", "")).append(".").append(lastname.replaceAll("\\s", "")).toString().toLowerCase() : (StringUtils.isNotBlank((CharSequence)email) ? email.split("@")[0].replaceAll("\\s", "") : "user1");
        userNameBase = this.unAccent(userNameBase);
        Object username = userNameBase;
        Random rand = new Random();
        while (this.findUser((String)username) != null) {
            int num = rand.nextInt(89) + 10;
            username = userNameBase + String.valueOf(num);
        }
        return username;
    }

    private String unAccent(String src) {
        return Normalizer.normalize(src, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").replace("'", "");
    }

    private User findUser(String usernameOrEmail) throws Exception {
        User user = this.organizationService.getUserHandler().findUserByName(usernameOrEmail, UserStatus.ANY);
        if (user == null && usernameOrEmail != null && usernameOrEmail.contains("@")) {
            Query query = new Query();
            query.setEmail(usernameOrEmail);
            ListAccess list = this.organizationService.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
            if (list != null && list.getSize() > 0) {
                user = ((User[])list.load(0, 1))[0];
            }
        }
        return user;
    }

    private void startTransaction() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
    }

    private void endTransaction() {
        RequestLifeCycle.end();
    }
}

