/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.page;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.portal.mop.PageType;

public class PageState
implements Serializable {
    private static final long serialVersionUID = 7874166775312871923L;
    final String editPermission;
    final boolean showMaxWindow;
    final boolean hideSharedLayout;
    final String profiles;
    final String factoryId;
    final String displayName;
    final String description;
    final String type;
    final String link;
    final List<String> accessPermissions;
    final List<String> moveAppsPermissions;
    final List<String> moveContainersPermissions;

    public PageState(String displayName, String description, boolean showMaxWindow, String factoryId, List<String> accessPermissions, String editPermission, List<String> moveAppsPermissions, List<String> moveContainersPermissions, String type, String link) {
        this(displayName, description, showMaxWindow, false, factoryId, null, accessPermissions, editPermission, moveAppsPermissions, moveContainersPermissions, type, link);
    }

    public PageState(String displayName, String description, boolean showMaxWindow, boolean hideSharedLayout, String factoryId, List<String> accessPermissions, String editPermission, List<String> moveAppsPermissions, List<String> moveContainersPermissions, String type, String link) {
        this(displayName, description, showMaxWindow, hideSharedLayout, factoryId, null, accessPermissions, editPermission, moveAppsPermissions, moveContainersPermissions, type, link);
    }

    public PageState(String displayName, String description, boolean showMaxWindow, boolean hideSharedLayout, String factoryId, String profiles, List<String> accessPermissions, String editPermission, List<String> moveAppsPermissions, List<String> moveContainersPermissions, String type, String link) {
        this.editPermission = editPermission;
        this.showMaxWindow = showMaxWindow;
        this.hideSharedLayout = hideSharedLayout;
        this.factoryId = factoryId;
        this.profiles = profiles;
        this.displayName = displayName;
        this.description = description;
        this.accessPermissions = accessPermissions;
        this.moveAppsPermissions = moveAppsPermissions;
        this.moveContainersPermissions = moveContainersPermissions;
        this.type = type;
        this.link = link;
    }

    public PageState(String displayName, String description, boolean showMaxWindow, String factoryId, List<String> accessPermissions, String editPermission, List<String> moveAppsPermissions, List<String> moveContainersPermissions) {
        this(displayName, description, showMaxWindow, false, factoryId, accessPermissions, editPermission, moveAppsPermissions, moveContainersPermissions);
    }

    public PageState(String displayName, String description, boolean showMaxWindow, boolean hideSharedLayout, String factoryId, List<String> accessPermissions, String editPermission, List<String> moveAppsPermissions, List<String> moveContainersPermissions) {
        this.editPermission = editPermission;
        this.showMaxWindow = showMaxWindow;
        this.hideSharedLayout = hideSharedLayout;
        this.factoryId = factoryId;
        this.profiles = null;
        this.displayName = displayName;
        this.description = description;
        this.accessPermissions = accessPermissions;
        this.moveAppsPermissions = moveAppsPermissions;
        this.moveContainersPermissions = moveContainersPermissions;
        this.type = PageType.PAGE.name();
        this.link = null;
    }

    public String getEditPermission() {
        return this.editPermission;
    }

    public boolean getShowMaxWindow() {
        return this.showMaxWindow;
    }

    public String getFactoryId() {
        return this.factoryId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getProfiles() {
        return this.profiles;
    }

    public List<String> getAccessPermissions() {
        return this.accessPermissions;
    }

    public List<String> getMoveAppsPermissions() {
        return this.moveAppsPermissions;
    }

    public List<String> getMoveContainersPermissions() {
        return this.moveContainersPermissions;
    }

    public String getType() {
        return this.type;
    }

    public String getLink() {
        return this.link;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PageState)) {
            return false;
        }
        PageState that = (PageState)o;
        return Safe.equals(this.editPermission, that.editPermission) && this.showMaxWindow == that.showMaxWindow && Safe.equals(this.factoryId, that.factoryId) && Safe.equals(this.displayName, that.displayName) && Safe.equals(this.description, that.description) && Safe.equals(this.accessPermissions, that.accessPermissions);
    }

    public int hashCode() {
        int result = this.editPermission != null ? this.editPermission.hashCode() : 0;
        result = 31 * result + (this.showMaxWindow ? 1 : 0);
        result = 31 * result + (this.factoryId != null ? this.factoryId.hashCode() : 0);
        result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.accessPermissions != null ? this.accessPermissions.hashCode() : 0);
        return result;
    }

    public Builder builder() {
        return new Builder(this.editPermission, this.showMaxWindow, this.hideSharedLayout, this.factoryId, this.profiles, this.displayName, this.description, this.accessPermissions, this.moveAppsPermissions, this.moveContainersPermissions, this.type, this.link);
    }

    public boolean isHideSharedLayout() {
        return this.hideSharedLayout;
    }

    public static class Builder {
        private String editPermission;
        private boolean showMaxWindow;
        private boolean hideSharedLayout;
        private String factoryId;
        private String profiles;
        private String displayName;
        private String description;
        private String type;
        private String link;
        private List<String> accessPermissions;
        private List<String> moveAppsPermissions;
        private List<String> moveContainersPermissions;

        private Builder(String editPermission, boolean showMaxWindow, boolean hideSharedLayout, String factoryId, String profiles, String displayName, String description, List<String> accessPermissions, List<String> moveAppsPermissions, List<String> moveContainersPermissions, String type, String link) {
            this.editPermission = editPermission;
            this.showMaxWindow = showMaxWindow;
            this.showMaxWindow = hideSharedLayout;
            this.factoryId = factoryId;
            this.profiles = profiles;
            this.displayName = displayName;
            this.description = description;
            this.accessPermissions = accessPermissions;
            this.moveAppsPermissions = moveAppsPermissions;
            this.moveContainersPermissions = moveContainersPermissions;
            this.type = type;
            this.link = link;
        }

        public Builder editPermission(String editPermission) {
            this.editPermission = editPermission;
            return this;
        }

        public Builder accessPermissions(List<String> accessPermissions) {
            this.accessPermissions = accessPermissions;
            return this;
        }

        public Builder accessPermissions(String ... accessPermissions) {
            this.accessPermissions = new ArrayList<String>(Arrays.asList(accessPermissions));
            return this;
        }

        public Builder showMaxWindow(boolean showMaxWindow) {
            this.showMaxWindow = showMaxWindow;
            return this;
        }

        public Builder hideSharedLayout(boolean hideSharedLayout) {
            this.hideSharedLayout = hideSharedLayout;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder profiles(String profiles) {
            this.profiles = profiles;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder factoryId(String factoryId) {
            this.factoryId = factoryId;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder link(String link) {
            this.link = link;
            return this;
        }

        public PageState build() {
            return new PageState(this.displayName, this.description, this.showMaxWindow, this.hideSharedLayout, this.factoryId, this.profiles, this.accessPermissions, this.editPermission, this.moveAppsPermissions, this.moveContainersPermissions, this.type, this.link);
        }
    }
}

