/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.model.reward;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.utils.RewardUtils;

public class RewardPeriodWithFullDate
extends RewardPeriod {
    private static final long serialVersionUID = -7244890529668520077L;
    private String startDate;
    private String endDate;

    public RewardPeriodWithFullDate(RewardPeriod rewardPeriod) {
        ZoneId zoneId = rewardPeriod.zoneId();
        ZonedDateTime startZonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(rewardPeriod.getStartDateInSeconds()), zoneId);
        ZonedDateTime endZonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(rewardPeriod.getEndDateInSeconds() - 1L), zoneId);
        this.startDate = RewardUtils.formatDateTime(startZonedDateTime);
        this.endDate = RewardUtils.formatDateTime(endZonedDateTime);
        this.setRewardPeriodType(rewardPeriod.getRewardPeriodType());
        this.setStartDateInSeconds(rewardPeriod.getStartDateInSeconds());
        this.setEndDateInSeconds(rewardPeriod.getEndDateInSeconds());
        this.setTimeZone(rewardPeriod.getTimeZone());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RewardPeriodWithFullDate)) {
            return false;
        }
        RewardPeriodWithFullDate other = (RewardPeriodWithFullDate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RewardPeriodWithFullDate;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }
}

