/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.services.impl;

import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.gamification.github.model.RemoteOrganization;
import org.exoplatform.gamification.github.model.RemoteRepository;
import org.exoplatform.gamification.github.model.TokenStatus;
import org.exoplatform.gamification.github.model.WebHook;
import org.exoplatform.gamification.github.services.GithubConsumerService;
import org.exoplatform.gamification.github.storage.GithubConsumerStorage;

public class GithubConsumerServiceImpl
implements GithubConsumerService {
    private GithubConsumerStorage githubConsumerStorage;

    public GithubConsumerServiceImpl(GithubConsumerStorage githubConsumerStorage) {
        this.githubConsumerStorage = githubConsumerStorage;
    }

    @Override
    public WebHook createWebhook(String organizationName, String[] triggers, String accessToken) throws IllegalAccessException {
        return this.githubConsumerStorage.createWebhook(organizationName, triggers, accessToken);
    }

    @Override
    public String deleteWebhook(WebHook webHook) {
        return this.githubConsumerStorage.deleteWebhookHook(webHook);
    }

    @Override
    public String forceUpdateWebhook(WebHook webHook) {
        return this.githubConsumerStorage.forceUpdateWebhook(webHook);
    }

    @Override
    public RemoteOrganization retrieveRemoteOrganization(String organizationName, String accessToken) throws ObjectNotFoundException {
        return this.githubConsumerStorage.retrieveRemoteOrganization(organizationName, accessToken);
    }

    @Override
    public List<RemoteRepository> retrieveOrganizationRepos(WebHook webHook, int page, int perPage, String keyword) {
        return this.githubConsumerStorage.retrieveOrganizationRepos(webHook.getOrganizationName(), webHook.getToken(), page, perPage, keyword);
    }

    @Override
    public RemoteOrganization retrieveRemoteOrganization(long organizationId, String accessToken) {
        return this.githubConsumerStorage.retrieveRemoteOrganization(organizationId, accessToken);
    }

    @Override
    public TokenStatus checkGitHubTokenStatus(String token) {
        return this.githubConsumerStorage.checkGitHubTokenStatus(token);
    }

    @Override
    public void clearCache() {
        this.githubConsumerStorage.clearCache();
    }
}

