/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import org.exoplatform.portal.mop.Utils;
import org.exoplatform.portal.mop.navigation.NodeChangeListener;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.navigation.TreeContext;
import org.exoplatform.portal.mop.navigation.TreeUpdateAdapter;
import org.exoplatform.portal.mop.navigation.VisitMode;
import org.exoplatform.portal.tree.diff.Adapters;
import org.exoplatform.portal.tree.diff.HierarchyAdapter;
import org.exoplatform.portal.tree.diff.HierarchyChangeIterator;
import org.exoplatform.portal.tree.diff.HierarchyChangeType;
import org.exoplatform.portal.tree.diff.HierarchyDiff;

class TreeUpdate<N1, N2> {
    private final HierarchyChangeIterator<String[], NodeContext<N1>, String[], N2, String> it;
    private final TreeUpdateAdapter<N2> updateAdapter;
    private final Scope.Visitor visitor;
    private int depth;
    private NodeContext<N1> last;
    private NodeChangeListener<NodeContext<N1>> listener;

    static <N1, N2> void perform(TreeContext<N1> src, HierarchyAdapter<String[], NodeContext<N1>, String> srcAdatper, N2 dst, TreeUpdateAdapter<N2> updateAdapter, NodeChangeListener<NodeContext<N1>> listener, Scope.Visitor visitor) {
        TreeUpdate<N1, N2> update = new TreeUpdate<N1, N2>(src, srcAdatper, dst, updateAdapter, listener, visitor);
        update.perform();
    }

    private TreeUpdate(TreeContext<N1> src, HierarchyAdapter<String[], NodeContext<N1>, String> srcAdatper, N2 dst, TreeUpdateAdapter<N2> updateAdapter, NodeChangeListener<NodeContext<N1>> listener, Scope.Visitor visitor) {
        HierarchyDiff diff = HierarchyDiff.create(Adapters.list(), srcAdatper, Adapters.list(), updateAdapter, Utils.comparator());
        HierarchyChangeIterator it = diff.iterator(src.root, dst);
        this.it = it;
        this.updateAdapter = updateAdapter;
        this.visitor = visitor;
        this.depth = 0;
        this.last = null;
        this.listener = listener;
    }

    private void perform() {
        HierarchyChangeType change = this.it.next();
        this.perform(this.it.getSource());
    }

    private void perform(NodeContext<N1> parent) {
        N2 d = this.it.getDestination();
        NodeData data = this.updateAdapter.getData(d);
        VisitMode visit = data != null ? this.visitor.enter(this.depth, data.id, data.name, data.state) : null;
        if (visit != VisitMode.ALL_CHILDREN) {
            this.it.skip();
            this.it.next();
        } else {
            HierarchyChangeType change;
            ++this.depth;
            if (!parent.isExpanded()) {
                parent.expand();
            }
            while ((change = this.it.next()) != HierarchyChangeType.LEAVE) {
                if (change == HierarchyChangeType.KEEP) {
                    this.it.next();
                    this.perform(this.it.getSource());
                    continue;
                }
                if (change == HierarchyChangeType.ADDED) {
                    NodeContext<N1> added;
                    NodeContext<N1> previous;
                    this.it.next();
                    NodeData addedData = this.updateAdapter.getData(this.it.getDestination());
                    if (this.last == null || this.last.getParent() != parent) {
                        previous = null;
                        added = parent.insertAt((Integer)0, addedData);
                    } else {
                        previous = this.last;
                        added = this.last.insertAfter(addedData);
                    }
                    if (this.listener != null) {
                        this.listener.onAdd(added, parent, previous);
                    }
                    this.perform(added);
                    continue;
                }
                if (change == HierarchyChangeType.MOVED_IN) {
                    NodeContext<N1> previous;
                    this.it.next();
                    NodeContext<N1> to = parent;
                    NodeContext<N1> moved = this.it.getSource();
                    NodeContext from = (NodeContext)moved.getParent();
                    if (this.last == null || this.last.getParent() != parent) {
                        previous = null;
                        to.insertAt((Integer)0, moved);
                    } else {
                        previous = this.last;
                        this.last.insertAfter(moved);
                    }
                    if (this.listener != null) {
                        this.listener.onMove(moved, from, to, previous != null ? previous : null);
                    }
                    this.perform(this.it.getSource());
                    continue;
                }
                if (change == HierarchyChangeType.MOVED_OUT) continue;
                if (change == HierarchyChangeType.REMOVED) {
                    NodeContext<N1> removed = this.it.getSource();
                    NodeContext removedParent = (NodeContext)removed.getParent();
                    removed.remove();
                    if (this.listener == null) continue;
                    this.listener.onRemove(removed, removedParent);
                    continue;
                }
                throw new UnsupportedOperationException("Not supported " + String.valueOf((Object)change));
            }
            --this.depth;
        }
        if (data != null) {
            if (!parent.data.state.equals(data.state) && this.listener != null) {
                this.listener.onUpdate(parent, data.state);
            }
            if (!parent.data.name.equals(data.name)) {
                parent.name = data.name;
                if (this.listener != null) {
                    this.listener.onRename(parent, (NodeContext)parent.getParent(), data.name);
                }
            }
            parent.state = this.updateAdapter.getState(d);
            parent.name = this.updateAdapter.getName(d);
            parent.data = data;
            this.visitor.leave(this.depth, data.id, data.name, data.state);
        }
        this.last = parent;
    }
}

