/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.management.jmx.impl;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.impl.ExoMBeanInfoBuilder;
import org.exoplatform.management.jmx.impl.ExoModelMBean;
import org.exoplatform.management.jmx.impl.JMX;
import org.exoplatform.management.jmx.impl.MBeanScopingData;
import org.exoplatform.management.jmx.impl.PropertiesInfo;
import org.exoplatform.management.spi.ManagedResource;
import org.exoplatform.management.spi.ManagementProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JMXManagementProvider
implements ManagementProvider {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.JMXManagementProvider");
    private final MBeanServer server;

    public JMXManagementProvider() {
        this(MBeanServerFactory.createMBeanServer());
    }

    public JMXManagementProvider(MBeanServer server) {
        this.server = server;
    }

    @Override
    public Object manage(ManagedResource context) {
        if (context == null) {
            throw new IllegalArgumentException("The context cannot be null");
        }
        ExoModelMBean mbean = null;
        try {
            ExoMBeanInfoBuilder infoBuilder = new ExoMBeanInfoBuilder(context.getMetaData());
            ModelMBeanInfo info = infoBuilder.build();
            mbean = new ExoModelMBean(context, context.getResource(), info);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Could not create the ExoModelMBean for the class " + String.valueOf(context.getResource()) == null ? null : context.getResource().getClass(), (Throwable)e);
        }
        catch (RuntimeOperationsException e) {
            LOG.warn("Could not create the ExoModelMBean for the class " + String.valueOf(context.getResource()) == null ? null : context.getResource().getClass(), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            LOG.warn("Could not create the ExoModelMBean for the class " + String.valueOf(context.getResource()) == null ? null : context.getResource().getClass(), (Throwable)e);
        }
        catch (MBeanException e) {
            LOG.warn("Could not create the ExoModelMBean for the class " + String.valueOf(context.getResource()) == null ? null : context.getResource().getClass(), (Throwable)e);
        }
        catch (InvalidTargetObjectTypeException e) {
            LOG.warn("Could not create the ExoModelMBean for the class " + String.valueOf(context.getResource()) == null ? null : context.getResource().getClass(), (Throwable)e);
        }
        if (mbean != null) {
            ObjectName on = null;
            PropertiesInfo oni = PropertiesInfo.resolve(context.getResource().getClass(), NameTemplate.class);
            if (oni != null) {
                try {
                    MBeanScopingData foo = oni.resolve(context.getResource());
                    on = JMX.createObjectName("exo", foo);
                }
                catch (MalformedObjectNameException e) {
                    LOG.warn((Object)("Could not create the ObjectName for the class " + String.valueOf(context.getResource().getClass())), (Throwable)e);
                }
            }
            if (on != null) {
                try {
                    LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
                    List<MBeanScopingData> list = context.getScopingData(MBeanScopingData.class);
                    for (int i = list.size(); i > 0; --i) {
                        MBeanScopingData scopingData = list.get(i - 1);
                        props.putAll(scopingData);
                    }
                    Iterator<Map.Entry<String, String>> iterator = on.getKeyPropertyList().entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, String> o;
                        Map.Entry<String, String> entry = o = iterator.next();
                        String key = entry.getKey();
                        String value = entry.getValue();
                        props.put(key, value);
                    }
                    on = JMX.createObjectName(on.getDomain(), props);
                    this.attemptToRegister(on, mbean);
                    return on;
                }
                catch (MalformedObjectNameException e) {
                    LOG.warn((Object)("Could not register the MBean for the class " + String.valueOf(context.getResource().getClass())), (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptToRegister(final ObjectName name, final Object mbean) {
        MBeanServer mBeanServer = this.server;
        synchronized (mBeanServer) {
            if (this.server.isRegistered(name)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("The MBean '" + String.valueOf(name) + " has already been registered, it will be unregistered and then re-registered"));
                }
                try {
                    SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            JMXManagementProvider.this.server.unregisterMBean(name);
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RuntimeException("Failed to unregister MBean '" + String.valueOf(name) + " due to " + e.getMessage(), e);
                }
            }
            try {
                SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        JMXManagementProvider.this.server.registerMBean(mbean, name);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Failed to register MBean '" + String.valueOf(name) + " due to " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void unmanage(Object key) {
        final ObjectName name = (ObjectName)key;
        try {
            try {
                SecurityHelper.doPrivilegedExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        if (JMXManagementProvider.this.server.isRegistered(name)) {
                            JMXManagementProvider.this.server.unregisterMBean(name);
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                Throwable cause = pae.getCause();
                if (cause instanceof InstanceNotFoundException) {
                    throw (InstanceNotFoundException)cause;
                }
                if (cause instanceof MBeanRegistrationException) {
                    throw (MBeanRegistrationException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
        catch (InstanceNotFoundException e) {
            LOG.warn((Object)("Could not unregister the MBean " + String.valueOf(name)), (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            LOG.warn((Object)("Could not unregister the MBean " + String.valueOf(name)), (Throwable)e);
        }
    }
}

