/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.entity;

import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.constant.EntityVisibility;
import io.meeds.gamification.entity.AbstractAuditingEntity;
import java.io.Serializable;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;

@Entity(name="GamificationDomain")
@ExoEntity
@Table(name="GAMIFICATION_DOMAIN")
@NamedQueries(value={@NamedQuery(name="GamificationDomain.getAllDomains", query="SELECT domain FROM GamificationDomain domain LEFT JOIN FETCH domain.owners WHERE domain.isDeleted = false"), @NamedQuery(name="GamificationDomain.findByIdWithOwners", query="SELECT domain FROM GamificationDomain domain LEFT JOIN FETCH domain.owners WHERE domain.id = :id"), @NamedQuery(name="GamificationDomain.findDomainByTitle", query="SELECT domain FROM GamificationDomain domain LEFT JOIN FETCH domain.owners WHERE domain.title = :domainTitle"), @NamedQuery(name="GamificationDomain.deleteDomainByTitle", query="DELETE FROM GamificationDomain domain WHERE domain.title = :domainTitle"), @NamedQuery(name="GamificationDomain.countProgramColor", query="SELECT COUNT(*) FROM GamificationDomain domain WHERE domain.color = :color AND domain.isDeleted = false")})
public class ProgramEntity
extends AbstractAuditingEntity
implements Serializable {
    private static final long serialVersionUID = 6578902752036385060L;
    @Id
    @SequenceGenerator(name="SEQ_GAMIFICATION_DOMAIN_ID", sequenceName="SEQ_GAMIFICATION_DOMAIN_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_GAMIFICATION_DOMAIN_ID")
    protected Long id;
    @Column(name="TITLE", unique=true, nullable=false)
    protected String title;
    @Column(name="DESCRIPTION")
    protected String description;
    @Column(name="COLOR")
    protected String color;
    @Column(name="PRIORITY")
    protected int priority;
    @Column(name="DELETED", nullable=false)
    protected boolean isDeleted;
    @Column(name="ENABLED", nullable=false)
    protected boolean isEnabled;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="TYPE", nullable=false)
    protected EntityType type;
    @Column(name="BUDGET")
    protected long budget;
    @Column(name="COVER_FILE_ID")
    protected long coverFileId;
    @Column(name="AVATAR_FILE_ID")
    protected long avatarFileId;
    @Column(name="AUDIENCE_ID")
    protected Long audienceId;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="VISIBILITY")
    protected EntityVisibility visibility;
    @ElementCollection(fetch=FetchType.EAGER)
    @CollectionTable(name="GAMIFICATION_DOMAIN_OWNERS", joinColumns={@JoinColumn(name="DOMAIN_ID")})
    @Column(name="IDENTITY_ID")
    private Set<Long> owners;

    public Long getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getColor() {
        return this.color;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public EntityType getType() {
        return this.type;
    }

    public long getBudget() {
        return this.budget;
    }

    public long getCoverFileId() {
        return this.coverFileId;
    }

    public long getAvatarFileId() {
        return this.avatarFileId;
    }

    public Long getAudienceId() {
        return this.audienceId;
    }

    public EntityVisibility getVisibility() {
        return this.visibility;
    }

    public Set<Long> getOwners() {
        return this.owners;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setType(EntityType type) {
        this.type = type;
    }

    public void setBudget(long budget) {
        this.budget = budget;
    }

    public void setCoverFileId(long coverFileId) {
        this.coverFileId = coverFileId;
    }

    public void setAvatarFileId(long avatarFileId) {
        this.avatarFileId = avatarFileId;
    }

    public void setAudienceId(Long audienceId) {
        this.audienceId = audienceId;
    }

    public void setVisibility(EntityVisibility visibility) {
        this.visibility = visibility;
    }

    public void setOwners(Set<Long> owners) {
        this.owners = owners;
    }

    @Override
    public String toString() {
        return "ProgramEntity(id=" + this.getId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", color=" + this.getColor() + ", priority=" + this.getPriority() + ", isDeleted=" + this.isDeleted() + ", isEnabled=" + this.isEnabled() + ", type=" + String.valueOf((Object)this.getType()) + ", budget=" + this.getBudget() + ", coverFileId=" + this.getCoverFileId() + ", avatarFileId=" + this.getAvatarFileId() + ", audienceId=" + this.getAudienceId() + ", visibility=" + String.valueOf((Object)this.getVisibility()) + ", owners=" + String.valueOf(this.getOwners()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProgramEntity)) {
            return false;
        }
        ProgramEntity other = (ProgramEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getBudget() != other.getBudget()) {
            return false;
        }
        if (this.getCoverFileId() != other.getCoverFileId()) {
            return false;
        }
        if (this.getAvatarFileId() != other.getAvatarFileId()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$audienceId = this.getAudienceId();
        Long other$audienceId = other.getAudienceId();
        if (this$audienceId == null ? other$audienceId != null : !((Object)this$audienceId).equals(other$audienceId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$color = this.getColor();
        String other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) {
            return false;
        }
        EntityType this$type = this.getType();
        EntityType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        EntityVisibility this$visibility = this.getVisibility();
        EntityVisibility other$visibility = other.getVisibility();
        if (this$visibility == null ? other$visibility != null : !((Object)((Object)this$visibility)).equals((Object)other$visibility)) {
            return false;
        }
        Set<Long> this$owners = this.getOwners();
        Set<Long> other$owners = other.getOwners();
        return !(this$owners == null ? other$owners != null : !((Object)this$owners).equals(other$owners));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProgramEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPriority();
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        long $budget = this.getBudget();
        result = result * 59 + (int)($budget >>> 32 ^ $budget);
        long $coverFileId = this.getCoverFileId();
        result = result * 59 + (int)($coverFileId >>> 32 ^ $coverFileId);
        long $avatarFileId = this.getAvatarFileId();
        result = result * 59 + (int)($avatarFileId >>> 32 ^ $avatarFileId);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $audienceId = this.getAudienceId();
        result = result * 59 + ($audienceId == null ? 43 : ((Object)$audienceId).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $color = this.getColor();
        result = result * 59 + ($color == null ? 43 : $color.hashCode());
        EntityType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        EntityVisibility $visibility = this.getVisibility();
        result = result * 59 + ($visibility == null ? 43 : ((Object)((Object)$visibility)).hashCode());
        Set<Long> $owners = this.getOwners();
        result = result * 59 + ($owners == null ? 43 : ((Object)$owners).hashCode());
        return result;
    }
}

