/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.scheduler.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ImportContentsJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger((String)ImportContentsJob.class.getName());
    private static final String MIX_TARGET_PATH = "mix:targetPath";
    private static final String MIX_TARGET_WORKSPACE = "mix:targetWorkspace";
    private static final String JCR_File_SEPARATOR = "/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        Session session = null;
        try {
            int eventType;
            int i;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Start Execute ImportXMLJob");
            }
            JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
            String stagingStorage = jdatamap.getString("stagingStorage");
            String temporaryStorge = jdatamap.getString("temporaryStorge");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Init parameters first time :");
            }
            SessionProvider sessionProvider = SessionProvider.createSystemProvider();
            String containerName = WCMCoreUtils.getContainerNameFromJobContext((JobExecutionContext)context);
            RepositoryService repositoryService_ = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class, (String)containerName);
            ManageableRepository manageableRepository = repositoryService_.getCurrentRepository();
            PublicationService publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class, (String)containerName);
            PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get("Authoring publication");
            XMLInputFactory factory = XMLInputFactory.newInstance();
            File stagingFolder = new File(stagingStorage);
            File tempfolder = new File(temporaryStorge);
            File[] files = null;
            File xmlFile = null;
            XMLStreamReader reader = null;
            FileInputStream xmlInputStream = null;
            ArrayList<LinkObject> listLink = new ArrayList<LinkObject>();
            LinkObject linkObj = new LinkObject();
            boolean hasNewContent = false;
            if (stagingFolder.exists() && (files = stagingFolder.listFiles()) != null) {
                hasNewContent = true;
                for (i = 0; i < files.length; ++i) {
                    xmlFile = files[i];
                    if (!xmlFile.isFile()) continue;
                    MimeTypeResolver resolver = new MimeTypeResolver();
                    String fileName = xmlFile.getName();
                    String hashCode = fileName.split("-")[0];
                    String mimeType = resolver.getMimeType(xmlFile.getName());
                    if (!"text/xml".equals(mimeType)) continue;
                    xmlInputStream = new FileInputStream(xmlFile);
                    reader = factory.createXMLStreamReader(xmlInputStream);
                    while (reader.hasNext()) {
                        eventType = reader.next();
                        if (eventType == 1 && "data".equals(reader.getLocalName())) {
                            int len;
                            String data = reader.getElementText();
                            if (!tempfolder.exists()) {
                                tempfolder.mkdirs();
                            }
                            long time = System.currentTimeMillis();
                            File file = new File(temporaryStorge + File.separator + "-" + hashCode + "-" + time + ".xml.tmp");
                            ByteArrayInputStream inputStream = new ByteArrayInputStream(data.getBytes());
                            FileOutputStream out = new FileOutputStream(file);
                            byte[] buf = new byte[1024];
                            while ((len = inputStream.read(buf)) > 0) {
                                ((OutputStream)out).write(buf, 0, len);
                            }
                            ((OutputStream)out).close();
                            ((InputStream)inputStream).close();
                        }
                        try {
                            String contentPath;
                            String workspace;
                            if (eventType == 1 && "published-content".equals(reader.getLocalName())) {
                                linkObj.setSourcePath(reader.getAttributeValue(0));
                            }
                            if (eventType == 1 && "type".equals(reader.getLocalName())) {
                                linkObj.setLinkType(reader.getElementText());
                            }
                            if (eventType == 1 && "title".equals(reader.getLocalName())) {
                                linkObj.setLinkTitle(reader.getElementText());
                            }
                            if (eventType == 1 && "targetPath".equals(reader.getLocalName())) {
                                linkObj.setLinkTargetPath(reader.getElementText());
                                listLink.add(linkObj);
                            }
                            if (eventType != 1 || !"unpublished-content".equals(reader.getLocalName())) continue;
                            String contentTargetPath = reader.getAttributeValue(0);
                            String[] strContentPath = contentTargetPath.split(":");
                            StringBuffer sbContPath = new StringBuffer();
                            boolean flag = true;
                            for (int index = 2; index < strContentPath.length; ++index) {
                                if (flag) {
                                    sbContPath.append(strContentPath[index]);
                                    flag = false;
                                    continue;
                                }
                                sbContPath.append(":").append(strContentPath[index]);
                            }
                            sessionProvider = SessionProvider.createSystemProvider();
                            session = sessionProvider.getSession(workspace = strContentPath[1], manageableRepository = repositoryService_.getCurrentRepository());
                            if (session.itemExists(contentPath = sbContPath.toString())) {
                                Node currentContent = (Node)session.getItem(contentPath);
                                HashMap<String, String> variables = new HashMap<String, String>();
                                variables.put("nodePath", contentTargetPath);
                                variables.put("workspaceName", workspace);
                                if (!currentContent.hasProperty("publication:lifecycleName") || !"Authoring publication".equals(currentContent.getProperty("publication:lifecycleName").getString()) || !"published".equals(currentContent.getProperty("publication:currentState").getString())) continue;
                                publicationPlugin.changeState(currentContent, "unpublished", variables);
                                if (!LOG.isInfoEnabled()) continue;
                                LOG.info((Object)("Change the status of the node " + currentContent.getPath() + " from published to unpublished"));
                                continue;
                            }
                            if (!LOG.isWarnEnabled()) continue;
                            LOG.warn((Object)("The node " + contentPath + " does not exist"));
                        }
                        catch (Exception ie) {
                            if (!LOG.isWarnEnabled()) continue;
                            LOG.warn((Object)("Error in ImportContentsJob: " + ie.getMessage()));
                        }
                    }
                    reader.close();
                    ((InputStream)xmlInputStream).close();
                    xmlFile.delete();
                }
            }
            if ((files = tempfolder.listFiles()) != null) {
                for (i = 0; i < files.length; ++i) {
                    xmlFile = files[i];
                    FileInputStream inputStream = new FileInputStream(xmlFile);
                    reader = factory.createXMLStreamReader(inputStream);
                    String workspace = null;
                    String nodePath = new String();
                    while (reader.hasNext()) {
                        eventType = reader.next();
                        if (eventType != 1 || !reader.getLocalName().equals("property")) continue;
                        String value = reader.getAttributeValue(0);
                        if (MIX_TARGET_PATH.equals(value)) {
                            eventType = reader.next();
                            if (eventType != 1) continue;
                            reader.next();
                            nodePath = reader.getText();
                            continue;
                        }
                        if (!MIX_TARGET_WORKSPACE.equals(value) || (eventType = reader.next()) != 1) continue;
                        reader.next();
                        workspace = reader.getText();
                    }
                    reader.close();
                    ((InputStream)inputStream).close();
                    session = sessionProvider.getSession(workspace, manageableRepository);
                    if (session.itemExists(nodePath)) {
                        session.getItem(nodePath).remove();
                    }
                    session.save();
                    String path = nodePath.substring(0, nodePath.lastIndexOf(JCR_File_SEPARATOR));
                    if (!session.itemExists(path)) {
                        String[] pathTab = path.split(JCR_File_SEPARATOR);
                        Node node_ = session.getRootNode();
                        StringBuffer path_ = new StringBuffer(JCR_File_SEPARATOR);
                        for (int j = 1; j < pathTab.length; ++j) {
                            if (!session.itemExists((path_ = path_.append(pathTab[j] + JCR_File_SEPARATOR)).toString())) {
                                node_.addNode(pathTab[j], "nt:unstructured");
                            }
                            node_ = (Node)session.getItem(path_.toString());
                        }
                    }
                    session.importXML(path, (InputStream)new FileInputStream(xmlFile), 0);
                    session.save();
                    xmlFile.delete();
                    if (!hasNewContent) continue;
                    for (LinkObject obj : listLink) {
                        String[] linkTarget = obj.getLinkTargetPath().split(":");
                        StringBuffer itemPath = new StringBuffer();
                        boolean flag = true;
                        for (int index = 2; index < linkTarget.length; ++index) {
                            if (flag) {
                                itemPath.append(linkTarget[index]);
                                flag = false;
                                continue;
                            }
                            itemPath.append(":");
                            itemPath.append(linkTarget[index]);
                        }
                        String[] linkSource = obj.getSourcePath().split(":");
                        session = sessionProvider.getSession(linkTarget[1], manageableRepository);
                        Node parentNode = (Node)session.getItem(itemPath.toString());
                        StringBuffer sourcePath = new StringBuffer();
                        boolean flagSource = true;
                        for (int index = 2; index < linkSource.length; ++index) {
                            if (flagSource) {
                                sourcePath.append(linkSource[index]);
                                flagSource = false;
                                continue;
                            }
                            sourcePath.append(":");
                            sourcePath.append(linkSource[index]);
                        }
                        if (parentNode.hasNode(obj.getLinkTitle())) {
                            Node existedNode = (Node)session.getItem(String.valueOf(itemPath) + JCR_File_SEPARATOR + obj.getLinkTitle());
                            existedNode.remove();
                        }
                        session = sessionProvider.getSession(linkSource[1], manageableRepository);
                        Node targetNode = (Node)session.getItem(sourcePath.toString());
                        LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class, (String)containerName);
                        linkManager.createLink(parentNode, obj.getLinkType(), targetNode, obj.getLinkTitle());
                    }
                }
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"End Execute ImportXMLJob");
            }
        }
        catch (RepositoryException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Repository 'repository ' not found.");
            }
        }
        catch (Exception ex) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Error when importing Contents : " + ex.getMessage()), (Throwable)ex);
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private class LinkObject {
        private String linkType;
        private String linkTitle;
        private String linkTargetPath;
        private String sourcePath;

        private LinkObject() {
        }

        public String getLinkType() {
            return this.linkType;
        }

        public void setLinkType(String linkType) {
            this.linkType = linkType;
        }

        public String getLinkTitle() {
            return this.linkTitle;
        }

        public void setLinkTitle(String linkTitle) {
            this.linkTitle = linkTitle;
        }

        public String getLinkTargetPath() {
            return this.linkTargetPath;
        }

        public void setLinkTargetPath(String linkTargetPath) {
            this.linkTargetPath = linkTargetPath;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }
    }
}

