/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.checker;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.SecurityHelper;

public class InspectionReport {
    private static final String COMMENT = "//";
    private static final String DELIMITER = "\n";
    private Writer writer;
    private boolean reportHasInconsistency;
    private String reportPath;
    private final ThreadLocal<InspectionReportContext> reportContext = new ThreadLocal();

    public InspectionReport(String forRepository) throws IOException {
        final File reportFile = new File("report-" + forRepository + "-" + new SimpleDateFormat("dd-MMM-yy-HH-mm").format(new Date()) + ".txt");
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws IOException {
                InspectionReport.this.reportPath = reportFile.getAbsolutePath();
                InspectionReport.this.writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(InspectionReport.this.reportPath)));
                return null;
            }
        });
    }

    public void init(boolean isMulti) {
        if (isMulti) {
            this.reportContext.set(new InspectionReportContext());
        } else {
            this.reportContext.remove();
        }
    }

    public synchronized void flush() throws IOException {
        for (String message : this.reportContext.get().getComments()) {
            this.writeMessage(message);
        }
        for (String brokenObject : this.reportContext.get().getBrokenObjects()) {
            this.writeBrokenObject(brokenObject);
        }
        for (String key : this.reportContext.get().getLogExceptions().keySet()) {
            this.writeException(key, this.reportContext.get().getLogExceptions().get(key));
        }
        this.reportContext.remove();
    }

    public boolean hasInconsistency() {
        return this.reportHasInconsistency;
    }

    public void logComment(String message) throws IOException {
        if (this.reportContext.get() != null) {
            this.reportContext.get().addComment(message);
        } else {
            this.writeMessage(message);
        }
    }

    public void logDescription(String description) throws IOException {
        if (this.reportContext.get() != null) {
            this.reportContext.get().addComment(description);
        } else {
            this.writeMessage(description);
        }
    }

    private void writeMessage(String message) throws IOException {
        this.writeLine(message);
        this.writer.flush();
    }

    public void logBrokenObjectAndSetInconsistency(String brokenObject) throws IOException {
        this.setInconsistency();
        if (this.reportContext.get() != null) {
            this.reportContext.get().addBrokenObject(brokenObject);
        } else {
            this.writeBrokenObject(brokenObject);
        }
    }

    private void writeBrokenObject(String brokenObject) throws IOException {
        this.writer.write(brokenObject);
        this.writer.write(DELIMITER);
        this.writer.flush();
    }

    public void logExceptionAndSetInconsistency(String message, Throwable e) throws IOException {
        this.setInconsistency();
        if (this.reportContext.get() != null) {
            this.reportContext.get().addLogException(message, e);
        } else {
            this.writeException(message, e);
        }
    }

    private void writeException(String message, Throwable e) throws IOException {
        this.writeLine(message);
        this.writeStackTrace(e);
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public String getReportPath() {
        return this.reportPath;
    }

    private void setInconsistency() {
        this.reportHasInconsistency = true;
    }

    private void writeLine(String message) throws IOException {
        this.writer.write(COMMENT);
        this.writer.write(message);
        this.writer.write(DELIMITER);
        this.writer.flush();
    }

    private void writeStackTrace(Throwable e) throws IOException {
        this.writeLine(e.getMessage());
        this.writeLine(e.toString());
        StackTraceElement[] trace = e.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            this.writeLine("\tat " + String.valueOf(trace[i]));
        }
        Throwable ourCause = e.getCause();
        if (ourCause != null) {
            this.writeLine("Cause:");
            this.writeStackTrace(ourCause);
        }
    }

    private static class InspectionReportContext {
        private final List<String> comments = new ArrayList<String>();
        private final List<String> logBrokenObjects = new ArrayList<String>();
        private final Map<String, Throwable> logExceptions = new HashMap<String, Throwable>();

        private InspectionReportContext() {
        }

        public void addComment(String message) {
            this.comments.add(message);
        }

        public void addBrokenObject(String brokenObject) {
            this.logBrokenObjects.add(brokenObject);
        }

        public void addLogException(String message, Throwable e) {
            this.logExceptions.put(message, e);
        }

        public List<String> getComments() {
            return this.comments;
        }

        public List<String> getBrokenObjects() {
            return this.logBrokenObjects;
        }

        public Map<String, Throwable> getLogExceptions() {
            return this.logExceptions;
        }
    }
}

