/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.checker;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.checker.AbstractInconsistencyRepair;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.SimpleChangedSizeHandler;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.WorkspaceStorageConnectionFactory;

public class RootAsParentAssigner
extends AbstractInconsistencyRepair {
    public RootAsParentAssigner(WorkspaceStorageConnectionFactory connFactory, JDBCDataContainerConfig containerConfig) {
        super(connFactory, containerConfig);
    }

    @Override
    protected void repairRow(JDBCStorageConnection conn, ResultSet resultSet) throws SQLException {
        if (resultSet.getInt("I_CLASS") == 1) {
            this.assignRootAsParent(conn, resultSet);
        } else {
            this.deleteProperty(conn, resultSet);
        }
    }

    private void deleteProperty(JDBCStorageConnection conn, ResultSet resultSet) throws SQLException {
        try {
            String propertyId = this.getIdentifier(resultSet, "ID");
            QPath path = QPath.parse(resultSet.getString("NAME"));
            TransientPropertyData data = new TransientPropertyData(path, propertyId, 0, 0, null, false, new ArrayList<ValueData>());
            conn.delete(data, new SimpleChangedSizeHandler());
        }
        catch (UnsupportedOperationException e) {
            throw new SQLException(e);
        }
        catch (InvalidItemStateException e) {
            throw new SQLException(e);
        }
        catch (IllegalStateException e) {
            throw new SQLException(e);
        }
        catch (RepositoryException e) {
            throw new SQLException(e);
        }
    }

    private void assignRootAsParent(JDBCStorageConnection conn, ResultSet resultSet) throws SQLException {
        try {
            String nodeId = this.getIdentifier(resultSet, "ID");
            int orderNum = resultSet.getInt("N_ORDER_NUM");
            int version = resultSet.getInt("VERSION");
            QPath path = new QPath(new QPathEntry[]{this.getQPathEntry(resultSet)});
            TransientNodeData data = new TransientNodeData(path, nodeId, version, null, null, orderNum, "00exo0jcr0root0uuid0000000000000", null);
            conn.rename(data);
        }
        catch (IllegalStateException e) {
            throw new SQLException(e);
        }
        catch (RepositoryException e) {
            throw new SQLException(e);
        }
        catch (IllegalNameException e) {
            throw new SQLException(e);
        }
    }
}

