/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.task.plugin;

import io.meeds.social.cms.model.ContentLinkExtension;
import io.meeds.social.cms.model.ContentLinkSearchResult;
import io.meeds.social.cms.plugin.ContentLinkPlugin;
import io.meeds.social.cms.service.ContentLinkPluginService;
import jakarta.annotation.PostConstruct;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.security.Identity;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.service.TaskService;
import org.exoplatform.task.util.UserUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskContentLinkPlugin
implements ContentLinkPlugin {
    public static final String OBJECT_TYPE = "task";
    private static final String TITLE_KEY = "contentLink.task";
    private static final String ICON = "fa fa-tasks";
    private static final String COMMAND = "task";
    private static final ContentLinkExtension EXTENSION = new ContentLinkExtension("task", "contentLink.task", "fa fa-tasks", "task", true);
    @Autowired
    private TaskService taskService;
    @Autowired
    private PortalContainer container;

    @PostConstruct
    public void init() {
        ((ContentLinkPluginService)this.container.getComponentInstanceOfType(ContentLinkPluginService.class)).addPlugin((ContentLinkPlugin)this);
    }

    public ContentLinkExtension getExtension() {
        return EXTENSION;
    }

    public List<ContentLinkSearchResult> search(String keyword, Identity identity, Locale locale, int offset, int limit) {
        String currentUser = identity.getUserId();
        LinkedList<String> memberships = new LinkedList<String>();
        memberships.addAll(UserUtil.getMemberships(identity));
        return this.taskService.findTasksByMemberShips(currentUser, memberships, keyword, limit).stream().map(this::toContentLink).toList();
    }

    public String getContentTitle(String objectId, Locale locale) {
        try {
            TaskDto task = this.taskService.getTask(Long.parseLong(objectId));
            return task == null ? "" : task.getTitle();
        }
        catch (EntityNotFoundException e) {
            return "";
        }
    }

    private ContentLinkSearchResult toContentLink(TaskDto task) {
        return new ContentLinkSearchResult("task", String.valueOf(task.getId()), task.getTitle(), EXTENSION.getIcon(), EXTENSION.isDrawer());
    }
}

