/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.ActivityProcessor;
import org.exoplatform.social.core.ActivityTypePlugin;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.ActivityFilter;
import org.exoplatform.social.core.activity.ActivityListener;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.ActivitySystemTypePlugin;
import org.exoplatform.social.core.activity.model.ActivityShareAction;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;

public interface ActivityManager {
    public static final String SHARED_ACTIVITY_ID_PARAM = "originalActivityId";

    public void saveActivityNoReturn(Identity var1, ExoSocialActivity var2);

    public void saveActivityNoReturn(ExoSocialActivity var1);

    public ExoSocialActivity getActivity(String var1);

    public ExoSocialActivity getParentActivity(ExoSocialActivity var1);

    public void updateActivity(ExoSocialActivity var1);

    default public void updateActivity(ExoSocialActivity activity, boolean broadcast) {
        this.updateActivity(activity);
    }

    public void deleteActivity(ExoSocialActivity var1);

    public void deleteActivity(String var1);

    default public ExoSocialActivity hideActivity(String activityId) {
        throw new UnsupportedOperationException();
    }

    public void saveComment(ExoSocialActivity var1, ExoSocialActivity var2);

    public RealtimeListAccess<ExoSocialActivity> getCommentsWithListAccess(ExoSocialActivity var1);

    public RealtimeListAccess<ExoSocialActivity> getCommentsWithListAccess(ExoSocialActivity var1, boolean var2);

    default public RealtimeListAccess<ExoSocialActivity> getCommentsWithListAccess(ExoSocialActivity activity, boolean loadSubComments, boolean sortDescending) {
        return this.getCommentsWithListAccess(activity, loadSubComments);
    }

    public void deleteComment(String var1, String var2);

    public void deleteComment(ExoSocialActivity var1, ExoSocialActivity var2);

    public void saveLike(ExoSocialActivity var1, Identity var2);

    public void deleteLike(ExoSocialActivity var1, Identity var2);

    default public ExoSocialActivity pinActivity(String activityId, String userIdentityId) {
        throw new UnsupportedOperationException();
    }

    default public ExoSocialActivity unpinActivity(String activityId) {
        throw new UnsupportedOperationException();
    }

    default public boolean canPinActivity(ExoSocialActivity activity, Identity identity) {
        throw new UnsupportedOperationException();
    }

    public RealtimeListAccess<ExoSocialActivity> getActivitiesWithListAccess(Identity var1);

    public RealtimeListAccess<ExoSocialActivity> getActivitiesWithListAccess(Identity var1, Identity var2);

    default public RealtimeListAccess<ExoSocialActivity> getActivitiesByFilterWithListAccess(Identity viewerIdentity, ActivityFilter activityFilter) throws ObjectNotFoundException, IllegalAccessException {
        throw new UnsupportedOperationException();
    }

    public RealtimeListAccess<ExoSocialActivity> getActivitiesOfConnectionsWithListAccess(Identity var1);

    public RealtimeListAccess<ExoSocialActivity> getActivitiesOfSpaceWithListAccess(Identity var1);

    public RealtimeListAccess<ExoSocialActivity> getActivitiesOfUserSpacesWithListAccess(Identity var1);

    public RealtimeListAccess<ExoSocialActivity> getActivityFeedWithListAccess(Identity var1);

    public RealtimeListAccess<ExoSocialActivity> getActivitiesByPoster(Identity var1);

    public RealtimeListAccess<ExoSocialActivity> getActivitiesByPoster(Identity var1, String ... var2);

    public void addProcessor(ActivityProcessor var1);

    public void addProcessorPlugin(BaseActivityProcessorPlugin var1);

    default public void addActivityTypePlugin(ActivityTypePlugin plugin) {
    }

    public void addActivityEventListener(ActivityListenerPlugin var1);

    default public void addActivityListener(ActivityListener listener) {
    }

    default public void removeActivityListener(ActivityListener listener) {
    }

    default public void addSystemActivityDefinition(ActivitySystemTypePlugin activitySystemTypePlugin) {
    }

    public RealtimeListAccess<ExoSocialActivity> getAllActivitiesWithListAccess();

    public List<ExoSocialActivity> getSubComments(ExoSocialActivity var1);

    public int getMaxUploadSize();

    public List<ExoSocialActivity> getActivities(List<String> var1);

    public boolean isActivityEditable(ExoSocialActivity var1, org.exoplatform.services.security.Identity var2);

    default public boolean isActivityViewable(ExoSocialActivity activity, org.exoplatform.services.security.Identity identity) {
        return true;
    }

    default public boolean isActivityDeletable(ExoSocialActivity activity, org.exoplatform.services.security.Identity identity) {
        return false;
    }

    default public boolean isActivityManageable(ExoSocialActivity activity, org.exoplatform.services.security.Identity identity) {
        return false;
    }

    default public boolean isActivityExists(String activityId) {
        throw new UnsupportedOperationException();
    }

    default public boolean isActivityTypeEnabled(String activityType) {
        return true;
    }

    default public boolean isNotificationEnabled(ExoSocialActivity activity) {
        return true;
    }

    default public boolean isNotificationEnabled(ExoSocialActivity activity, String username) {
        return true;
    }

    default public boolean canPostActivityInStream(org.exoplatform.services.security.Identity viewer, Identity streamOwner) {
        return true;
    }

    default public boolean isEnableUserComposer() {
        return true;
    }

    default public List<ExoSocialActivity> shareActivity(ExoSocialActivity activityTemplate, String activityId, List<String> targetSpaces, org.exoplatform.services.security.Identity viewer) throws ObjectNotFoundException, IllegalAccessException {
        throw new UnsupportedOperationException();
    }

    default public List<ExoSocialActivity> shareActivity(ExoSocialActivity activityTemplate, ActivityShareAction activityShareAction, org.exoplatform.services.security.Identity viewer) throws ObjectNotFoundException, IllegalAccessException {
        throw new UnsupportedOperationException();
    }

    default public Identity getActivityStreamOwnerIdentity(String activityId) {
        throw new UnsupportedOperationException();
    }

    default public String getActivityTitle(String activityId) {
        ExoSocialActivity activity = this.getActivity(activityId);
        return this.getActivityTitle(activity);
    }

    default public String getActivityTitle(ExoSocialActivity activity) {
        return activity == null ? null : activity.getTitle();
    }

    default public List<Long> getActivityCategoryIds(long spaceId) {
        throw new UnsupportedOperationException();
    }

    default public List<Long> getActivityCategoryIds(long spaceId, String username) {
        throw new UnsupportedOperationException();
    }

    default public int getNumberOfAllComments(String activityId) {
        throw new UnsupportedOperationException();
    }
}

