/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.analytics.listener.portal;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
public class LoginAnalyticsListener
extends Listener<ConversationRegistry, ConversationState> {
    private static final Log LOG = ExoLogger.getLogger(LoginAnalyticsListener.class);
    private static final List<String> EVENT_NAMES = Arrays.asList("exo.core.security.ConversationRegistry.register", "exo.core.security.ConversationRegistry.unregister");
    @Autowired
    private ListenerService listenerService;

    @PostConstruct
    public void init() {
        EVENT_NAMES.forEach(name -> this.listenerService.addListener(name, (ListenerBase)this));
    }

    public void onEvent(Event<ConversationRegistry, ConversationState> event) throws Exception {
        ConversationState state = (ConversationState)event.getData();
        long userId = AnalyticsUtils.getUserIdentityId((ConversationState)state);
        if (userId <= 0L) {
            LOG.debug("User not found in state, userId= {} ", new Object[]{userId});
            return;
        }
        boolean isLogin = this.isLogin(event);
        String operation = isLogin ? "login" : "logout";
        StatisticData statisticData = new StatisticData();
        statisticData.setModule("portal");
        statisticData.setSubModule("login");
        statisticData.setOperation(operation);
        statisticData.setUserId(userId);
        AnalyticsUtils.addStatisticData((StatisticData)statisticData);
    }

    private boolean isLogin(Event<ConversationRegistry, ConversationState> event) {
        String eventName = event.getEventName();
        return StringUtils.equals((CharSequence)"exo.core.security.ConversationRegistry.register", (CharSequence)eventName);
    }
}

