/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.distributions.tools;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class JavaVersion {
    final Pattern regex = Pattern.compile("([\\d]+)\\.([\\d]+)(?:.*|$)");
    private int systemJavaMajorVersion = 1;
    private int systemJavaMinorVersion = 7;

    JavaVersion(String version) {
        this.extractVersions(version);
    }

    void extractVersions(String systemJavaVersion) {
        try {
            Matcher regexMatcher = this.regex.matcher(systemJavaVersion);
            if (regexMatcher.find()) {
                this.systemJavaMajorVersion = Integer.parseInt(regexMatcher.group(1));
                this.systemJavaMinorVersion = Integer.parseInt(regexMatcher.group(2));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final int isMinorVersionSuperiorOrEqual(int version) {
        return this.systemJavaMinorVersion >= version ? 0 : -1;
    }

    public final int isMinorVersionEqual(int version) {
        return this.systemJavaMinorVersion == version ? 0 : -1;
    }

    public int getSystemJavaMajorVersion() {
        return this.systemJavaMajorVersion;
    }

    public int getSystemJavaMinorVersion() {
        return this.systemJavaMinorVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaVersion that = (JavaVersion)o;
        return Objects.equals(this.systemJavaMajorVersion, that.systemJavaMajorVersion) && Objects.equals(this.systemJavaMinorVersion, that.systemJavaMinorVersion);
    }

    public int hashCode() {
        return Objects.hash(this.systemJavaMajorVersion, this.systemJavaMinorVersion);
    }
}

