/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.jaas.weblogic;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.jaas.DefaultLoginModule;
import weblogic.security.principal.WLSGroupImpl;
import weblogic.security.principal.WLSUserImpl;

public class WeblogicLoginModule
extends DefaultLoginModule {
    private static final String OPTION_PORTAL_CONTAINER_NAME = "portalContainerName";
    private static final String DEFAULT_PORTAL_CONTAINER_NAME = "portal";
    protected Log log = ExoLogger.getLogger((String)"WeblogicLoginModule");

    public void afterInitialize() {
        super.afterInitialize();
    }

    public boolean commit() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"In commit of WeblogicLoginModule.");
        }
        if (super.commit()) {
            Set<Principal> principals = this.subject.getPrincipals();
            principals.add((Principal)new WLSUserImpl(this.identity.getUserId()));
            for (String role : this.identity.getRoles()) {
                principals.add((Principal)new WLSGroupImpl(role));
            }
            return true;
        }
        return false;
    }

    public boolean abort() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"In abort of WeblogicLoginModule.");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"In logout of WeblogicLoginModule.");
        }
        return super.logout();
    }
}

