/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login.websphere;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.web.AbstractHttpServlet;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;

public class ErrorLoginServlet
extends AbstractHttpServlet {
    private static final long serialVersionUID = -1565579389217147072L;
    public static final String WASReqURL_COOKIE = "WASReqURL";
    private static final Log LOG = ExoLogger.getLogger((String)ErrorLoginServlet.class.getName());

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PortalContainer pContainer = PortalContainer.getInstance();
        ServletContext context = pContainer.getPortalContext();
        this.unregisterTokenCookie(req);
        this.clearTokenCookie(req, resp);
        resp.setContentType("text/html; charset=UTF-8");
        this.showLoginForm(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showLoginForm(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int jsecurityIndex;
        String initialURI = "";
        Cookie[] cookies = req.getCookies();
        for (int index = 0; index <= cookies.length; ++index) {
            String cookieName = cookies[index].getName();
            if (!WASReqURL_COOKIE.equals(cookieName)) continue;
            initialURI = cookies[index].getValue();
            break;
        }
        if ((jsecurityIndex = initialURI.lastIndexOf("/j_security_check")) != -1) {
            initialURI = initialURI.substring(0, jsecurityIndex);
        }
        try {
            req.setAttribute("org.gatein.portal.login.initial_uri", (Object)initialURI);
            this.getServletContext().getRequestDispatcher("/login/jsp/login.jsp").include((ServletRequest)req, (ServletResponse)resp);
        }
        finally {
            req.removeAttribute("org.gatein.portal.login.initial_uri");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void clearTokenCookie(HttpServletRequest req, HttpServletResponse resp) {
        Cookie cookie = new Cookie("rememberme", "");
        cookie.setPath(req.getContextPath());
        cookie.setMaxAge(0);
        resp.addCookie(cookie);
    }

    private void unregisterTokenCookie(HttpServletRequest req) {
        String tokenId = this.getTokenCookie(req);
        if (tokenId != null) {
            try {
                AbstractTokenService tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                tokenService.deleteToken((Object)tokenId);
            }
            catch (Exception e) {
                LOG.warn((Object)("Cannot delete the token '" + tokenId + "'"), (Throwable)e);
            }
        }
    }

    private String getTokenCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"rememberme".equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected boolean requirePortalEnvironment() {
        return true;
    }
}

