/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.gadget.services.ForumStatistics;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ks.common.jcr.KSDataLocation;
import org.exoplatform.ks.common.jcr.PropertyReader;
import org.exoplatform.ks.common.jcr.SessionManager;
import org.exoplatform.platform.gadget.services.ForumStatistics.ForumsWeeklyStatistic;
import org.exoplatform.platform.gadget.services.ForumStatistics.ForumsWeeklyStatisticService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForumsWeeklyStatisticServiceImp
implements ForumsWeeklyStatisticService,
Startable {
    private static final Log log = ExoLogger.getLogger(ForumsWeeklyStatisticServiceImp.class);
    public static final String STATISTIC_WEEK_HOME = "statisticWeekHome";
    private KSDataLocation dataLocator;
    private SessionManager sessionManager;
    private String repository;
    private String workspace;

    public ForumsWeeklyStatisticServiceImp(InitParams params, KSDataLocation locator, NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.dataLocator = locator;
        this.sessionManager = this.dataLocator.getSessionManager();
        this.repository = this.dataLocator.getRepository();
        this.workspace = this.dataLocator.getWorkspace();
    }

    public String getRepository() {
        return this.repository;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Session session = this.sessionManager.getSession(sProvider);
            Node forumHome = session.getRootNode().getNode(this.dataLocator.getForumHomeLocation());
            if (!forumHome.hasNode(STATISTIC_WEEK_HOME)) {
                Node statisticWeekHome = forumHome.addNode(STATISTIC_WEEK_HOME, "nt:unstructured");
                session.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"can not start ForumsWeeklyStatisticService", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    public void stop() {
    }

    private Node getStatisticWeekHomeNode(SessionProvider sProvider) throws Exception {
        String path = this.dataLocator.getForumHomeLocation() + "/" + STATISTIC_WEEK_HOME;
        return this.sessionManager.getSession(sProvider).getRootNode().getNode(path);
    }

    private ForumsWeeklyStatistic getForumsWeeklyStatistic(Node node) throws Exception {
        ForumsWeeklyStatistic statistic = new ForumsWeeklyStatistic();
        statistic.setId(node.getName());
        statistic.setStartDate(node.getProperty("exo:startDate").getDate().getTime());
        statistic.setStartPostsCountOfWeek(node.getProperty("exo:startPostsCountOfWeek").getLong());
        statistic.setPostsCountOfWeek(node.getProperty("exo:postsCountOfWeek").getLong());
        statistic.setLastStatEntry(node.getProperty("exo:lastStatEntry").getDate().getTime());
        return statistic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ForumsWeeklyStatistic getLastForumsWeeklyStatistic() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node statisticHome = this.getStatisticWeekHomeNode(sProvider);
            QueryManager qm = statisticHome.getSession().getWorkspace().getQueryManager();
            String pathQuery = "/jcr:root" + statisticHome.getPath() + "/element(*,exo:periodicForumStats) order by @exo:startDate descending";
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            if (iter != null && iter.getSize() > 0L) {
                ForumsWeeklyStatistic forumsWeeklyStatistic = this.getForumsWeeklyStatistic(iter.nextNode());
                return forumsWeeklyStatistic;
            }
        }
        catch (Exception e) {
            log.error((Object)"can not get getLastForumsWeeklyStatistic", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ForumsWeeklyStatistic> getAllForumsWeeklyStatistic() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        ArrayList<ForumsWeeklyStatistic> listForumsWeeklyStatistic = new ArrayList<ForumsWeeklyStatistic>();
        try {
            Node statisticHome = this.getStatisticWeekHomeNode(sProvider);
            QueryManager qm = statisticHome.getSession().getWorkspace().getQueryManager();
            String pathQuery = "/jcr:root" + statisticHome.getPath() + "/element(*,exo:periodicForumStats) order by @exo:startDate descending";
            Query query = qm.createQuery(pathQuery, "xpath");
            QueryResult result = query.execute();
            NodeIterator iter = result.getNodes();
            while (iter.hasNext()) {
                listForumsWeeklyStatistic.add(this.getForumsWeeklyStatistic(iter.nextNode()));
            }
        }
        catch (Exception e) {
            log.error((Object)"can not get getAllForumsWeeklyStatistic", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return listForumsWeeklyStatistic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveForumsWeeklyStatistic(ForumsWeeklyStatistic forumsWeeklyStatistic) throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node forumStatisticHome = this.getStatisticWeekHomeNode(sProvider);
            Node statisticWeekNode = null;
            try {
                statisticWeekNode = forumStatisticHome.getNode(forumsWeeklyStatistic.getId());
            }
            catch (PathNotFoundException e) {
                statisticWeekNode = forumStatisticHome.addNode(forumsWeeklyStatistic.getId(), "exo:periodicForumStats");
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(forumsWeeklyStatistic.getStartDate());
            statisticWeekNode.setProperty("exo:startDate", cal);
            statisticWeekNode.setProperty("exo:startPostsCountOfWeek", forumsWeeklyStatistic.getStartPostsCountOfWeek().longValue());
            statisticWeekNode.setProperty("exo:postsCountOfWeek", forumsWeeklyStatistic.getPostsCountOfWeek().longValue());
            cal.setTime(forumsWeeklyStatistic.getLastStatEntry());
            statisticWeekNode.setProperty("exo:lastStatEntry", cal);
            if (forumStatisticHome.isNew()) {
                forumStatisticHome.getSession().save();
            } else {
                forumStatisticHome.save();
            }
        }
        catch (Exception e) {
            log.error((Object)"save ForumsWeeklyStatistic failure", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPostCountForumStatistic() throws Exception {
        SessionProvider sProvider = SessionProvider.createSystemProvider();
        try {
            Node statisticNode = this.sessionManager.getSession(sProvider).getRootNode().getNode(this.dataLocator.getForumStatisticsLocation());
            long l = new PropertyReader(statisticNode).l("exo:postCount", 0L);
            return l;
        }
        catch (Exception e) {
            log.error((Object)"getPostCountForumStatistic failure", (Throwable)e);
        }
        finally {
            sProvider.close();
        }
        return 0L;
    }
}

