/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.pci.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import javax.portlet.ValidatorException;
import org.exoplatform.commons.utils.ExoEnumeration;
import org.exoplatform.services.portletcontainer.pci.model.Preference;

public class ExoPortletPreferences
extends HashMap
implements PortletPreferences,
Serializable {
    private String preferencesValidator;

    public Map getMap() {
        return this;
    }

    public boolean isReadOnly(String key) {
        if (key == null) {
            throw new IllegalArgumentException("preference name is null");
        }
        Preference preference = (Preference)this.get(key);
        if (preference == null) {
            return false;
        }
        return preference.isReadOnly();
    }

    public String getValue(String key, String def) {
        if (key == null) {
            throw new IllegalArgumentException("preference name is null");
        }
        Preference preference = (Preference)this.get(key);
        return preference.getValue(def);
    }

    public String[] getValues(String key, String[] def) {
        if (key == null) {
            throw new IllegalArgumentException("preference name is null");
        }
        Preference preference = (Preference)this.get(key);
        if (preference == null) {
            return def;
        }
        return preference.getValues(key, def);
    }

    public void setValue(String key, String value) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException("preference name is null");
        }
        Preference preference = (Preference)this.get(key);
        if (preference == null) {
            preference = new Preference();
            preference.setName(key);
            this.put(key, preference);
        }
        if (preference.isReadOnly()) {
            throw new ReadOnlyException("This preference is readonly");
        }
        if (value == null) {
            return;
        }
        preference.addValue(value);
    }

    public void setValues(String key, String[] value) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException("preference name is null");
        }
        Preference preference = (Preference)this.get(key);
        if (preference == null) {
            preference = new Preference();
            preference.setName(key);
            this.put(key, preference);
        }
        if (preference.isReadOnly()) {
            throw new ReadOnlyException("This preference is readonly");
        }
        if (value == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < value.length; ++i) {
            list.add(value[i]);
        }
        preference.setValues(list);
    }

    public Enumeration getNames() {
        return new ExoEnumeration(this.keySet().iterator());
    }

    public void reset(String key) throws ReadOnlyException {
        if (key == null) {
            throw new IllegalArgumentException("preference name is null");
        }
        Preference preference = (Preference)this.get(key);
        if (preference == null) {
            return;
        }
        if (preference.isReadOnly()) {
            throw new ReadOnlyException("This preference is readonly");
        }
        preference.clear();
    }

    public void store() throws IOException, ValidatorException {
        throw new Error("NOT SUPPORT");
    }

    public void addPreference(Preference pref) {
        this.put(pref.getName(), pref);
    }

    public String getPreferencesValidator() {
        return this.preferencesValidator;
    }

    public void setPreferencesValidator(String preferencesValidator) {
        this.preferencesValidator = preferencesValidator;
    }
}

