/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.management;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PortletConfig;
import javax.servlet.ServletContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.portletcontainer.PortletLifecycleListener;
import org.exoplatform.services.portletcontainer.management.PortletApplicationManaged;
import org.exoplatform.services.portletcontainer.management.PortletManaged;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletApplicationRegisterImpl;

@Managed
@NameTemplate(value={@Property(key="service", value="portletcontainer")})
public class PortletContainerManaged
implements PortletLifecycleListener,
ManagementAware {
    private String name;
    private String description;
    private ManagementContext context;
    private List<PortletManaged> portletManageds = new ArrayList<PortletManaged>();

    public PortletContainerManaged(PortletApplicationRegisterImpl register) {
        register.addListenerPlugin((ComponentPlugin)this);
    }

    public void preUndeploy(String portletApplicationName, PortletApp portletApplication, ServletContext servletContext) {
        Iterator<PortletManaged> i = this.portletManageds.iterator();
        while (i.hasNext()) {
            PortletManaged portletManaged = i.next();
            this.context.unregister((Object)portletManaged);
            i.remove();
        }
    }

    public void postUndeploy(String portletApplicationName, PortletApp portletApplication, ServletContext servletContext) {
    }

    public void preDeploy(String portletApplicationName, PortletApp portletApplication, ServletContext servletContext) {
    }

    public void postDeploy(String portletApplicationName, PortletApp portletApplication, ServletContext servletContext) {
        PortletApplicationManaged portletApplicationManaged = new PortletApplicationManaged(this, portletApplicationName, portletApplication, servletContext);
        for (Portlet portlet : portletApplication.getPortlet()) {
            PortletManaged portletManaged = new PortletManaged(portletApplicationManaged, portlet);
            this.context.register((Object)portletManaged);
            this.portletManageds.add(portletManaged);
        }
    }

    public void preInit(PortletConfig portletConfig) {
    }

    public void postInit(PortletConfig portletConfig) {
    }

    public void preDestroy() {
    }

    public void postDestroy() {
    }

    public void setContext(ManagementContext context) {
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

