/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.UnavailableException;
import javax.portlet.WindowState;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.PortletContainerConf;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.services.portletcontainer.PortletProcessingException;
import org.exoplatform.services.portletcontainer.helper.PortletWindowInternal;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.Output;
import org.exoplatform.services.portletcontainer.pci.RenderInput;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.pci.ResourceOutput;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletApplicationProxy;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletApplicationsHolder;
import org.exoplatform.services.portletcontainer.plugins.pc.aop.PortletCommandChain;
import org.exoplatform.services.portletcontainer.plugins.pc.monitor.PortletContainerMonitorImpl;
import org.exoplatform.services.portletcontainer.plugins.pc.monitor.PortletRuntimeDatasImpl;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.ActionRequestImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.ActionResponseImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.EventRequestImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.EventResponseImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletAPIObjectFactory;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletRequestImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletResponseImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletSessionImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.RenderRequestImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.RenderResponseImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.RequestContext;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.ResourceRequestImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.ResourceResponseImp;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.ResponseContext;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.bundle.ResourceBundleManager;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.helpers.CustomRequestWrapper;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.helpers.CustomResponseWrapper;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.helpers.DummyCcppProfile;

public class PortletApplicationHandler {
    private final PortalContext portalContext;
    private final PortletApplicationsHolder holder;
    private final PortletContainerConf conf;
    private static Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
    private final PortletContainerMonitorImpl monitor;
    private final ResourceBundleManager resourceBundleManager;
    private ExoContainer cont;

    public PortletApplicationHandler(PortalContext portalContext, PortletApplicationsHolder holder, PortletContainerConf conf, PortletContainerMonitorImpl portletMonitor, ResourceBundleManager manager, ExoContainerContext context) {
        this.portalContext = portalContext;
        this.holder = holder;
        this.conf = conf;
        this.monitor = portletMonitor;
        this.resourceBundleManager = manager;
        this.cont = context.getContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void process(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, Input input, Output output, PortletWindowInternal windowInfos, int isAction) throws PortletContainerException {
        String portletName;
        String portletAppName;
        PortletRequestImp portletRequest;
        long startTime;
        block76: {
            block75: {
                block74: {
                    startTime = System.currentTimeMillis();
                    log.debug((Object)"process() method in PortletApplicationHandler entered");
                    PortletSessionImp session = null;
                    CustomRequestWrapper requestWrapper = null;
                    CustomResponseWrapper responseWrapper = null;
                    portletRequest = null;
                    PortletResponseImp portletResponse = null;
                    portletAppName = windowInfos.getWindowID().getPortletApplicationName();
                    portletName = windowInfos.getWindowID().getPortletName();
                    try {
                        ExoContainer manager = this.cont;
                        PortletApplicationProxy proxy = (PortletApplicationProxy)manager.getComponentInstance((Object)(portletAppName + "_portlet_app_"));
                        if (!this.holder.isModeSuported(portletAppName, portletName, input.getMarkup(), input.getPortletMode())) {
                            throw new PortletContainerException("The portlet mode " + input.getPortletMode().toString() + " is not supported for the " + input.getMarkup() + " markup language.");
                        }
                        if (!this.holder.isStateSupported(portletAppName, portletName, input.getMarkup(), input.getWindowState())) {
                            log.debug((Object)("Window state : " + input.getWindowState() + " not supported, set the window state to normal"));
                            input.setWindowState(WindowState.NORMAL);
                        }
                        String exception_key = "org.exoplatform.portal.container.exception" + portletAppName + portletName;
                        PortletContext portletContext = PortletAPIObjectFactory.getInstance().createPortletContext(this.cont, servletContext, this.holder.getPortletMetaData(portletAppName, portletName));
                        log.debug((Object)"Create new object");
                        long portletAppVersionNumber = 1L;
                        portletAppVersionNumber = this.monitor.getPortletVersionNumber(portletAppName);
                        log.debug((Object)("Get portlet version number : " + portletAppVersionNumber));
                        session = new PortletSessionImp(this.cont, request.getSession(false), portletContext, windowInfos.getWindowID().getUniqueID());
                        requestWrapper = new CustomRequestWrapper(request, windowInfos.getWindowID().getUniqueID());
                        responseWrapper = new CustomResponseWrapper(response);
                        RequestContext reqCtx = new RequestContext((HttpServletRequest)requestWrapper, this.portalContext, portletContext, session, input, windowInfos, this.holder.getPortletApplication(portletAppName).getSecurityConstraint(), this.holder.getPortletApplication(portletAppName).getUserAttribute(), this.holder.getPortletApplication(portletAppName).getCustomPortletMode(), this.holder.getPortletApplication(portletAppName).getCustomWindowState(), this.holder.getRoles(portletAppName), this.conf.getSupportedContent());
                        if (isAction == 1) {
                            portletRequest = new ActionRequestImp(reqCtx);
                            this.processActionRequest(portletRequest);
                        } else if (isAction == 2) {
                            portletRequest = new EventRequestImp(reqCtx);
                            this.processEventRequest(portletRequest);
                        } else if (isAction == 3) {
                            portletRequest = new ResourceRequestImp(reqCtx);
                            this.processResourceRequest(portletRequest);
                        } else {
                            portletRequest = new RenderRequestImp(reqCtx);
                            this.processRenderRequest(portletRequest);
                        }
                        ResponseContext resCtx = new ResponseContext((HttpServletResponse)responseWrapper, this.cont, windowInfos.getWindowID().getUniqueID(), input, this.holder.getPortletMetaData(portletAppName, portletName), request.isSecure(), this.conf.getSupportedContent(), Collections.enumeration(this.holder.getWindowStates(portletAppName, portletName, input.getMarkup())), this.holder.getPortletApplication(portletAppName).getCustomWindowState(), output, this.portalContext, portletRequest);
                        portletResponse = isAction == 1 ? new ActionResponseImp(resCtx) : (isAction == 2 ? new EventResponseImp(resCtx) : (isAction == 3 ? new ResourceResponseImp(resCtx) : new RenderResponseImp(resCtx)));
                        portletRequest.setAttribute("javax.portlet.userinfo", input.getUserAttributes());
                        portletRequest.setAttribute("javax.portlet.ccpp", this.getCcppProfile(request));
                        this.monitor.setLastAccessTime(portletAppName, portletName, startTime);
                        boolean isBroken = this.monitor.isBroken(portletAppName, portletName);
                        boolean isAvailable = this.monitor.isAvailable(portletAppName, portletName, startTime);
                        boolean isDestroyed = this.monitor.isDestroyed(portletAppName, portletName);
                        if (isDestroyed) {
                            log.debug((Object)"Portlet is destroyed");
                            this.processPortletException(null, portletRequest, isAction, null, output);
                            Object var33_26 = null;
                            break block74;
                        }
                        if (isBroken || !isAvailable || portletRequest.getAttribute(exception_key) != null) {
                            log.debug((Object)"Portlet is borken, not available or the request contains an associated error");
                            this.processPortletException(null, portletRequest, isAction, exception_key, output);
                            break block75;
                        }
                        javax.portlet.Portlet portlet = null;
                        try {
                            portlet = proxy.getPortlet(portletContext, portletName);
                        }
                        catch (PortletException e) {
                            log.error((Object)("unable to get portlet :  " + portletName), (Throwable)e);
                            portletRequest.setAttribute(exception_key, (Object)e);
                            this.processPortletException(e, portletRequest, isAction, exception_key, output);
                            Object var33_28 = null;
                            long endTime = System.currentTimeMillis();
                            PortletRuntimeDatasImpl rtd = this.monitor.getPortletRuntimeData(portletAppName, portletName);
                            if (portletRequest != null) {
                                if (portletRequest.getPortletSession(false) == null) {
                                    output.addProperty("_invalidate_session_", (Object)"0");
                                } else {
                                    output.addProperty("_invalidate_session_", (Object)("" + portletRequest.getPortletSession(false).getMaxInactiveInterval()));
                                }
                            }
                            if (rtd == null) return;
                            if (isAction == 1) {
                                rtd.logProcessActionRequest(startTime, endTime);
                                return;
                            }
                            if (isAction == 2) {
                                rtd.logProcessEventRequest(startTime, endTime);
                                return;
                            }
                            if (isAction == 3) {
                                boolean cacheHit = ((ResourceOutput)output).isCacheHit();
                                rtd.logServeResourceRequest(startTime, endTime, cacheHit);
                                return;
                            }
                            boolean cacheHit = ((RenderOutput)output).isCacheHit();
                            rtd.logRenderRequest(startTime, endTime, cacheHit);
                            return;
                        }
                        try {
                            PortletCommandChain chain = (PortletCommandChain)this.cont.getComponentInstanceOfType(PortletCommandChain.class);
                            if (isAction == 1) {
                                chain.doProcessAction(portlet, (ActionRequest)portletRequest, (ActionResponse)portletResponse);
                                if (portletResponse.isSendRedirectAlreadyOccured()) {
                                    String location = ((ActionResponseImp)portletResponse).getLocation();
                                    log.debug((Object)("need to redirect to " + location));
                                    output.addProperty("_send_redirect_", (Object)location);
                                }
                                break block76;
                            }
                            if (isAction == 2) {
                                chain.doProcessEvent(portlet, (EventRequest)portletRequest, (EventResponse)portletResponse);
                                break block76;
                            }
                            if (isAction == 3) {
                                chain.doServeResource(portlet, (ResourceRequest)portletRequest, (ResourceResponse)portletResponse);
                                break block76;
                            }
                            chain.doRender(portlet, (RenderRequest)portletRequest, (RenderResponse)portletResponse);
                            if (((RenderInput)input).getTitle() != null) {
                                log.debug((Object)"overide default title");
                                ((RenderOutput)output).setTitle(((RenderInput)input).getTitle());
                            }
                            break block76;
                        }
                        catch (Throwable t) {
                            log.error((Object)"exception returned by processAction() or render() methods", t);
                            this.monitor.setLastFailureAccessTime(portletAppName, portletName, startTime);
                            if (t instanceof RuntimeException) {
                                log.debug((Object)"It is a runtime exception");
                                portletRequest.setAttribute(exception_key, t);
                                this.processPortletException(t, portletRequest, isAction, exception_key, output);
                                Object var33_29 = null;
                                long endTime = System.currentTimeMillis();
                                PortletRuntimeDatasImpl rtd = this.monitor.getPortletRuntimeData(portletAppName, portletName);
                                if (portletRequest != null) {
                                    if (portletRequest.getPortletSession(false) == null) {
                                        output.addProperty("_invalidate_session_", (Object)"0");
                                    } else {
                                        output.addProperty("_invalidate_session_", (Object)("" + portletRequest.getPortletSession(false).getMaxInactiveInterval()));
                                    }
                                }
                                if (rtd == null) return;
                                if (isAction == 1) {
                                    rtd.logProcessActionRequest(startTime, endTime);
                                    return;
                                }
                                if (isAction == 2) {
                                    rtd.logProcessEventRequest(startTime, endTime);
                                    return;
                                }
                                if (isAction == 3) {
                                    boolean cacheHit = ((ResourceOutput)output).isCacheHit();
                                    rtd.logServeResourceRequest(startTime, endTime, cacheHit);
                                    return;
                                }
                                boolean cacheHit = ((RenderOutput)output).isCacheHit();
                                rtd.logRenderRequest(startTime, endTime, cacheHit);
                                return;
                            }
                            if (t instanceof PortletException) {
                                log.debug((Object)"It is a portlet exception");
                                PortletException e = (PortletException)t;
                                if (t instanceof UnavailableException) {
                                    log.debug((Object)"It is an unavailable exception");
                                    UnavailableException ex = (UnavailableException)e;
                                    if (!ex.isPermanent()) {
                                        log.debug((Object)"but a non permanent one");
                                        this.monitor.setUnavailabilityPeriod(portletAppName, portletName, ex.getUnavailableSeconds());
                                    } else {
                                        log.debug((Object)"a permanent one, so destroy the portlet and broke it");
                                        proxy.destroy(portletName);
                                        this.monitor.brokePortlet(portletAppName, portletName);
                                    }
                                }
                                portletRequest.setAttribute(exception_key, (Object)e);
                                this.processPortletException(t, portletRequest, isAction, exception_key, output);
                                Object var33_30 = null;
                                long endTime = System.currentTimeMillis();
                                PortletRuntimeDatasImpl rtd = this.monitor.getPortletRuntimeData(portletAppName, portletName);
                                if (portletRequest != null) {
                                    if (portletRequest.getPortletSession(false) == null) {
                                        output.addProperty("_invalidate_session_", (Object)"0");
                                    } else {
                                        output.addProperty("_invalidate_session_", (Object)("" + portletRequest.getPortletSession(false).getMaxInactiveInterval()));
                                    }
                                }
                                if (rtd == null) return;
                                if (isAction == 1) {
                                    rtd.logProcessActionRequest(startTime, endTime);
                                    return;
                                }
                                if (isAction == 2) {
                                    rtd.logProcessEventRequest(startTime, endTime);
                                    return;
                                }
                                if (isAction == 3) {
                                    boolean cacheHit = ((ResourceOutput)output).isCacheHit();
                                    rtd.logServeResourceRequest(startTime, endTime, cacheHit);
                                    return;
                                }
                                boolean cacheHit = ((RenderOutput)output).isCacheHit();
                                rtd.logRenderRequest(startTime, endTime, cacheHit);
                                return;
                            }
                            log.debug((Object)"It is not a portlet exception");
                            portletRequest.setAttribute(exception_key, t);
                            this.processPortletException(t, portletRequest, isAction, exception_key, output);
                            Object var33_31 = null;
                            long endTime = System.currentTimeMillis();
                            PortletRuntimeDatasImpl rtd = this.monitor.getPortletRuntimeData(portletAppName, portletName);
                            if (portletRequest != null) {
                                if (portletRequest.getPortletSession(false) == null) {
                                    output.addProperty("_invalidate_session_", (Object)"0");
                                } else {
                                    output.addProperty("_invalidate_session_", (Object)("" + portletRequest.getPortletSession(false).getMaxInactiveInterval()));
                                }
                            }
                            if (rtd == null) return;
                            if (isAction == 1) {
                                rtd.logProcessActionRequest(startTime, endTime);
                                return;
                            }
                            if (isAction == 2) {
                                rtd.logProcessEventRequest(startTime, endTime);
                                return;
                            }
                            if (isAction == 3) {
                                boolean cacheHit = ((ResourceOutput)output).isCacheHit();
                                rtd.logServeResourceRequest(startTime, endTime, cacheHit);
                                return;
                            }
                            boolean cacheHit = ((RenderOutput)output).isCacheHit();
                            rtd.logRenderRequest(startTime, endTime, cacheHit);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var33_33 = null;
                        long endTime = System.currentTimeMillis();
                        PortletRuntimeDatasImpl rtd = this.monitor.getPortletRuntimeData(portletAppName, portletName);
                        if (portletRequest != null) {
                            if (portletRequest.getPortletSession(false) == null) {
                                output.addProperty("_invalidate_session_", (Object)"0");
                            } else {
                                output.addProperty("_invalidate_session_", (Object)("" + portletRequest.getPortletSession(false).getMaxInactiveInterval()));
                            }
                        }
                        if (rtd == null) throw throwable;
                        if (isAction == 1) {
                            rtd.logProcessActionRequest(startTime, endTime);
                            throw throwable;
                        }
                        if (isAction == 2) {
                            rtd.logProcessEventRequest(startTime, endTime);
                            throw throwable;
                        }
                        if (isAction == 3) {
                            boolean cacheHit = ((ResourceOutput)output).isCacheHit();
                            rtd.logServeResourceRequest(startTime, endTime, cacheHit);
                            throw throwable;
                        }
                        boolean cacheHit = ((RenderOutput)output).isCacheHit();
                        rtd.logRenderRequest(startTime, endTime, cacheHit);
                        throw throwable;
                    }
                }
                long endTime = System.currentTimeMillis();
                PortletRuntimeDatasImpl rtd = this.monitor.getPortletRuntimeData(portletAppName, portletName);
                if (portletRequest != null) {
                    if (portletRequest.getPortletSession(false) == null) {
                        output.addProperty("_invalidate_session_", (Object)"0");
                    } else {
                        output.addProperty("_invalidate_session_", (Object)("" + portletRequest.getPortletSession(false).getMaxInactiveInterval()));
                    }
                }
                if (rtd == null) return;
                if (isAction == 1) {
                    rtd.logProcessActionRequest(startTime, endTime);
                    return;
                }
                if (isAction == 2) {
                    rtd.logProcessEventRequest(startTime, endTime);
                    return;
                }
                if (isAction == 3) {
                    boolean cacheHit = ((ResourceOutput)output).isCacheHit();
                    rtd.logServeResourceRequest(startTime, endTime, cacheHit);
                    return;
                }
                boolean cacheHit = ((RenderOutput)output).isCacheHit();
                rtd.logRenderRequest(startTime, endTime, cacheHit);
                return;
            }
            Object var33_27 = null;
            long endTime = System.currentTimeMillis();
            PortletRuntimeDatasImpl rtd = this.monitor.getPortletRuntimeData(portletAppName, portletName);
            if (portletRequest != null) {
                if (portletRequest.getPortletSession(false) == null) {
                    output.addProperty("_invalidate_session_", (Object)"0");
                } else {
                    output.addProperty("_invalidate_session_", (Object)("" + portletRequest.getPortletSession(false).getMaxInactiveInterval()));
                }
            }
            if (rtd == null) return;
            if (isAction == 1) {
                rtd.logProcessActionRequest(startTime, endTime);
                return;
            }
            if (isAction == 2) {
                rtd.logProcessEventRequest(startTime, endTime);
                return;
            }
            if (isAction == 3) {
                boolean cacheHit = ((ResourceOutput)output).isCacheHit();
                rtd.logServeResourceRequest(startTime, endTime, cacheHit);
                return;
            }
            boolean cacheHit = ((RenderOutput)output).isCacheHit();
            rtd.logRenderRequest(startTime, endTime, cacheHit);
            return;
        }
        Object var33_32 = null;
        long endTime = System.currentTimeMillis();
        PortletRuntimeDatasImpl rtd = this.monitor.getPortletRuntimeData(portletAppName, portletName);
        if (portletRequest != null) {
            if (portletRequest.getPortletSession(false) == null) {
                output.addProperty("_invalidate_session_", (Object)"0");
            } else {
                output.addProperty("_invalidate_session_", (Object)("" + portletRequest.getPortletSession(false).getMaxInactiveInterval()));
            }
        }
        if (rtd == null) return;
        if (isAction == 1) {
            rtd.logProcessActionRequest(startTime, endTime);
            return;
        }
        if (isAction == 2) {
            rtd.logProcessEventRequest(startTime, endTime);
            return;
        }
        if (isAction == 3) {
            boolean cacheHit = ((ResourceOutput)output).isCacheHit();
            rtd.logServeResourceRequest(startTime, endTime, cacheHit);
            return;
        }
        boolean cacheHit = ((RenderOutput)output).isCacheHit();
        rtd.logRenderRequest(startTime, endTime, cacheHit);
    }

    private Object getCcppProfile(HttpServletRequest request) {
        return new DummyCcppProfile();
    }

    private void processPortletException(Throwable throwable, PortletRequestImp request, int isAction, String key, Output output) throws PortletContainerException {
        if (!this.conf.isHookPortletExceptions()) {
            throw new PortletProcessingException("", throwable);
        }
        this.generateOutputForException(request, isAction, key, output);
    }

    private void generateOutputForException(PortletRequestImp request, int isAction, String key, Output output) {
        String prop_key = "";
        String prop_output = "";
        String title = "";
        String content = "";
        log.debug((Object)"generate the exception message");
        if (key == null) {
            prop_key = "org.exoplatform.portal.container.destroyed";
            prop_output = "output generated because of a destroyed portlet access";
            title = "Portlet destroyed";
            content = "Portlet unvailable";
        } else {
            Throwable e = (Throwable)request.getAttribute(key);
            prop_key = "org.exoplatform.portal.container.exception";
            prop_output = "output generated because of an exception";
            title = "Exception occured";
            if (e != null) {
                log.debug((Object)("Exception associated : " + e.toString()));
                content = e.toString();
                while (e.getCause() != null) {
                    e = e.getCause();
                    String ce = "Cause: " + e.toString();
                    if (content == null) {
                        content = ce;
                        continue;
                    }
                    content = content + "<br>" + ce;
                }
                if (content == null) {
                    content = prop_output;
                }
                prop_output = content;
            } else {
                log.debug((Object)"No exception associated");
                content = "There is a problem";
            }
        }
        if (isAction == 1 || isAction == 2) {
            output.addProperty(prop_key, (Object)prop_output);
        } else {
            ((RenderOutput)output).setTitle(title);
            try {
                ((RenderOutput)output).setContent(content.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                ((RenderOutput)output).setContent(content.getBytes());
            }
            output.addProperty(prop_key, (Object)prop_output);
        }
    }

    public final ResourceBundle getBundle(String portletAppName, String portletName, Locale locale) {
        Portlet portlet = this.holder.getPortletMetaData(portletAppName, portletName);
        try {
            return this.resourceBundleManager.lookupBundle(portlet, locale);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void processActionRequest(PortletRequestImp request) {
    }

    protected void processEventRequest(PortletRequestImp request) {
    }

    protected void processResourceRequest(PortletRequestImp request) {
    }

    protected void processRenderRequest(PortletRequestImp request) {
    }
}

