/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.portletcontainer.pci.PortletData;
import org.exoplatform.services.portletcontainer.pci.model.Description;
import org.exoplatform.services.portletcontainer.pci.model.DisplayName;
import org.exoplatform.services.portletcontainer.pci.model.ExoPortletPreferences;
import org.exoplatform.services.portletcontainer.pci.model.InitParam;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.SecurityRoleRef;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.pci.model.UserAttribute;
import org.exoplatform.services.portletcontainer.pci.model.UserDataConstraint;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.bundle.ResourceBundleManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletDataImp
implements PortletData {
    protected List<UserAttribute> userAttributes;
    protected Portlet portlet;
    protected UserDataConstraint userDataConstraintType;
    protected ExoContainer cont;
    protected boolean localPortlet;

    public PortletDataImp(ExoContainer cont, Portlet portlet, UserDataConstraint userDataConstraintType, List<UserAttribute> userAttributes, boolean localPortlet) {
        this.cont = cont;
        this.portlet = portlet;
        this.userDataConstraintType = userDataConstraintType;
        this.userAttributes = userAttributes;
        this.localPortlet = localPortlet;
    }

    public final Portlet getWrappedPortletTyped() {
        return this.portlet;
    }

    public final List<DisplayName> getDisplayName() {
        return this.portlet.getDisplayName();
    }

    public final List<SecurityRoleRef> getSecurityRoleRef() {
        return this.portlet.getSecurityRoleRef();
    }

    public final List<InitParam> getInitParam() {
        return this.portlet.getInitParam();
    }

    public final ResourceBundle getPortletInfo(Locale locale) {
        ResourceBundleManager manager = (ResourceBundleManager)this.cont.getComponentInstanceOfType(ResourceBundleManager.class);
        try {
            return manager.lookupBundle(this.portlet, locale);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final List<Supports> getSupports() {
        return this.portlet.getSupports();
    }

    public final List<Description> getDescription() {
        return this.portlet.getDescription();
    }

    public final String getDescription(String lang) {
        return this.portlet.getDescription(lang);
    }

    public final boolean isCacheGlobal() {
        return "true".equalsIgnoreCase(this.portlet.getGlobalCache());
    }

    public final String getExpirationCache() {
        Integer s = this.portlet.getCaching();
        if (s == null) {
            return "0";
        }
        return s.toString();
    }

    public final String getPortletName() {
        return this.portlet.getPortletName();
    }

    public final List<Locale> getSupportedLocale() {
        return this.portlet.getSupportedLocale();
    }

    public final ExoPortletPreferences getPortletPreferences() {
        return this.portlet.getPortletPreferences();
    }

    public final boolean isSecure() {
        return this.userDataConstraintType != null;
    }

    public final List<UserAttribute> getUserAttributes() {
        return this.userAttributes;
    }

    public final List<QName> getSupportedProcessingEvent() {
        if (this.portlet == null) {
            return null;
        }
        return this.portlet.getSupportedProcessingEvent();
    }

    public final List<QName> getSupportedPublishingEvent() {
        return this.portlet.getSupportedPublishingEvent();
    }

    public final List<String> getSupportedPublicRenderParameter() {
        if (this.portlet == null) {
            return null;
        }
        return this.portlet.getSupportedPublicRenderParameter();
    }

    public final Map<String, String[]> getContainerRuntimeOption() {
        return this.portlet.getContainerRuntimeOption();
    }

    public boolean getEscapeXml() {
        if (this.portlet == null) {
            return true;
        }
        return this.portlet.getEscapeXml();
    }

    public boolean isLocalPortlet() {
        return this.localPortlet;
    }
}

