/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.filter;

import java.io.IOException;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.PortletFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import org.exoplatform.services.portletcontainer.pci.model.InitParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletFilterWrapper
implements ActionFilter,
EventFilter,
RenderFilter,
ResourceFilter {
    private final String filterName;
    private final String filterClass;
    private final List<InitParam> initParams;
    private PortletFilter filter;
    private final List<Integer> lifecycle;

    public PortletFilterWrapper(String filterName, String filterClass, List<InitParam> initParams, List<Integer> lifecycle) {
        this.filterName = filterName;
        this.filterClass = filterClass;
        this.initParams = initParams;
        this.lifecycle = lifecycle;
        this.filter = null;
    }

    public final String getFilterName() {
        return this.filterName;
    }

    public final List<InitParam> getInitParam() {
        return this.initParams;
    }

    public final void init(FilterConfig config) throws PortletException {
        if (this.filter == null) {
            try {
                this.filter = (PortletFilter)Thread.currentThread().getContextClassLoader().loadClass(this.filterClass).newInstance();
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
            this.filter.init(config);
        }
    }

    public final void doFilter(ActionRequest request, ActionResponse response, FilterChain chain) throws IOException, PortletException {
        if (this.isLifecycleSupported((PortletRequest)request)) {
            ((ActionFilter)this.filter).doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public final void doFilter(EventRequest request, EventResponse response, FilterChain chain) throws IOException, PortletException {
        if (this.isLifecycleSupported((PortletRequest)request)) {
            ((EventFilter)this.filter).doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public final void doFilter(RenderRequest request, RenderResponse response, FilterChain chain) throws IOException, PortletException {
        if (this.isLifecycleSupported((PortletRequest)request)) {
            ((RenderFilter)this.filter).doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public final void doFilter(ResourceRequest request, ResourceResponse response, FilterChain chain) throws IOException, PortletException {
        if (this.isLifecycleSupported((PortletRequest)request)) {
            ((ResourceFilter)this.filter).doFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isLifecycleSupported(PortletRequest request) {
        for (int cycle : this.lifecycle) {
            if (!(cycle == 0 || request instanceof ActionRequest && cycle == 1 || request instanceof EventRequest && cycle == 2 || request instanceof RenderRequest && cycle == 3) && (!(request instanceof ResourceRequest) || cycle != 4)) continue;
            return true;
        }
        return false;
    }

    public final void destroy() {
        if (this.filter != null) {
            this.filter.destroy();
            this.filter = null;
        }
    }
}

