/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.helpers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.utils.CustomRequestWrapperUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomRequestWrapper
extends HttpServletRequestWrapper {
    public String pathInfo;
    public String servletPath;
    public String query;
    private final String windowId;
    private boolean redirected;
    public String contextPath;
    private Map<String, String[]> parameterMap;
    private boolean noInput;
    private boolean noValues;

    public CustomRequestWrapper(HttpServletRequest httpServletRequest, String windowId) {
        super(httpServletRequest);
        this.windowId = windowId;
        this.parameterMap = httpServletRequest.getParameterMap();
    }

    public final Enumeration<String> getAttributeNames() {
        Enumeration e = super.getAttributeNames();
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            s = CustomRequestWrapperUtil.decodeRequestAttribute(this.windowId, s);
            v.add(s);
        }
        return v.elements();
    }

    public final Object getAttribute(String s) {
        return super.getAttribute(CustomRequestWrapperUtil.encodeAttribute(this.windowId, s));
    }

    public final void removeAttribute(String s) {
        super.removeAttribute(CustomRequestWrapperUtil.encodeAttribute(this.windowId, s));
    }

    public final void setAttribute(String s, Object o) {
        super.setAttribute(CustomRequestWrapperUtil.encodeAttribute(this.windowId, s), o);
    }

    public final Map<String, String[]> getParameterMap() {
        Map superMap = super.getParameterMap();
        if (this.redirected) {
            HashMap<String, String[]> filteredMap = new HashMap<String, String[]>();
            Set keys = superMap.keySet();
            for (String element : keys) {
                if (element.startsWith("portal:")) continue;
                filteredMap.put(element, (String[])superMap.get(element));
            }
            return filteredMap;
        }
        return superMap;
    }

    public final void setParameterMap(Map<String, String[]> map) {
        this.parameterMap = map;
    }

    public final boolean isRedirected() {
        return this.redirected;
    }

    public final void setRedirected(boolean b) {
        this.redirected = b;
    }

    public final int getContentLength() {
        if (this.noValues) {
            return 0;
        }
        if (this.redirected) {
            return -1;
        }
        return super.getContentLength();
    }

    public final StringBuffer getRequestURL() {
        if (this.redirected) {
            return null;
        }
        return super.getRequestURL();
    }

    public final String getCharacterEncoding() {
        if (this.noValues) {
            return null;
        }
        return super.getCharacterEncoding();
    }

    public final String getContentType() {
        if (this.redirected) {
            return null;
        }
        return super.getContentType();
    }

    public final ServletInputStream getInputStream() throws IOException {
        if (this.noInput) {
            return null;
        }
        return super.getInputStream();
    }

    public final BufferedReader getReader() throws IOException {
        if (this.noInput) {
            return null;
        }
        return super.getReader();
    }

    public final String getLocalAddr() {
        if (this.redirected) {
            return null;
        }
        return super.getLocalAddr();
    }

    public final String getLocalName() {
        if (this.redirected) {
            return null;
        }
        return super.getLocalName();
    }

    public final int getLocalPort() {
        if (this.redirected) {
            return 0;
        }
        return super.getLocalPort();
    }

    public final int getRemotePort() {
        if (this.redirected) {
            return 0;
        }
        return super.getRemotePort();
    }

    public final String getRealPath(String arg0) {
        if (this.redirected) {
            return null;
        }
        return super.getRealPath(arg0);
    }

    public final String getRemoteAddr() {
        if (this.redirected) {
            return null;
        }
        return super.getRemoteAddr();
    }

    public final String getRemoteHost() {
        if (this.redirected) {
            return null;
        }
        return super.getRemoteHost();
    }

    public final void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        if (this.redirected) {
            return;
        }
        super.setCharacterEncoding(arg0);
    }

    public final String getProtocol() {
        if (this.redirected) {
            return "HTTP/1.1";
        }
        return super.getProtocol();
    }

    public final HttpSession getSession() {
        return this.getSession(true);
    }

    public final HttpSession getSession(boolean b) {
        return super.getSession(b);
    }

    public final boolean isRequestedSessionIdValid() {
        return super.isRequestedSessionIdValid();
    }

    public final void setContextPath(String string) {
        this.contextPath = string;
    }

    public final String getContextPath() {
        if (this.redirected && this.contextPath != null) {
            return this.contextPath;
        }
        return super.getContextPath();
    }

    public final void setRedirectedPath(String path) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        String[] key = StringUtils.split((String)path, (String)"?");
        String firstPart = "";
        if (key.length > 1) {
            this.query = key[1];
            firstPart = key[0];
        } else {
            firstPart = path;
        }
        if (firstPart.indexOf("/", 1) > 0) {
            this.servletPath = firstPart.substring(0, firstPart.indexOf("/", 1));
            this.pathInfo = firstPart.substring(firstPart.indexOf("/", 1));
        } else {
            this.servletPath = firstPart;
            this.pathInfo = null;
        }
    }

    public final String getPathInfo() {
        if (this.redirected) {
            return this.pathInfo;
        }
        return super.getPathInfo();
    }

    public final String getServletPath() {
        if (this.redirected) {
            return this.servletPath;
        }
        return super.getServletPath();
    }

    public final String getQueryString() {
        if (this.redirected) {
            return this.query;
        }
        return super.getQueryString();
    }

    public final String getRequestURI() {
        if (this.redirected) {
            return this.getContextPath() + (this.servletPath == null ? "" : this.servletPath) + (this.pathInfo == null ? "" : this.pathInfo);
        }
        return super.getRequestURI();
    }

    public final void setNoInput(boolean noInput) {
        this.noInput = noInput;
    }

    public final void setNoValues(boolean noValues) {
        this.noValues = noValues;
    }
}

