/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.filter.FilterChain;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.PortletApplicationRegister;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.services.portletcontainer.PortletLifecycleListener;
import org.exoplatform.services.portletcontainer.pci.model.Filter;
import org.exoplatform.services.portletcontainer.pci.model.FilterMapping;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletApplicationProxy;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletApplicationsHolder;
import org.exoplatform.services.portletcontainer.plugins.pc.filter.PortletFilterChainImpl;
import org.exoplatform.services.portletcontainer.plugins.pc.filter.PortletFilterWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletApplicationRegisterImpl
implements PortletApplicationRegister {
    private final Collection<PortletLifecycleListener> listeners = new ArrayList<PortletLifecycleListener>();
    private final Log log;
    private final PortletApplicationsHolder holder;
    protected ExoContainer appcont;

    public PortletApplicationRegisterImpl(ExoContainerContext context, PortletApplicationsHolder holder) {
        this.holder = holder;
        this.log = ExoLogger.getLogger(this.getClass());
        this.appcont = ExoContainerContext.getCurrentContainer();
    }

    public final void addListenerPlugin(ComponentPlugin listener) {
        if (!(listener instanceof PortletLifecycleListener)) {
            throw new RuntimeException("Expect listener of type PortletLifecycleListener");
        }
        this.listeners.add((PortletLifecycleListener)listener);
    }

    public final ComponentPlugin removeListener(String name) {
        return null;
    }

    public final Collection<PortletLifecycleListener> getListeners() {
        return this.listeners;
    }

    public final void registerPortletApplication(ServletContext servletContext, PortletApp portletApp_, Collection<String> roles, String portletAppName) throws PortletContainerException {
        this.log.debug((Object)("send pre deploy event for portlet app : " + servletContext.getServletContextName()));
        for (PortletLifecycleListener portletLifecycleListener : this.listeners) {
            portletLifecycleListener.preDeploy(portletAppName, portletApp_, servletContext);
        }
        this.holder.registerPortletApplication(portletAppName, portletApp_, roles);
        this.createFilterChains(portletApp_);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            this.appcont.registerComponentImplementation((Object)(portletAppName + "_portlet_app_"), cl.loadClass("org.exoplatform.services.portletcontainer.plugins.pc.PortletApplicationProxy"));
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)"Class not found", (Throwable)e);
            throw new PortletContainerException("Class not found", (Throwable)e);
        }
        PortletApplicationProxy proxy = (PortletApplicationProxy)this.appcont.getComponentInstance((Object)(portletAppName + "_portlet_app_"));
        proxy.setApplicationName(portletAppName);
        proxy.load();
        this.log.debug((Object)"send post deploy event");
        for (PortletLifecycleListener portletLifecycleListener : this.listeners) {
            portletLifecycleListener.postDeploy(portletAppName, portletApp_, servletContext);
        }
    }

    public final void removePortletApplication(ServletContext servletContext, String portletAppName) throws PortletContainerException {
        PortletApp portletApp = this.holder.getPortletApplication(portletAppName);
        if (portletApp == null) {
            return;
        }
        this.log.debug((Object)"send pre undeploy event");
        for (PortletLifecycleListener portletLifecycleListener : this.listeners) {
            portletLifecycleListener.preUndeploy(portletAppName, portletApp, servletContext);
        }
        this.appcont.unregisterComponent((Object)(portletAppName + "_portlet_app_"));
        this.holder.removePortletApplication(portletAppName);
        this.removeFilters(portletAppName, portletApp);
        this.log.debug((Object)"send post undeploy event");
        for (PortletLifecycleListener portletLifecycleListener : this.listeners) {
            portletLifecycleListener.postUndeploy(portletAppName, portletApp, servletContext);
        }
    }

    private void createFilterChains(PortletApp portletApp) throws PortletContainerException {
        this.log.debug((Object)"create filter chains entered");
        List filterList = portletApp.getFilter();
        HashMap<String, PortletFilterWrapper> filters = new HashMap<String, PortletFilterWrapper>();
        for (Filter filter : filterList) {
            filters.put(filter.getFilterName(), new PortletFilterWrapper(filter.getFilterName(), filter.getFilterClass(), filter.getInitParam(), filter.getLifecycle()));
        }
        List portlets = portletApp.getPortlet();
        Iterator iterator = portlets.iterator();
        while (iterator.hasNext()) {
            ArrayList<PortletFilterWrapper> chain = new ArrayList<PortletFilterWrapper>();
            Portlet portlet = (Portlet)iterator.next();
            List mappings = portletApp.getFilterMapping();
            for (FilterMapping mapping : mappings) {
                List portletName = mapping.getPortletName();
                for (String onePortletName : portletName) {
                    if (!onePortletName.equals("*") && !onePortletName.equals(portlet.getPortletName()) && (!onePortletName.endsWith("*") || !portlet.getPortletName().startsWith(onePortletName.substring(0, onePortletName.length() - 1)))) continue;
                    PortletFilterWrapper filter = (PortletFilterWrapper)filters.get(mapping.getFilterName());
                    chain.add(filter);
                }
            }
            portlet.setFilterChain((FilterChain)new PortletFilterChainImpl(chain));
        }
        portletApp.setUrlListeners(this.createUrlListeners(portletApp.getUrlGenerationListener()));
    }

    private List<PortletURLGenerationListener> createUrlListeners(List<String> urlGenerationListener) throws PortletContainerException {
        if (urlGenerationListener == null) {
            return null;
        }
        ArrayList<PortletURLGenerationListener> list = new ArrayList<PortletURLGenerationListener>();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (String string : urlGenerationListener) {
            try {
                PortletURLGenerationListener obj = (PortletURLGenerationListener)cl.loadClass(string).newInstance();
                list.add(obj);
            }
            catch (Exception e) {
                this.log.error((Object)"Class not found", (Throwable)e);
                throw new PortletContainerException("Class not found", (Throwable)e);
            }
        }
        return list;
    }

    private void removeFilters(String portletAppName, PortletApp portletApp) {
        this.log.debug((Object)"remove filters entered");
        List portlets = portletApp.getPortlet();
        for (Portlet portlet : portlets) {
            PortletFilterChainImpl chain = (PortletFilterChainImpl)portlet.getFilterChain();
            Iterator<PortletFilterWrapper> iter = chain.getFiltersIterator();
            while (iter.hasNext()) {
                PortletFilterWrapper filter = iter.next();
                filter.destroy();
            }
        }
    }
}

