/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.impl.servlet;

import com.sun.org.apache.xerces.internal.dom.DOMInputImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.xml.ExoXPPParser;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.PortletApplicationRegister;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;
import org.exoplatform.services.portletcontainer.pci.model.XMLParser;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class PortletApplicationListener
implements ServletContextListener {
    private static Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
    private static String fileWebXML = "/WEB-INF/web.xml";
    private static String filePortletXML = "/WEB-INF/portlet.xml";
    private static String fileXMLXSD = "javax/servlet/resources/xml.xsd";
    private static String fileXMLSchemaDTD = "javax/servlet/resources/XMLSchema.dtd";
    private static String fileDatatypesDTD = "javax/servlet/resources/datatypes.dtd";
    protected ServletContext hServletContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void contextInitialized(ServletContextEvent servletContextEvent) {
        String oldParser;
        block13: {
            block12: {
                ExoContainer manager = ExoContainerContext.getTopContainer();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Getting context path");
                }
                String portletAppName = this.getContextPath(servletContextEvent);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Context path:" + portletAppName));
                }
                ServletContext servletContext = servletContextEvent.getServletContext();
                this.hServletContext = servletContextEvent.getServletContext();
                log.info((Object)("DEPLOY PORTLET APPLICATION: " + portletAppName));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Real path : " + servletContext.getRealPath("")));
                }
                InputStream is = null;
                oldParser = System.getProperty("javax.xml.parsers.DocumentBuilderFactory");
                try {
                    try {
                        String spec = this.validationPortletXML(servletContext);
                        if (spec == null) {
                            Object var13_9 = null;
                            if (oldParser == null) return;
                            break block12;
                        }
                        is = servletContext.getResourceAsStream(filePortletXML);
                        log.info((Object)("The portlet.xml file valid portlet spec " + spec));
                        PortletApp portletApp = XMLParser.parse((InputStream)is, (boolean)(spec.equalsIgnoreCase("2") ? Boolean.TRUE : Boolean.FALSE));
                        is = servletContext.getResourceAsStream(fileWebXML);
                        ArrayList<String> roles = new ArrayList<String>();
                        ExoXPPParser xpp = ExoXPPParser.getInstance();
                        xpp.setInput(is, "UTF8");
                        xpp.mandatoryNode("web-app");
                        while (!xpp.node("security-role") && xpp.getEventType() != 1) {
                            xpp.next();
                        }
                        if (xpp.node("role-name")) {
                            roles.add(xpp.getContent());
                            while (xpp.node("security-role")) {
                                roles.add(xpp.mandatoryNodeContent("role-name"));
                            }
                        }
                        log.info((Object)("  -- read: " + portletApp.getPortlet().size() + " portlets"));
                        PortletApplicationRegister service = (PortletApplicationRegister)manager.getComponentInstanceOfType(PortletApplicationRegister.class);
                        service.registerPortletApplication(servletContext, portletApp, roles, portletAppName);
                        break block13;
                    }
                    catch (Exception e) {
                        log.error((Object)("Cannot deploy " + portletAppName), (Throwable)e);
                        Object var13_11 = null;
                        if (oldParser == null) return;
                        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", oldParser);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_12 = null;
                    if (oldParser == null) throw throwable;
                    System.setProperty("javax.xml.parsers.DocumentBuilderFactory", oldParser);
                    throw throwable;
                }
            }
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", oldParser);
            return;
        }
        Object var13_10 = null;
        if (oldParser == null) return;
        System.setProperty("javax.xml.parsers.DocumentBuilderFactory", oldParser);
    }

    public final void contextDestroyed(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        String portletAppName = this.getContextPath(servletContextEvent);
        ExoContainer manager = ExoContainerContext.getTopContainer();
        log.info((Object)("UNDEPLOY PORTLET APPLICATION: " + portletAppName));
        try {
            PortletApplicationRegister service = (PortletApplicationRegister)manager.getComponentInstanceOfType(PortletApplicationRegister.class);
            service.removePortletApplication(servletContext, portletAppName);
        }
        catch (Exception e) {
            log.error((Object)("UNDEPLOY PORTLET APPLICATION: " + e));
        }
    }

    private String getContextPath(ServletContextEvent servletContextEvent) {
        String portletAppName = null;
        try {
            portletAppName = (String)ServletContext.class.getMethod("getContextPath", new Class[0]).invoke((Object)servletContextEvent.getServletContext(), (Object[])new Class[0]);
            portletAppName = portletAppName.substring(portletAppName.lastIndexOf("/") + 1);
            return portletAppName;
        }
        catch (Exception e) {
            log.warn((Object)"Servlet api 2.4 or below detected. Unable to find method getContextPath on ServletContext.");
            if (portletAppName == null) {
                try {
                    URL webXmlUrl = servletContextEvent.getServletContext().getResource(fileWebXML);
                    portletAppName = webXmlUrl.toExternalForm();
                    portletAppName = portletAppName.substring(0, portletAppName.indexOf(fileWebXML));
                    int id = portletAppName.indexOf(".war");
                    if (id > 0) {
                        portletAppName = portletAppName.substring(0, id);
                    }
                    portletAppName = portletAppName.substring(portletAppName.lastIndexOf("/") + 1);
                    return portletAppName;
                }
                catch (MalformedURLException e2) {
                    log.error((Object)"Erorr getting web.xml from ServletContext.");
                }
            }
            return portletAppName;
        }
    }

    private String validationPortletXML(ServletContext servletContext) {
        String errWithoutInet;
        InputStream is = servletContext.getResourceAsStream(filePortletXML);
        if (is == null) {
            log.info((Object)"PORTLET CONFIGURATION IS NOT FOUND, IGNORE THE PACKAGE");
            return null;
        }
        try {
            is.close();
        }
        catch (IOException e) {
            log.error((Object)e.getCause());
        }
        String specErr1 = null;
        String specErr2 = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Defining portlet specification");
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        StreamSource source = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"validation 1-st portlet spec");
            }
            source = new StreamSource(servletContext.getResourceAsStream(filePortletXML));
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource schemaFile = new StreamSource(cl.getResourceAsStream("portlet-app_1_0.xsd"));
            factory.setResourceResolver(new PCResourceResolverImpl());
            Schema schema = factory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            validator.validate(source);
            return "1";
        }
        catch (SAXException e) {
            specErr1 = e.getMessage();
        }
        catch (IOException e) {
            specErr1 = e.getMessage();
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"validation 2-nd portlet spec");
            }
            source = new StreamSource(servletContext.getResourceAsStream(filePortletXML));
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource schemaFile = new StreamSource(cl.getResourceAsStream("portlet-app_2_0.xsd"));
            factory.setResourceResolver(new PCResourceResolverImpl());
            Schema schema = factory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            validator.validate(source);
            return "2";
        }
        catch (SAXException e) {
            specErr2 = e.getMessage();
        }
        catch (IOException e) {
            specErr2 = e.getMessage();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Checking that was the error reason internet connection problem.");
        }
        if (specErr1.contains(errWithoutInet = "src-resolve: Cannot resolve the name 'xml:lang' to a(n) 'attribute declaration' component.") && specErr2.contains(errWithoutInet)) {
            log.info((Object)"Validation portlet.xml warning: please check your internet connection.");
            StringBuffer out = new StringBuffer();
            byte[] b = new byte[4096];
            try {
                int n;
                is = servletContext.getResourceAsStream(filePortletXML);
                while ((n = is.read(b)) != -1) {
                    out.append(new String(b, 0, n));
                }
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String str = out.toString();
            int i1 = str.indexOf("portlet-app");
            int i2 = str.indexOf(">", i1);
            String s = str.substring(i1, i2);
            int res1 = s.indexOf("portlet-app_1_0.xsd");
            if (res1 > 0) {
                return "1";
            }
            int res2 = s.indexOf("portlet-app_2_0.xsd");
            if (res2 > 0) {
                return "2";
            }
        }
        log.error((Object)"The portlet.xml doesn't valid portlet spec 1 and 2");
        if (specErr1 != null) {
            log.error((Object)("Validation 1-st portlet spec: " + specErr1));
        }
        if (specErr2 != null) {
            log.error((Object)("Validation 2-nd portlet spec: " + specErr2));
        }
        return null;
    }

    class PCResourceResolverImpl
    implements LSResourceResolver {
        private final Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");

        public final LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            try {
                if (systemId.equals("http://www.w3.org/2001/xml.xsd")) {
                    DOMInputImpl lsInput = new DOMInputImpl();
                    InputStream is = null;
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    ArrayList<URL> c = Collections.list(cl.getResources(fileXMLXSD));
                    for (URL url : c) {
                        is = url.openStream();
                        if (is == null) continue;
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug((Object)("Have got the : " + fileXMLXSD + ", url = " + url + ", key = " + url.toString()));
                        break;
                    }
                    lsInput.setByteStream(is);
                    return lsInput;
                }
                if (systemId.equals("XMLSchema.dtd")) {
                    DOMInputImpl lsInput = new DOMInputImpl();
                    InputStream is = null;
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    ArrayList<URL> c = Collections.list(cl.getResources(fileXMLSchemaDTD));
                    for (URL url : c) {
                        is = url.openStream();
                        if (is == null) continue;
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug((Object)("Have got the : " + fileXMLSchemaDTD + ", url = " + url + ", key = " + url.toString()));
                        break;
                    }
                    lsInput.setByteStream(is);
                    return lsInput;
                }
                if (systemId.equals("datatypes.dtd")) {
                    DOMInputImpl lsInput = new DOMInputImpl();
                    InputStream is = null;
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    ArrayList<URL> c = Collections.list(cl.getResources(fileDatatypesDTD));
                    for (URL url : c) {
                        is = url.openStream();
                        if (is == null) continue;
                        if (!this.log.isDebugEnabled()) break;
                        this.log.debug((Object)("Have got the : " + fileDatatypesDTD + ", url = " + url + ", key = " + url.toString()));
                        break;
                    }
                    lsInput.setByteStream(is);
                    return lsInput;
                }
            }
            catch (Exception e) {
                System.out.println(e.getCause());
            }
            return null;
        }
    }
}

