/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.monitor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.monitor.CachedData;
import org.exoplatform.services.portletcontainer.monitor.PortletContainerMonitor;
import org.exoplatform.services.portletcontainer.monitor.PortletRuntimeData;
import org.exoplatform.services.portletcontainer.plugins.pc.monitor.CachedDataImpl;
import org.exoplatform.services.portletcontainer.plugins.pc.monitor.PortletRuntimeDatasImpl;

public class PortletContainerMonitorImpl
implements PortletContainerMonitor {
    public static final char SEPARATOR = '/';
    public static Map versionNumberMap = new HashMap();
    private final Map runtimeDatas;
    private final Map destroyedPortlets;
    private final Map brokenPortlets;
    private final Log log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
    private final ExoCache globalCache;
    private final CacheService cacheService;

    public PortletContainerMonitorImpl(CacheService cacheService) throws Exception {
        this.cacheService = cacheService;
        this.globalCache = cacheService.getCacheInstance("jsr286:forAll");
        this.runtimeDatas = Collections.synchronizedMap(new HashMap());
        this.brokenPortlets = Collections.synchronizedMap(new HashMap());
        this.destroyedPortlets = Collections.synchronizedMap(new HashMap());
    }

    public final Map getPortletRuntimeDataMap() {
        return this.runtimeDatas;
    }

    public final PortletRuntimeDatasImpl getPortletRuntimeData(String appName, String portletName) {
        return (PortletRuntimeDatasImpl)this.runtimeDatas.get(appName + '/' + portletName);
    }

    public final synchronized void registerPortletApp(String portletApplicationName) {
        long versionNumber = 1L;
        if (versionNumberMap.get(portletApplicationName) != null) {
            versionNumber = (Long)versionNumberMap.get(portletApplicationName) + 1L;
        }
        versionNumberMap.put(portletApplicationName, new Long(versionNumber));
    }

    public final long getPortletVersionNumber(String portletAppName) {
        return (Long)versionNumberMap.get(portletAppName);
    }

    public final synchronized void register(String portletApplicationName, String portletName) {
        PortletRuntimeDatasImpl rD = new PortletRuntimeDatasImpl(portletApplicationName, portletName, this.cacheService, this.globalCache, this.log);
        this.runtimeDatas.put(portletApplicationName + '/' + portletName, rD);
        this.brokenPortlets.remove(portletApplicationName + '/' + portletName);
        this.destroyedPortlets.remove(portletApplicationName + '/' + portletName);
    }

    public final boolean isInitialized(String portletAppName, String portletName) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas.get(portletAppName + '/' + portletName);
        if (datas == null) {
            return false;
        }
        return datas.isInitialized();
    }

    public final synchronized void init(String portletAppName, String portletName, int cacheExpirationTime) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletAppName + '/' + portletName);
        datas.setInitialized(true);
        datas.setCacheExpirationPeriod(cacheExpirationTime);
    }

    public final synchronized void brokePortlet(String portletAppName, String portletName) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas.get(portletAppName + '/' + portletName);
        if (datas == null) {
            datas = (PortletRuntimeData)this.destroyedPortlets.get(portletAppName + '/' + portletName);
            this.destroyedPortlets.remove(portletAppName + '/' + portletName);
        }
        this.runtimeDatas.remove(portletAppName + '/' + portletName);
        this.brokenPortlets.put(portletAppName + '/' + portletName, datas);
    }

    public final boolean isBroken(String portletAppName, String portletName) {
        PortletRuntimeData datas = (PortletRuntimeData)this.brokenPortlets.get(portletAppName + '/' + portletName);
        return datas != null;
    }

    public final boolean isDestroyed(String portletAppName, String portletName) {
        PortletRuntimeData datas = (PortletRuntimeData)this.destroyedPortlets.get(portletAppName + '/' + portletName);
        return datas != null;
    }

    public final boolean isAvailable(String portletApplicationName, String portletName, long l) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletApplicationName + '/' + portletName);
        if (datas == null) {
            return false;
        }
        return datas.isAvailable(l);
    }

    public final boolean isAvailable(String portletApplicationName, String portletName) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletApplicationName + '/' + portletName);
        if (datas == null) {
            return false;
        }
        return datas.isAvailable(System.currentTimeMillis());
    }

    public final long whenAvailable(String portletApplicationName, String portletName) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletApplicationName + '/' + portletName);
        if (datas == null) {
            return -1L;
        }
        if (datas.isAvailable(System.currentTimeMillis())) {
            return 0L;
        }
        return datas.whenAvailable();
    }

    public final boolean isInitialisationAllowed(String portletApplicationName, String portletName, long l) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletApplicationName + '/' + portletName);
        if (datas == null) {
            return false;
        }
        return datas.isInitialisationAllowed(l);
    }

    public final synchronized void destroy(String portletApplicationName, String portletName) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas.get(portletApplicationName + '/' + portletName);
        if (datas == null) {
            return;
        }
        this.runtimeDatas.remove(portletApplicationName + '/' + portletName);
        this.destroyedPortlets.put(portletApplicationName + '/' + portletName, datas);
    }

    public final void setLastAccessTime(String portletAppName, String portletName, long l) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletAppName + '/' + portletName);
        if (datas == null) {
            datas = (PortletRuntimeDatasImpl)this.brokenPortlets.get(portletAppName + '/' + portletName);
        }
        if (datas == null) {
            datas = (PortletRuntimeDatasImpl)this.destroyedPortlets.get(portletAppName + '/' + portletName);
        }
        datas.setLastAccessTime(l);
    }

    public final void setLastInitFailureAccessTime(String portletAppName, String portletName, long l) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas.get(portletAppName + '/' + portletName);
        datas.setLastInitFailureAccessTime(l);
    }

    public final void setLastFailureAccessTime(String portletAppName, String portletName, long l) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletAppName + '/' + portletName);
        datas.setLastFailureAccessTime(l);
    }

    public final void setUnavailabilityPeriod(String portletAppName, String portletName, int unavailableSeconds) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletAppName + '/' + portletName);
        datas.setUnavailabilityPeriod(unavailableSeconds * 1000);
    }

    public final boolean isDataCached(String portletApplicationName, String portletName, String key, boolean isCacheGlobal) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas.get(portletApplicationName + '/' + portletName);
        return datas.isDataCached(key, isCacheGlobal);
    }

    public final void removeCachedData(String portletApplicationName, String portletName, String key, boolean isCacheGlobal) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletApplicationName + '/' + portletName);
        datas.removeCachedData(key, isCacheGlobal);
    }

    public final int getCacheExpirationPeriod(String portletApplicationName, String portletName) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas.get(portletApplicationName + '/' + portletName);
        return datas.getCacheExpirationPeriod();
    }

    public final void setCacheExpirationPeriod(String portletAppName, String portletName, int i) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletAppName + '/' + portletName);
        datas.setCacheExpirationPeriod(i);
    }

    public final long getPortletLastAccessTime(String portletAppName, String portletName, String key, boolean isCacheGlobal) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletAppName + '/' + portletName);
        CachedData cachedData = datas.getCachedData(key, isCacheGlobal);
        if (cachedData != null) {
            return ((CachedDataImpl)cachedData).getLastAccessTime();
        }
        return 0L;
    }

    public final long getPortletLastCacheUpdateTime(String portletAppName, String portletName, String key, boolean isCacheGlobal) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletAppName + '/' + portletName);
        CachedData cachedData = datas.getCachedData(key, isCacheGlobal);
        if (cachedData != null) {
            return ((CachedDataImpl)cachedData).getLastUpdateTime();
        }
        return 0L;
    }

    public final void setPortletLastAccessTime(String portletAppName, String portletName, String key, long lastAccessTime, boolean isCacheGlobal) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletAppName + '/' + portletName);
        CachedDataImpl cachedData = (CachedDataImpl)datas.getCachedData(key, isCacheGlobal);
        if (cachedData == null) {
            cachedData = new CachedDataImpl();
            cachedData.setLastAccessTime(lastAccessTime);
            datas.setCachedData(key, cachedData, isCacheGlobal);
        } else {
            cachedData.setLastAccessTime(lastAccessTime);
        }
    }

    public final void setCachedTitle(String portletAppName, String portletName, String key, String title, boolean isCacheGlobal) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletAppName + '/' + portletName);
        CachedDataImpl cachedData = (CachedDataImpl)datas.getCachedData(key, isCacheGlobal);
        if (cachedData == null) {
            cachedData = new CachedDataImpl();
            cachedData.setTitle(title);
            datas.setCachedData(key, cachedData, isCacheGlobal);
        } else {
            cachedData.setTitle(title);
        }
    }

    public final String getCachedTitle(String portletAppName, String portletName, String key, boolean isCacheGlobal) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas.get(portletAppName + '/' + portletName);
        CachedData cachedData = datas.getCachedData(key, isCacheGlobal);
        if (cachedData != null) {
            return cachedData.getTitle();
        }
        return null;
    }

    public final void setCachedETag(String portletAppName, String portletName, String key, String etag, boolean isCacheGlobal) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletAppName + '/' + portletName);
        CachedDataImpl cachedData = (CachedDataImpl)datas.getCachedData(key, isCacheGlobal);
        if (cachedData == null) {
            cachedData = new CachedDataImpl();
            cachedData.setETag(etag);
            datas.setCachedData(key, cachedData, isCacheGlobal);
        } else {
            cachedData.setETag(etag);
        }
    }

    public final String getCachedETag(String portletAppName, String portletName, String key, boolean isCacheGlobal) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas.get(portletAppName + '/' + portletName);
        CachedData cachedData = datas.getCachedData(key, isCacheGlobal);
        if (cachedData != null) {
            return cachedData.getETag();
        }
        return null;
    }

    public final void setCachedContent(String portletAppName, String portletName, String key, byte[] content, boolean isCacheGlobal) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletAppName + '/' + portletName);
        CachedDataImpl cachedData = (CachedDataImpl)datas.getCachedData(key, isCacheGlobal);
        if (cachedData == null) {
            cachedData = new CachedDataImpl();
            cachedData.setContent(content);
            datas.setCachedData(key, cachedData, isCacheGlobal);
        } else {
            cachedData.setContent(content);
        }
        cachedData.setLastUpdateTime(System.currentTimeMillis());
    }

    public final byte[] getCachedContent(String portletAppName, String portletName, String key, boolean isCacheGlobal) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas.get(portletAppName + '/' + portletName);
        CachedData cachedData = datas.getCachedData(key, isCacheGlobal);
        if (cachedData != null) {
            return cachedData.getContent();
        }
        return null;
    }

    public final void setCachedMode(String portletAppName, String portletName, String key, PortletMode mode, boolean isCacheGlobal) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletAppName + '/' + portletName);
        CachedDataImpl cachedData = (CachedDataImpl)datas.getCachedData(key, isCacheGlobal);
        if (cachedData == null) {
            cachedData = new CachedDataImpl();
            cachedData.setMode(mode);
            datas.setCachedData(key, cachedData, isCacheGlobal);
        } else {
            cachedData.setMode(mode);
        }
    }

    public final void setCachedWindowState(String portletAppName, String portletName, String key, WindowState window, boolean isCacheGlobal) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletAppName + '/' + portletName);
        CachedDataImpl cachedData = (CachedDataImpl)datas.getCachedData(key, isCacheGlobal);
        if (cachedData == null) {
            cachedData = new CachedDataImpl();
            cachedData.setWindowState(window);
            datas.setCachedData(key, cachedData, isCacheGlobal);
        } else {
            cachedData.setWindowState(window);
        }
    }

    public final boolean needsCacheInvalidation(String portletAppName, String portletName, String key, PortletMode mode, WindowState window, boolean isCacheGlobal) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas.get(portletAppName + '/' + portletName);
        CachedData cachedData = datas.getCachedData(key, isCacheGlobal);
        if (cachedData == null) {
            return false;
        }
        return cachedData.getMode() != mode || cachedData.getWindowState() != window;
    }

    public final void setInitializationTime(String portletAppName, String portletName, long accessTime) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletAppName + '/' + portletName);
        datas.setInitializationTime(accessTime);
    }

    public final long getInitializationTime(String portletAppName, String portletName) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas.get(portletAppName + '/' + portletName);
        return datas.getInitializationTime();
    }

    public final String getCacheScope(String portletApplicationName, String portletName) {
        PortletRuntimeData datas = (PortletRuntimeData)this.runtimeDatas.get(portletApplicationName + '/' + portletName);
        return datas.getCacheScope();
    }

    public final void setCacheScope(String portletAppName, String portletName, String s) {
        PortletRuntimeDatasImpl datas = (PortletRuntimeDatasImpl)this.runtimeDatas.get(portletAppName + '/' + portletName);
        datas.setCacheScope(s);
    }
}

