/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PreferencesValidator;
import javax.portlet.UnavailableException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.pci.model.ExoPortletPreferences;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;
import org.exoplatform.services.portletcontainer.plugins.pc.PortletApplicationsHolder;
import org.exoplatform.services.portletcontainer.plugins.pc.monitor.PortletContainerMonitorImpl;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletConfigImp;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;
import org.picocontainer.Startable;
import org.picocontainer.defaults.DefaultPicoContainer;

public class PortletApplicationProxy
implements Startable {
    private static final int WAITING_TIME_BEFORE_DESTROY = 50;
    PortletApplicationsHolder holder_;
    private String portletAppName_;
    private Map configs_;
    private PortletContainerMonitorImpl monitor_;
    private Log log_;
    private MutablePicoContainer pico_;

    public PortletApplicationProxy(ExoContainerContext context, PortletApplicationsHolder holder, PortletContainerMonitorImpl monitor) {
        this.holder_ = holder;
        this.monitor_ = monitor;
        this.configs_ = new HashMap();
        this.log_ = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
        this.pico_ = new DefaultPicoContainer((PicoContainer)context.getContainer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public javax.portlet.Portlet getPortlet(PortletContext portletContext, String portletName) throws PortletException {
        this.log_.debug((Object)"getPortlet() in PortletApplicationProxy entered");
        PortletContainerMonitorImpl portletContainerMonitorImpl = this.monitor_;
        synchronized (portletContainerMonitorImpl) {
            if (!this.monitor_.isInitialized(this.portletAppName_, portletName)) {
                this.log_.debug((Object)"init monitor");
                this.init(this.monitor_, portletName, portletContext);
            }
        }
        return (javax.portlet.Portlet)this.pico_.getComponentInstance((Object)(this.portletAppName_ + "_portlet_" + portletName));
    }

    private void init(PortletContainerMonitorImpl monitor, String portletName, PortletContext portletContext) throws PortletException {
        long accessTime = System.currentTimeMillis();
        if (!monitor.isInitialisationAllowed(this.portletAppName_, portletName, accessTime)) {
            throw new UnavailableException("Portlet initialization not possible");
        }
        Portlet portletDatas = this.holder_.getPortletMetaData(this.portletAppName_, portletName);
        PortletApp portletApp = this.holder_.getPortletApplication(this.portletAppName_);
        PortletConfigImp config = new PortletConfigImp(portletDatas, portletContext, portletApp.getSecurityConstraint(), portletApp.getUserAttribute(), portletApp.getCustomPortletMode(), portletApp.getCustomWindowState(), portletApp.getDefaultNamespace());
        try {
            if (this.pico_.getComponentInstance((Object)(this.portletAppName_ + "_portlet_" + portletDatas.getPortletName())) == null) {
                this.log_.debug((Object)("First registration of portlet : " + this.portletAppName_ + "/" + portletName));
                this.registerPortlet(portletDatas.getPortletName());
            }
            ((javax.portlet.Portlet)this.pico_.getComponentInstance((Object)(this.portletAppName_ + "_portlet_" + portletDatas.getPortletName()))).init((PortletConfig)config);
            this.configs_.put(portletDatas.getPortletName(), config);
            Integer expirationStr = portletDatas.getCaching();
            int expiration = 0;
            if (expirationStr != null) {
                expiration = expirationStr;
            }
            monitor.init(this.portletAppName_, portletName, expiration);
            monitor.setInitializationTime(this.portletAppName_, portletName, accessTime);
        }
        catch (Throwable t) {
            this.log_.error((Object)("exception while initializing portlet : " + portletName), t);
            monitor.setLastInitFailureAccessTime(this.portletAppName_, portletName, accessTime);
            this.releasePortlet(portletName);
            if (t instanceof UnavailableException) {
                UnavailableException e = (UnavailableException)t;
                if (!e.isPermanent()) {
                    monitor.setUnavailabilityPeriod(this.portletAppName_, portletName, e.getUnavailableSeconds());
                }
                throw e;
            }
            throw new PortletException("exception while initializing portlet", t);
        }
    }

    public PortletConfig getPortletConfig(String portletName) {
        return (PortletConfig)this.configs_.get(portletName);
    }

    private void registerPortlet(String key) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            this.pico_.registerComponentImplementation((Object)(this.portletAppName_ + "_portlet_" + key), cl.loadClass(this.getPortletClassName(key)));
        }
        catch (Exception e) {
            this.log_.error((Object)("Can not register portlet : " + key), (Throwable)e);
        }
    }

    private String getPortletClassName(String portletName) {
        PortletApp portletApp = this.holder_.getPortletApplication(this.portletAppName_);
        List portletMetaDataList = portletApp.getPortlet();
        for (Portlet portlet : portletMetaDataList) {
            if (!portlet.getPortletName().equals(portletName)) continue;
            return portlet.getPortletClass();
        }
        return null;
    }

    private void releasePortlet(String portletName) {
        try {
            this.pico_.unregisterComponent((Object)(this.portletAppName_ + "_portlet_" + portletName));
        }
        catch (Exception e) {
            this.log_.error((Object)("Can not release portlet : " + portletName), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(String portletName) {
        try {
            boolean everLoaded = false;
            PortletContainerMonitorImpl portletContainerMonitorImpl = this.monitor_;
            synchronized (portletContainerMonitorImpl) {
                everLoaded = this.monitor_.isInitialized(this.portletAppName_, portletName);
                this.log_.debug((Object)("Was the portlet : " + this.portletAppName_ + "/" + portletName + " ever loaded : " + everLoaded));
                this.monitor_.destroy(this.portletAppName_, portletName);
            }
            if (!everLoaded) {
                return;
            }
            if (this.pico_.getComponentInstance((Object)(this.portletAppName_ + "_portlet_" + portletName)) == null) {
                this.log_.debug((Object)"The portlet is already destroyed or in broken state");
                return;
            }
            this.log_.debug((Object)"Wait 50 seconds before destroying the portlet");
            Thread.sleep(50L);
            ((javax.portlet.Portlet)this.pico_.getComponentInstance((Object)(this.portletAppName_ + "_portlet_" + portletName))).destroy();
        }
        catch (Throwable t) {
            this.log_.error((Object)"If the portlet object throws a RuntimeException within the execution of the destroy method the portlet container must consider the portlet object successfully destroyed.", t);
        }
        finally {
            this.releasePortlet(portletName);
        }
    }

    public void loadAndRegisterPortletClasses() {
        String[] portletNames = this.getPortletNames();
        this.initMonitor(portletNames);
        this.loadAndRegisterClassesByKey(portletNames);
    }

    private String[] getPortletNames() {
        PortletApp portletApp = this.holder_.getPortletApplication(this.portletAppName_);
        List portletMetaDataList = portletApp.getPortlet();
        String[] portletNames = new String[portletMetaDataList.size()];
        int i = 0;
        for (Portlet portlet : portletMetaDataList) {
            portletNames[i] = portlet.getPortletName();
            ++i;
        }
        return portletNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initMonitor(String[] portletNames) {
        PortletContainerMonitorImpl portletContainerMonitorImpl = this.monitor_;
        synchronized (portletContainerMonitorImpl) {
            this.monitor_.registerPortletApp(this.portletAppName_);
        }
        for (int i = 0; i < portletNames.length; ++i) {
            String portletName = portletNames[i];
            this.registerPortletToMonitor(portletName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPortletToMonitor(String portletName) {
        PortletContainerMonitorImpl portletContainerMonitorImpl = this.monitor_;
        synchronized (portletContainerMonitorImpl) {
            this.monitor_.register(this.portletAppName_, portletName);
        }
    }

    private void loadAndRegisterClassesByKey(String[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            this.registerPortlet(key);
        }
    }

    public PreferencesValidator getValidator(String validatorClass, String portletName) {
        return (PreferencesValidator)this.pico_.getComponentInstance((Object)(this.portletAppName_ + "_" + portletName + "_validator_" + validatorClass));
    }

    public void loadAndRegisterValidatorClasses() {
        String[] classNames = this.getValidatorClassNames();
        String[] portletNames = this.getValidatorsPortletsNames();
        if (classNames == null || portletNames == null) {
            return;
        }
        this.loadAndRegisterClasses(classNames, portletNames);
    }

    public String[] getValidatorClassNames() {
        PortletApp portletApp = this.holder_.getPortletApplication(this.portletAppName_);
        List portletMetaDataList = portletApp.getPortlet();
        if (portletMetaDataList.size() == 0) {
            return null;
        }
        String[] validatorNames = new String[portletMetaDataList.size()];
        int i = 0;
        for (Portlet portlet : portletMetaDataList) {
            ExoPortletPreferences preferences = portlet.getPortletPreferences();
            if (preferences != null) {
                validatorNames[i] = preferences.getPreferencesValidator();
            }
            ++i;
        }
        return validatorNames;
    }

    public String[] getValidatorsPortletsNames() {
        PortletApp portletApp = this.holder_.getPortletApplication(this.portletAppName_);
        List portletMetaDataList = portletApp.getPortlet();
        if (portletMetaDataList.size() == 0) {
            return null;
        }
        String[] validatorNames = new String[portletMetaDataList.size()];
        int i = 0;
        for (Portlet portlet : portletMetaDataList) {
            ExoPortletPreferences preferences = portlet.getPortletPreferences();
            if (preferences != null) {
                validatorNames[i] = portlet.getPortletName();
            }
            ++i;
        }
        return validatorNames;
    }

    private void loadAndRegisterClasses(String[] classNames, String[] portletNames) {
        for (int i = 0; i < classNames.length; ++i) {
            String className = classNames[i];
            String portletName = portletNames[i];
            if (className == null) continue;
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                this.pico_.registerComponentImplementation((Object)(this.portletAppName_ + "_" + portletName + "_validator_" + className), cl.loadClass(className));
                continue;
            }
            catch (Exception e) {
                this.log_.error((Object)("Can not load and register class : " + className), (Throwable)e);
            }
        }
    }

    public void load() {
        this.loadAndRegisterPortletClasses();
        this.loadAndRegisterValidatorClasses();
    }

    public void setApplicationName(String servletContextName) {
        this.portletAppName_ = servletContextName;
    }

    public void start() {
    }

    public void stop() {
    }
}

