/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.monitor;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.portletcontainer.monitor.CachedData;
import org.exoplatform.services.portletcontainer.monitor.PortletRequestMonitorData;
import org.exoplatform.services.portletcontainer.monitor.PortletRuntimeData;

public class PortletRuntimeDatasImpl
implements PortletRuntimeData {
    private static int NUMBER_OF_REQUEST_MONITOR = 10;
    private static long TIME_RANGE = 100L;
    private String portletAppName;
    private String portletName;
    private boolean initialized;
    private long initializationTime;
    private long lastAccessTime;
    private long lastFailureAccessTime;
    private long lastInitFailureAccessTime;
    private long unavailabilityPeriod = 0L;
    private int cacheExpirationPeriod = 0;
    private final String globalKey;
    private String cacheScope;
    private ExoCache userCache;
    private final Log log;
    private final ExoCache globalCache;
    private final PortletRequestMonitorData[] portletRequestMonitors;

    public PortletRuntimeDatasImpl(String portletAppName, String portletName, CacheService cacheService, ExoCache globalCache, Log log) {
        this.log = log;
        this.globalCache = globalCache;
        this.portletAppName = portletAppName;
        this.portletName = portletName;
        this.globalKey = portletAppName + "/" + portletName;
        try {
            this.userCache = cacheService.getCacheInstance(this.globalKey);
        }
        catch (Exception e) {
            log.error((Object)"Can not lookup user cache", (Throwable)e);
        }
        this.portletRequestMonitors = new PortletRequestMonitorData[NUMBER_OF_REQUEST_MONITOR];
        long min = 0L;
        long max = TIME_RANGE - 1L;
        for (int i = 0; i < NUMBER_OF_REQUEST_MONITOR; ++i) {
            this.portletRequestMonitors[i] = new PortletRequestMonitorData(min, max);
            min += TIME_RANGE;
            max += TIME_RANGE;
        }
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final synchronized void setInitialized(boolean b) {
        this.initialized = b;
    }

    public final String getPortletAppName() {
        return this.portletAppName;
    }

    public final synchronized void setPortletAppName(String s) {
        this.portletAppName = s;
    }

    public final String getPortletName() {
        return this.portletName;
    }

    public final synchronized void setPortletName(String s) {
        this.portletName = s;
    }

    public final long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public final synchronized void setLastAccessTime(long l) {
        this.lastAccessTime = l;
    }

    public final long getLastFailureAccessTime() {
        return this.lastFailureAccessTime;
    }

    public final long getLastInitFailureAccessTime() {
        return this.lastInitFailureAccessTime;
    }

    public final synchronized void setLastInitFailureAccessTime(long l) {
        this.lastInitFailureAccessTime = l;
    }

    public final synchronized void setLastFailureAccessTime(long l) {
        this.lastFailureAccessTime = l;
    }

    public final long getUnavailabilityPeriod() {
        return this.unavailabilityPeriod;
    }

    public final synchronized void setUnavailabilityPeriod(long l) {
        this.unavailabilityPeriod = l;
    }

    public final boolean isDataCached(String key, boolean isCacheGlobal) {
        try {
            if (isCacheGlobal ? this.globalCache.get((Serializable)((Object)key)) != null : this.userCache.get((Serializable)((Object)key)) != null) {
                return true;
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to load data from user cache", (Throwable)e);
        }
        return false;
    }

    public final synchronized void setCachedData(String key, CachedData cachedData, boolean isCacheGlobal) {
        try {
            if (isCacheGlobal) {
                this.globalCache.put((Serializable)((Object)key), (Object)cachedData);
            } else {
                this.userCache.put((Serializable)((Object)key), (Object)cachedData);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to store data in user cache", (Throwable)e);
        }
    }

    public final CachedData getCachedData(String key, boolean isCacheGlobal) {
        try {
            if (isCacheGlobal) {
                return (CachedData)this.globalCache.get((Serializable)((Object)key));
            }
            return (CachedData)this.userCache.get((Serializable)((Object)key));
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to load data from user cache", (Throwable)e);
            return null;
        }
    }

    public final synchronized void removeCachedData(String key, boolean isCacheGlobal) {
        try {
            if (isCacheGlobal) {
                this.globalCache.remove((Serializable)((Object)key));
            } else {
                this.userCache.remove((Serializable)((Object)key));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to remove data from user cache", (Throwable)e);
        }
    }

    public final int getCacheExpirationPeriod() {
        return this.cacheExpirationPeriod;
    }

    public final synchronized void setCacheExpirationPeriod(int t) {
        this.cacheExpirationPeriod = t;
    }

    public final long getInitializationTime() {
        return this.initializationTime;
    }

    public final synchronized void setInitializationTime(long l) {
        this.initializationTime = l;
    }

    public final void logProcessActionRequest(long startTime, long endTime) {
        long executionTime = endTime - startTime;
        int index = (int)(executionTime / TIME_RANGE);
        if (index >= NUMBER_OF_REQUEST_MONITOR) {
            index = NUMBER_OF_REQUEST_MONITOR - 1;
        }
        this.portletRequestMonitors[index].logActionRequest(executionTime);
    }

    public final void logRenderRequest(long startTime, long endTime, boolean cacheHit) {
        long executionTime = endTime - startTime;
        int index = (int)(executionTime / TIME_RANGE);
        if (index >= NUMBER_OF_REQUEST_MONITOR) {
            index = NUMBER_OF_REQUEST_MONITOR - 1;
        }
        this.portletRequestMonitors[index].logRenderRequest(executionTime, cacheHit);
    }

    public final void logProcessEventRequest(long startTime, long endTime) {
        long executionTime = endTime - startTime;
        int index = (int)(executionTime / TIME_RANGE);
        if (index >= NUMBER_OF_REQUEST_MONITOR) {
            index = NUMBER_OF_REQUEST_MONITOR - 1;
        }
        this.portletRequestMonitors[index].logEventRequest(executionTime);
    }

    public final void logServeResourceRequest(long startTime, long endTime, boolean cacheHit) {
        long executionTime = endTime - startTime;
        int index = (int)(executionTime / TIME_RANGE);
        if (index >= NUMBER_OF_REQUEST_MONITOR) {
            index = NUMBER_OF_REQUEST_MONITOR - 1;
        }
        this.portletRequestMonitors[index].logResourceRequest(executionTime, cacheHit);
    }

    public final PortletRequestMonitorData[] getPortletRequestMonitorData() {
        return this.portletRequestMonitors;
    }

    public final synchronized boolean isAvailable(long l) {
        if (l - this.getLastFailureAccessTime() >= this.getUnavailabilityPeriod()) {
            this.setUnavailabilityPeriod(0L);
            return true;
        }
        return false;
    }

    public final synchronized boolean isInitialisationAllowed(long l) {
        if (l - this.getLastInitFailureAccessTime() > this.getUnavailabilityPeriod()) {
            this.setUnavailabilityPeriod(0L);
            return true;
        }
        return false;
    }

    public final long whenAvailable() {
        long period = this.getUnavailabilityPeriod() - (System.currentTimeMillis() - this.getLastInitFailureAccessTime());
        if (period < 0L) {
            return -1L;
        }
        return period;
    }

    public final String getCacheScope() {
        return this.cacheScope;
    }

    public final synchronized void setCacheScope(String cacheScope) {
        this.cacheScope = cacheScope;
    }
}

