/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.portlet.ActionResponse;
import javax.portlet.PortletModeException;
import javax.portlet.PortletURL;
import javax.portlet.WindowStateException;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.ResponseContext;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.StateAwareResponseImp;

public class ActionResponseImp
extends StateAwareResponseImp
implements ActionResponse {
    private String location;

    public ActionResponseImp(ResponseContext resCtx) {
        super(resCtx);
    }

    public void sendRedirect(String location1) throws IOException {
        if (!this.isRedirectionPossible()) {
            throw new IllegalStateException(" The sendRedirect method can not be invoked after any of the following methods of the ActionResponse interface has been called: setPortletMode, setWindowState, setRenderParameter, setRenderParameters");
        }
        if (!(location1.startsWith("/") || location1.startsWith("http://") || location1.startsWith("https://"))) {
            throw new IllegalArgumentException("a relative or incorrect path URL is given");
        }
        this.setSendRedirectAlreadyOccured(true);
        this.location = location1;
    }

    public void sendRedirect(String location1, String renderUrlParamName) throws IOException {
        PortletURL url = this.createRenderURL();
        try {
            url.setPortletMode(this.getPortletMode());
        }
        catch (PortletModeException e) {
            // empty catch block
        }
        try {
            url.setWindowState(this.getWindowState());
        }
        catch (WindowStateException e) {
            // empty catch block
        }
        url.setParameters(this.getResCtx().getPortletRequest().getParameterMap());
        String paramForRedirect = url.toString();
        try {
            renderUrlParamName = URLEncoder.encode(renderUrlParamName, "utf-8");
            paramForRedirect = URLEncoder.encode(paramForRedirect, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        location1 = location1.indexOf(63) < 0 ? location1 + "?" : location1 + "&";
        location1 = location1 + renderUrlParamName + "=" + paramForRedirect;
        this.sendRedirect(location1);
    }

    public String getLocation() {
        return this.location;
    }
}

