/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.xml.namespace.QName;
import org.exoplatform.services.portletcontainer.pci.model.CustomPortletMode;
import org.exoplatform.services.portletcontainer.pci.model.CustomWindowState;
import org.exoplatform.services.portletcontainer.pci.model.InitParam;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.SecurityConstraint;
import org.exoplatform.services.portletcontainer.pci.model.UserAttribute;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletContextImpl;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.bundle.ResourceBundleManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletConfigImp
implements PortletConfig {
    private final Portlet portletDatas_;
    private final Map<String, InitParam> params_ = new HashMap<String, InitParam>();
    private final PortletContextImpl portletContext;
    private final List<SecurityConstraint> securityContraints;
    private final List<UserAttribute> userAttributes_;
    private final List<CustomPortletMode> customPortletModes_;
    private final List<CustomWindowState> customWindowStates_;
    private final String defaultNamespace;

    public PortletConfigImp(Portlet portletDatas, PortletContext portletContext, List<SecurityConstraint> securityContraints, List<UserAttribute> userAttributes, List<CustomPortletMode> customPortletModes, List<CustomWindowState> customWindowStates, String defaultNamespace) {
        this.portletDatas_ = portletDatas;
        this.defaultNamespace = defaultNamespace;
        this.portletContext = (PortletContextImpl)portletContext;
        this.securityContraints = securityContraints;
        this.userAttributes_ = userAttributes;
        this.customPortletModes_ = customPortletModes;
        this.customWindowStates_ = customWindowStates;
        List l = this.portletDatas_.getInitParam();
        for (InitParam initParam : l) {
            this.params_.put(initParam.getName(), initParam);
        }
    }

    public String getPortletName() {
        return this.portletDatas_.getPortletName();
    }

    public PortletContext getPortletContext() {
        return this.portletContext;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundleManager manager = (ResourceBundleManager)this.portletContext.getContainer().getComponentInstanceOfType(ResourceBundleManager.class);
        return manager.lookupBundle(this.portletDatas_, locale);
    }

    public String getInitParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("You cannot have null as a paramter");
        }
        InitParam initParam = this.params_.get(name);
        if (initParam != null) {
            return initParam.getValue();
        }
        return null;
    }

    public Enumeration getInitParameterNames() {
        return new Vector<String>(this.params_.keySet()).elements();
    }

    public Portlet getPortletDatas() {
        return this.portletDatas_;
    }

    public boolean needsSecurityContraints(String portletName) {
        for (SecurityConstraint securityConstraint : this.securityContraints) {
            List l = securityConstraint.getPortletCollection().getPortletName();
            for (String portlet : l) {
                if (!portlet.equals(portletName)) continue;
                return true;
            }
        }
        return false;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public Enumeration getPublicRenderParameterNames() {
        return this.notNullEnumeration(this.portletDatas_.getSupportedPublicRenderParameter());
    }

    public Enumeration<QName> getPublishingEventQNames() {
        return this.notNullEnumeration(this.portletDatas_.getSupportedPublishingEvent());
    }

    public Enumeration<QName> getProcessingEventQNames() {
        return this.notNullEnumeration(this.portletDatas_.getSupportedProcessingEvent());
    }

    public Enumeration<Locale> getSupportedLocales() {
        return this.notNullEnumeration(this.portletDatas_.getSupportedLocale());
    }

    protected Enumeration notNullEnumeration(List list) {
        if (list == null) {
            list = new ArrayList();
        }
        return Collections.enumeration(list);
    }

    public Map<String, String[]> getContainerRuntimeOptions() {
        Map a = this.portletDatas_.getContainerRuntimeOption();
        Map b = this.portletDatas_.getApplication().getContainerRuntimeOption();
        b.putAll(a);
        return b;
    }
}

