/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.portlet.PortletContext;
import javax.portlet.PortletSession;
import javax.portlet.PortletSessionUtil;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.map.AbstractMap;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.utils.PortletSessionImpUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletSessionImp
extends AbstractMap
implements PortletSession {
    private HttpSession session;
    private final PortletContext context;
    private String windowId;
    private final String applicationId;
    private boolean invalidated;
    private final Log log;
    protected ExoContainer cont;

    public PortletSessionImp(ExoContainer cont, HttpSession session, PortletContext context, String windowId) {
        this.cont = cont;
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.portletcontainer");
        this.session = session;
        this.context = context;
        this.windowId = windowId;
        this.applicationId = context.getPortletContextName();
        this.invalidated = this.session == null;
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, 2);
    }

    public Object getAttribute(String name, int scope) {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        if (1 == scope) {
            return this.session.getAttribute(name);
        }
        if (2 == scope) {
            String key = PortletSessionImpUtil.encodePortletSessionAttribute(this.windowId, name, 2);
            return this.session.getAttribute(key);
        }
        return null;
    }

    public void removeAttribute(String name) {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        this.removeAttribute(name, 2);
    }

    public void removeAttribute(String name, int scope) {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        if (1 == scope) {
            this.session.removeAttribute(name);
        } else if (2 == scope) {
            String key = PortletSessionImpUtil.encodePortletSessionAttribute(this.windowId, name, 2);
            this.session.removeAttribute(key);
        }
    }

    public final void setAttribute(String name, Object o) {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        this.setAttribute(name, o, 2);
    }

    public void setAttribute(String name, Object o, int scope) {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        if (name == null) {
            throw new IllegalArgumentException("The attribute name cannot be null");
        }
        if (1 == scope) {
            if (o == null) {
                this.session.removeAttribute(name);
            } else {
                this.session.setAttribute(name, o);
            }
        } else if (2 == scope) {
            String key = PortletSessionImpUtil.encodePortletSessionAttribute(this.windowId, name, 2);
            if (o == null) {
                this.session.removeAttribute(key);
            } else {
                this.session.setAttribute(key, o);
            }
        }
    }

    public Enumeration<String> getAttributeNames() {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        return this.getAttributeNames(2);
    }

    public Enumeration<String> getAttributeNames(int scope) {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        Enumeration e = this.session.getAttributeNames();
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (scope == 2) {
                if (PortletSessionUtil.decodeScope((String)s) != 2) continue;
                v.add(PortletSessionUtil.decodeAttributeName((String)s));
                continue;
            }
            if (PortletSessionUtil.decodeScope((String)s) != 1) continue;
            v.add(s);
        }
        return v.elements();
    }

    public Map getAttributeMap() {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        return this.getAttributeMap(2);
    }

    public Map getAttributeMap(int scope) {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        Enumeration e = this.session.getAttributeNames();
        HashMap<String, Object> m = new HashMap<String, Object>();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (scope == 2) {
                if (PortletSessionUtil.decodeScope((String)s) != 2) continue;
                String key = PortletSessionUtil.decodeAttributeName((String)s);
                m.put(key, this.session.getAttribute(key));
                continue;
            }
            if (PortletSessionUtil.decodeScope((String)s) != 1) continue;
            m.put(s, this.session.getAttribute(s));
        }
        return m;
    }

    public long getCreationTime() {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        return this.session.getCreationTime();
    }

    public String getId() {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        return this.session.getId() + this.applicationId;
    }

    public long getLastAccessedTime() {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        return this.session.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        return this.session.getMaxInactiveInterval();
    }

    public void invalidate() {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        this.session.invalidate();
        this.invalidated = true;
    }

    public boolean isSessionValid() {
        if (this.session == null) {
            return false;
        }
        try {
            long lastAccessTime = this.session.getLastAccessedTime();
            if (lastAccessTime == 0L) {
                return true;
            }
            if (lastAccessTime == -1L) {
                return false;
            }
            int maxInterval = this.session.getMaxInactiveInterval();
            if (maxInterval < 0) {
                return true;
            }
            if (System.currentTimeMillis() - lastAccessTime > (long)(maxInterval * 1000)) {
                this.session.invalidate();
                return false;
            }
            return true;
        }
        catch (IllegalStateException e) {
            this.log.error((Object)"IllegalStateException in PortletSessionImp for isSessionValid()", (Throwable)e);
            return false;
        }
    }

    public boolean isNew() {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        return this.session.isNew();
    }

    public void setMaxInactiveInterval(int i) {
        if (this.invalidated) {
            throw new IllegalStateException("session invalidated");
        }
        this.session.setMaxInactiveInterval(i);
    }

    public PortletContext getPortletContext() {
        return this.context;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void setSession(HttpSession session, String windowId) {
        this.session = session;
        this.invalidated = this.session == null;
        this.windowId = windowId;
    }
}

