/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.ResourceURL;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.BaseURLImp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceURLImp
extends BaseURLImp
implements ResourceURL {
    protected String resourceID;
    protected String originalCacheLevel;
    protected String cacheLevel;
    protected Map<String, String[]> renderParams;

    public ResourceURLImp(String type, String baseURL, boolean isCurrentlySecured, boolean defaultEscapeXml, String cacheLevel, Portlet portletDatas, Map<String, String[]> renderParams) {
        super(type, baseURL, isCurrentlySecured, defaultEscapeXml, portletDatas);
        this.renderParams = renderParams;
        this.originalCacheLevel = cacheLevel == null ? "cacheLevelPage" : cacheLevel;
        this.cacheLevel = this.originalCacheLevel;
    }

    protected void invokeFilterResourceURL() {
        if (this.getPortletDatas() == null) {
            return;
        }
        List list = this.getPortletDatas().getApplication().getUrlListeners();
        if (list == null) {
            return;
        }
        for (PortletURLGenerationListener listener : list) {
            try {
                listener.filterResourceURL((ResourceURL)this);
            }
            catch (Exception e) {}
        }
    }

    @Override
    public String toString(boolean escapeXML) {
        String propertyString;
        String[] values;
        String value;
        Object obj;
        Set<Object> names;
        this.invokeFilterResourceURL();
        if (!this.isSetSecureCalled() && this.isCurrentlySecured()) {
            this.setSecure(true);
        }
        StringBuffer sB = new StringBuffer();
        sB.append(this.baseURL);
        sB.append("&amp;");
        sB.append("portal:type");
        sB.append("=");
        sB.append(this.getType());
        sB.append("&amp;");
        sB.append("portal:isSecure");
        sB.append("=");
        sB.append(this.isSecure());
        if (this.resourceID != null) {
            sB.append("&amp;");
            sB.append("portal:resourceID");
            sB.append("=");
            sB.append(this.resourceID);
        }
        if (this.cacheLevel != null) {
            sB.append("&amp;");
            sB.append("portal:cacheLevel");
            sB.append("=");
            sB.append(this.cacheLevel);
        }
        try {
            names = this.parameters.keySet();
            for (String string : names) {
                obj = this.parameters.get(string);
                if (obj instanceof String) {
                    value = (String)obj;
                    sB.append("&amp;");
                    sB.append(this.encode(string, escapeXML));
                    sB.append("=");
                    sB.append(this.encode(value, escapeXML));
                    continue;
                }
                for (String element : values = (String[])obj) {
                    sB.append("&amp;");
                    sB.append(this.encode(string, escapeXML));
                    sB.append("=");
                    sB.append(this.encode(element, escapeXML));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.renderParams != null && (this.cacheLevel.equals("cacheLevelPage") || this.cacheLevel.equals("cacheLevelPortlet"))) {
            try {
                names = this.renderParams.keySet();
                for (String string : names) {
                    obj = this.renderParams.get(string);
                    if (obj instanceof String) {
                        value = (String)obj;
                        sB.append("&amp;");
                        sB.append(this.encode(string, escapeXML));
                        sB.append("=");
                        sB.append(this.encode(value, escapeXML));
                        continue;
                    }
                    for (String element : values = (String[])obj) {
                        sB.append("&amp;");
                        sB.append(this.encode(string, escapeXML));
                        sB.append("=");
                        sB.append(this.encode(element, escapeXML));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((propertyString = this.getPropertyString(escapeXML)) != "" && propertyString != null) {
            sB.append(propertyString);
        }
        return sB.toString();
    }

    public void setResourceID(String resourceID) {
        this.resourceID = resourceID;
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public String getCacheability() {
        return this.cacheLevel;
    }

    public void setCacheability(String cacheLevel) {
        if (cacheLevel != null) {
            if (!ResourceURLImp.isSupportedCacheLevel(cacheLevel)) {
                throw new IllegalStateException("Cacheability level error: the cache level '" + cacheLevel + "' is unknown to the portlet container");
            }
            if (ResourceURLImp.getSupportedCacheLevel().indexOf(this.originalCacheLevel) < ResourceURLImp.getSupportedCacheLevel().indexOf(cacheLevel)) {
                throw new IllegalStateException("Cacheability level error: wants to become cache level '" + cacheLevel + "' a weaker than the parent '" + this.originalCacheLevel + "'.");
            }
            this.cacheLevel = cacheLevel;
        }
    }

    public static boolean isSupportedCacheLevel(String cacheLevel) {
        return ResourceURLImp.getSupportedCacheLevel().contains(cacheLevel);
    }

    private static List<String> getSupportedCacheLevel() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("cacheLevelFull");
        result.add("cacheLevelPortlet");
        result.add("cacheLevelPage");
        return result;
    }
}

