/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.helpers;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.services.portletcontainer.helper.URLEncoder;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.helpers.NestedResponseWrapper;

public class CustomResponseWrapper
extends HttpServletResponseWrapper {
    private String contentType = "";
    private PrintWriter tmpWriter;
    private ByteArrayOutputStream output = new ByteArrayOutputStream();
    private ByteArrayServletOutputStream servletOutput = new ByteArrayServletOutputStream(this.output);
    private URLEncoder urlEncoder_;
    private CharArrayWriter charArrayWriter = new CharArrayWriter();
    private boolean writerAlreadyCalled = false;
    private boolean outputStreamAlreadyCalled = false;
    private static Log log = LogFactory.getLog(CustomResponseWrapper.class);

    public CustomResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
        this.tmpWriter = new PrintWriter(this.charArrayWriter){

            public boolean equals(Object obj) {
                return true;
            }

            public void close() {
                log.debug((Object)"try to close");
            }
        };
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        super.setContentType(type);
        this.contentType = type;
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.servletOutput.close();
        this.output.close();
        this.tmpWriter.close();
    }

    public byte[] getPortletContent() {
        if (this.outputStreamAlreadyCalled) {
            return this.output.toByteArray();
        }
        if (this.writerAlreadyCalled) {
            try {
                return new String(this.charArrayWriter.toCharArray()).getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                return new String(this.charArrayWriter.toCharArray()).getBytes();
            }
        }
        return null;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStreamAlreadyCalled) {
            throw new IllegalStateException("the output streamobject has already been called");
        }
        this.writerAlreadyCalled = true;
        log.debug((Object)"getWriter()");
        return this.tmpWriter;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writerAlreadyCalled) {
            throw new IllegalStateException("the PrintWriter  has already been called");
        }
        log.debug((Object)"getOutputStream()");
        this.outputStreamAlreadyCalled = true;
        return this.servletOutput;
    }

    public byte[] toByteArray() {
        return this.output.toByteArray();
    }

    public void flushBuffer() throws IOException {
        log.debug((Object)"flushBuffer()");
        this.tmpWriter.flush();
        this.servletOutput.flush();
    }

    public void reset() {
        log.debug((Object)"reset()");
        this.charArrayWriter.reset();
        this.output.reset();
    }

    public void close() throws IOException {
        log.debug((Object)"close()");
    }

    public int getBufferSize() {
        log.debug((Object)"getBufferSize()");
        return 0;
    }

    public String encodeURL(String url) {
        if (this.urlEncoder_ == null) {
            return super.encodeURL(url);
        }
        return this.urlEncoder_.encodeURL(url);
    }

    public void setURLEncoder(URLEncoder encoder) {
        this.urlEncoder_ = encoder;
    }

    public void sendRedirect(String location) throws IOException {
        log.debug((Object)("Send redirect [" + location + "]"));
        super.sendRedirect(location);
    }

    public boolean isStreamUsed() {
        return this.outputStreamAlreadyCalled;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NestedResponseWrapper) {
            return super.equals(((NestedResponseWrapper)((Object)obj)).getResponse());
        }
        return super.equals(obj);
    }

    private static class ByteArrayServletOutputStream
    extends ServletOutputStream {
        ByteArrayOutputStream baos;

        public ByteArrayServletOutputStream(ByteArrayOutputStream baos) {
            this.baos = baos;
        }

        public void write(int i) throws IOException {
            this.baos.write(i);
        }
    }
}

