/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.helpers;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.services.portletcontainer.helper.URLEncoder;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.helpers.CustomResponseWrapper;

public class NestedResponseWrapper
extends HttpServletResponseWrapper {
    private String contentType = "";
    private PrintWriter tmpWriter;
    private ProxyServletOutputStream output;
    private boolean noOutput;
    private boolean noValues;
    private URLEncoder urlEncoder_;
    private CharArrayWriter charArrayWriter = new CharArrayWriter();
    private boolean writerAlreadyCalled = false;
    private boolean outputStreamAlreadyCalled = false;
    private static Log log = LogFactory.getLog(CustomResponseWrapper.class);
    private boolean committed = false;

    public NestedResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
        this.tmpWriter = new PrintWriter(this.charArrayWriter){

            public boolean equals(Object obj) {
                return true;
            }

            public void close() {
                log.debug((Object)"try to close");
            }
        };
        this.output = new ProxyServletOutputStream(this.tmpWriter);
    }

    public String getContentType() {
        if (this.noValues) {
            return null;
        }
        return this.contentType;
    }

    public void setContentType(String type) {
        super.setContentType(type);
        this.contentType = type;
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.output.close();
        this.tmpWriter.close();
    }

    public byte[] getPortletContent() {
        if (this.outputStreamAlreadyCalled || this.writerAlreadyCalled) {
            try {
                return new String(this.charArrayWriter.toCharArray()).getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                return new String(this.charArrayWriter.toCharArray()).getBytes();
            }
        }
        return null;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.noOutput) {
            return null;
        }
        this.writerAlreadyCalled = true;
        log.debug((Object)"getWriter()");
        return this.tmpWriter;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.noOutput) {
            return null;
        }
        log.debug((Object)"getOutputStream()");
        this.outputStreamAlreadyCalled = true;
        return this.output;
    }

    public byte[] toByteArray() {
        try {
            return new String(this.charArrayWriter.toCharArray()).getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(this.charArrayWriter.toCharArray()).getBytes();
        }
    }

    public void flushBuffer() throws IOException {
        log.debug((Object)"flushBuffer()");
        this.tmpWriter.flush();
    }

    public void reset() {
        log.debug((Object)"reset()");
        this.charArrayWriter.reset();
    }

    public void close() throws IOException {
        log.debug((Object)"close()");
    }

    public int getBufferSize() {
        log.debug((Object)"getBufferSize()");
        return 0;
    }

    public String encodeURL(String url) {
        if (this.urlEncoder_ == null) {
            return super.encodeURL(url);
        }
        return this.urlEncoder_.encodeURL(url);
    }

    public void setURLEncoder(URLEncoder encoder) {
        this.urlEncoder_ = encoder;
    }

    public void sendRedirect(String location) throws IOException {
        log.debug((Object)("Send redirect [" + location + "]"));
        super.sendRedirect(location);
    }

    public boolean equals(Object obj) {
        return super.equals(obj) || this.getResponse().equals(obj);
    }

    public String encodeRedirectURL(String url) {
        if (url != null) {
            return super.encodeRedirectURL(url);
        }
        return null;
    }

    public String encodeRedirectUrl(String url) {
        if (url != null) {
            return super.encodeRedirectUrl(url);
        }
        return null;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void setCommitted() {
        this.committed = true;
    }

    public boolean isNoOutput() {
        return this.noOutput;
    }

    public void setNoOutput(boolean noOutput) {
        this.noOutput = noOutput;
    }

    public String getCharacterEncoding() {
        if (this.noValues) {
            return null;
        }
        return super.getCharacterEncoding();
    }

    public Locale getLocale() {
        if (this.noValues) {
            return null;
        }
        return super.getLocale();
    }

    public void setNoValues(boolean noValues) {
        this.noValues = noValues;
    }

    private static class ProxyServletOutputStream
    extends ServletOutputStream {
        private PrintWriter writer;

        public ProxyServletOutputStream(PrintWriter writer) {
            this.writer = writer;
        }

        public void write(int i) throws IOException {
            this.writer.write(i);
        }
    }
}

