/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.producer.impl;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.IdentifierUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.portletcontainer.pci.ActionInput;
import org.exoplatform.services.portletcontainer.pci.ActionOutput;
import org.exoplatform.services.portletcontainer.pci.ExoWindowID;
import org.exoplatform.services.portletcontainer.pci.PortletData;
import org.exoplatform.services.portletcontainer.pci.PortletURLFactory;
import org.exoplatform.services.portletcontainer.pci.RenderInput;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.persistence.PortletPreferencesPersister;
import org.exoplatform.services.wsrp.exceptions.Exception2Fault;
import org.exoplatform.services.wsrp.exceptions.WSRPException;
import org.exoplatform.services.wsrp.producer.MarkupOperationsInterface;
import org.exoplatform.services.wsrp.producer.PersistentStateManager;
import org.exoplatform.services.wsrp.producer.PortletContainerProxy;
import org.exoplatform.services.wsrp.producer.PortletManagementOperationsInterface;
import org.exoplatform.services.wsrp.producer.TransientStateManager;
import org.exoplatform.services.wsrp.producer.impl.WSRPConfiguration;
import org.exoplatform.services.wsrp.producer.impl.WSRPPortletPreferencesPersister;
import org.exoplatform.services.wsrp.producer.impl.helpers.WSRPConsumerRewriterPortletURLFactory;
import org.exoplatform.services.wsrp.producer.impl.helpers.WSRPHTTPContainer;
import org.exoplatform.services.wsrp.producer.impl.helpers.WSRPHttpServletRequest;
import org.exoplatform.services.wsrp.producer.impl.helpers.WSRPHttpServletResponse;
import org.exoplatform.services.wsrp.producer.impl.helpers.WSRPHttpSession;
import org.exoplatform.services.wsrp.producer.impl.helpers.WSRPProducerRewriterPortletURLFactory;
import org.exoplatform.services.wsrp.type.BlockingInteractionResponse;
import org.exoplatform.services.wsrp.type.CacheControl;
import org.exoplatform.services.wsrp.type.InteractionParams;
import org.exoplatform.services.wsrp.type.MarkupContext;
import org.exoplatform.services.wsrp.type.MarkupParams;
import org.exoplatform.services.wsrp.type.MarkupResponse;
import org.exoplatform.services.wsrp.type.PortletContext;
import org.exoplatform.services.wsrp.type.RegistrationContext;
import org.exoplatform.services.wsrp.type.ReturnAny;
import org.exoplatform.services.wsrp.type.RuntimeContext;
import org.exoplatform.services.wsrp.type.SessionContext;
import org.exoplatform.services.wsrp.type.StateChange;
import org.exoplatform.services.wsrp.type.Templates;
import org.exoplatform.services.wsrp.type.UpdateResponse;
import org.exoplatform.services.wsrp.type.UserContext;
import org.exoplatform.services.wsrp.utils.Modes;
import org.exoplatform.services.wsrp.utils.Utils;
import org.exoplatform.services.wsrp.utils.WindowStates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupOperationsInterfaceImpl
implements MarkupOperationsInterface {
    private Log log;
    private WSRPConfiguration conf;
    private PersistentStateManager persistentStateManager;
    private PortletContainerProxy proxy;
    private TransientStateManager transientStateManager;
    private PortletManagementOperationsInterface portletManagementOperationsInterface;
    private WSRPPortletPreferencesPersister persister;

    public MarkupOperationsInterfaceImpl(PortletManagementOperationsInterface portletManagementOperationsInterface, PersistentStateManager persitentStateManager, TransientStateManager transientStateManager, PortletContainerProxy proxy, WSRPConfiguration conf, OrganizationService orgService) {
        this.portletManagementOperationsInterface = portletManagementOperationsInterface;
        this.proxy = proxy;
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp1");
        this.conf = conf;
        this.persistentStateManager = persitentStateManager;
        this.transientStateManager = transientStateManager;
        this.persister = WSRPPortletPreferencesPersister.getInstance();
    }

    @Override
    public MarkupResponse getMarkup(RegistrationContext registrationContext, PortletContext portletContext, RuntimeContext runtimeContext, UserContext userContext, MarkupParams markupParams) throws RemoteException {
        String portletHandle = portletContext.getPortletHandle();
        portletHandle = this.manageRegistration(portletHandle, registrationContext);
        this.log.debug((Object)("Portlet handle : " + portletHandle));
        String[] k = StringUtils.split((String)portletHandle, (String)"/");
        String portletApplicationName = k[0];
        String portletName = k[1];
        String uniqueID = k[2];
        Integer sessiontimeperiod = this.getSessionTimePeriod();
        String sessionID = runtimeContext.getSessionID();
        WSRPHttpSession session = this.resolveSession(sessionID, userContext.getUserContextKey(), sessiontimeperiod);
        sessionID = session.getId();
        SessionContext sessionContext = new SessionContext();
        sessionContext.setSessionID(session.getId());
        sessionContext.setExpires(sessiontimeperiod);
        userContext = this.transientStateManager.resolveUserContext(userContext, session);
        String owner = userContext.getUserContextKey();
        this.log.debug((Object)("Owner Context : " + owner));
        if (markupParams.getValidateTag() != null) {
            try {
                if (this.transientStateManager.validateCache(markupParams.getValidateTag())) {
                    MarkupContext markupContext = new MarkupContext();
                    markupContext.setUseCachedMarkup(Boolean.TRUE);
                    MarkupResponse markup = new MarkupResponse();
                    markup.setMarkupContext(markupContext);
                    markup.setSessionContext(sessionContext);
                    return markup;
                }
            }
            catch (WSRPException e) {
                this.log.debug((Object)("Can not validate Cache for validateTag : " + markupParams.getValidateTag()));
                Exception2Fault.handleException(e);
            }
        }
        Map<String, PortletData> portletMetaDatas = this.proxy.getAllPortletMetaData();
        PortletData portletDatas = portletMetaDatas.get(portletApplicationName + "/" + portletName);
        HashMap<String, String[]> renderParameters = new HashMap();
        Map<String, String[]> persistentNavigationalParameters = this.processNavigationalState(markupParams.getNavigationalState());
        if (persistentNavigationalParameters != null && !persistentNavigationalParameters.isEmpty()) {
            renderParameters = persistentNavigationalParameters;
        } else {
            this.log.debug((Object)"No navigational state exists");
        }
        byte[] portletState = this.managePortletState(portletContext);
        String mimeType = null;
        try {
            mimeType = this.getMimeType(markupParams.getMimeTypes(), portletDatas);
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        String baseURL = null;
        Object portletURLFactory = null;
        if (this.conf.isDoesUrlTemplateProcessing()) {
            this.log.debug((Object)"Producer URL rewriting");
            Templates templates = this.manageTemplates(runtimeContext, session);
            baseURL = templates.getRenderTemplate();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("MarkupOperationsInterfaceImpl.getMarkup() baseURL = " + baseURL));
            }
            portletURLFactory = new WSRPProducerRewriterPortletURLFactory(mimeType, baseURL, portletDatas.getSupports(), markupParams.isSecureClientCommunication(), portletHandle, this.persistentStateManager, sessionID);
        } else {
            this.log.debug((Object)"Consumer URL rewriting");
            portletURLFactory = new WSRPConsumerRewriterPortletURLFactory(mimeType, baseURL, portletDatas.getSupports(), markupParams.isSecureClientCommunication(), portletHandle, this.persistentStateManager, sessionID);
        }
        PortletMode portletMode = Modes.getJsrPortletMode(markupParams.getMode());
        WindowState windowState = WindowStates.getJsrWindowState(markupParams.getWindowState());
        WSRPHttpServletRequest request = WSRPHTTPContainer.getInstance().getRequest();
        WSRPHttpServletResponse response = WSRPHTTPContainer.getInstance().getResponse();
        WSRPHTTPContainer.getInstance().getRequest().setWsrpSession(session);
        request.setParameters(renderParameters);
        RenderInput input = new RenderInput();
        ExoWindowID windowID = new ExoWindowID();
        windowID.setOwner(owner);
        windowID.setPortletApplicationName(portletApplicationName);
        windowID.setPortletName(portletName);
        windowID.setUniqueID(uniqueID);
        input.setInternalWindowID((WindowID)windowID);
        input.setBaseURL(baseURL);
        input.setUserAttributes(new HashMap());
        input.setPortletMode(portletMode);
        input.setWindowState(windowState);
        input.setMarkup(mimeType);
        input.setRenderParameters(renderParameters);
        input.setPortletURLFactory((PortletURLFactory)portletURLFactory);
        input.setPortletState(portletState);
        input.setPortletPreferencesPersister((PortletPreferencesPersister)this.persister);
        RenderOutput output = null;
        try {
            output = this.proxy.render(request, response, input);
        }
        catch (WSRPException e) {
            this.log.debug((Object)"The call to render method was a failure ", (Throwable)e);
            Exception2Fault.handleException(e);
        }
        CacheControl cacheControl = null;
        try {
            cacheControl = this.transientStateManager.getCacheControl(portletDatas);
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        MarkupContext markupContext = new MarkupContext();
        markupContext.setMimeType(mimeType);
        markupContext.setCacheControl(cacheControl);
        markupContext.setMarkupString(this.removeNonValidXMLCharacters(new String(output.getContent())));
        markupContext.setPreferredTitle(output.getTitle());
        markupContext.setRequiresUrlRewriting(new Boolean(this.conf.isDoesUrlTemplateProcessing()));
        markupContext.setUseCachedMarkup(Boolean.TRUE);
        markupContext.setLocale("en");
        MarkupResponse markup = new MarkupResponse();
        markup.setSessionContext(sessionContext);
        markup.setMarkupContext(markupContext);
        return markup;
    }

    @Override
    public BlockingInteractionResponse performBlockingInteraction(RegistrationContext registrationContext, PortletContext portletContext, RuntimeContext runtimeContext, UserContext userContext, MarkupParams markupParams, InteractionParams interactionParams) throws RemoteException {
        String portletHandle = portletContext.getPortletHandle();
        portletHandle = this.manageRegistration(portletHandle, registrationContext);
        String[] k = StringUtils.split((String)portletHandle, (String)"/");
        String portletApplicationName = k[0];
        String portletName = k[1];
        String uniqueID = k[2];
        Integer sessiontimeperiod = this.getSessionTimePeriod();
        String sessionID = runtimeContext.getSessionID();
        WSRPHttpSession session = this.resolveSession(sessionID, userContext.getUserContextKey(), sessiontimeperiod);
        SessionContext sessionContext = new SessionContext();
        sessionContext.setSessionID(session.getId());
        sessionContext.setExpires(sessiontimeperiod);
        userContext = this.transientStateManager.resolveUserContext(userContext, session);
        String owner = userContext.getUserContextKey();
        this.log.debug((Object)("Owner Context : " + owner));
        String baseURL = null;
        if (this.conf.isDoesUrlTemplateProcessing()) {
            this.log.debug((Object)"Producer URL rewriting");
            Templates templates = this.manageTemplates(runtimeContext, session);
            baseURL = templates.getRenderTemplate();
        } else {
            this.log.debug((Object)"Consumer URL rewriting");
            baseURL = "wsrp_rewrite?";
        }
        byte[] portletState = this.managePortletState(portletContext);
        PortletMode portletMode = Modes.getJsrPortletMode(markupParams.getMode());
        WindowState windowState = WindowStates.getJsrWindowState(markupParams.getWindowState());
        boolean isStateChangeAuthorized = false;
        String stateChange = interactionParams.getPortletStateChange().getValue();
        if (StateChange.readWrite.getValue().equalsIgnoreCase(stateChange)) {
            this.log.debug((Object)"readWrite state change");
            isStateChangeAuthorized = true;
        } else if (StateChange.cloneBeforeWrite.getValue().equalsIgnoreCase(stateChange)) {
            this.log.debug((Object)"cloneBeforWrite state change");
            portletContext = this.portletManagementOperationsInterface.clonePortlet(registrationContext, portletContext, userContext);
            isStateChangeAuthorized = true;
        } else if (StateChange.readOnly.getValue().equalsIgnoreCase(stateChange)) {
            this.log.debug((Object)"readOnly state change");
        } else {
            this.log.debug((Object)("The submited portlet state change value : " + stateChange + " is not supported"));
            Exception2Fault.handleException(new WSRPException("PortletStateChangeRequired"));
        }
        String mimeType = markupParams.getMimeTypes(0);
        WSRPHttpServletRequest request = WSRPHTTPContainer.getInstance().getRequest();
        WSRPHttpServletResponse response = WSRPHTTPContainer.getInstance().getResponse();
        WSRPHTTPContainer.getInstance().getRequest().setWsrpSession(session);
        Map<String, String[]> formParameters = Utils.getMapParametersFromNamedStringArray(interactionParams.getFormParameters());
        Map<String, String[]> renderParameters = new HashMap<String, String[]>();
        if (formParameters != null && !formParameters.isEmpty()) {
            renderParameters = formParameters;
        }
        if (renderParameters != null) {
            request.setParameters(renderParameters);
        }
        ActionInput input = new ActionInput();
        ExoWindowID windowID = new ExoWindowID();
        windowID.setOwner(owner);
        windowID.setPortletApplicationName(portletApplicationName);
        windowID.setPortletName(portletName);
        windowID.setUniqueID(uniqueID);
        input.setInternalWindowID((WindowID)windowID);
        input.setBaseURL(baseURL);
        input.setUserAttributes(new HashMap());
        input.setPortletMode(portletMode);
        input.setWindowState(windowState);
        input.setMarkup(mimeType);
        input.setStateChangeAuthorized(isStateChangeAuthorized);
        input.setStateSaveOnClient(this.conf.isSavePortletStateOnConsumer());
        input.setPortletState(portletState);
        input.setPortletPreferencesPersister((PortletPreferencesPersister)this.persister);
        input.setRenderParameters(renderParameters);
        ActionOutput output = null;
        try {
            output = this.proxy.processAction(request, response, input);
        }
        catch (WSRPException e) {
            this.log.debug((Object)"The call to processAction method was a failure ", (Throwable)e);
            Exception2Fault.handleException(e);
        }
        String ns = IdentifierUtil.generateUUID((Object)output);
        try {
            this.log.debug((Object)("set new navigational state : " + ns));
            this.persistentStateManager.putNavigationalState(ns, output.getRenderParameters());
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        BlockingInteractionResponse blockingInteractionResponse = new BlockingInteractionResponse();
        if (output.getProperties().get("_send_redirect_") != null) {
            this.log.debug((Object)("Redirect the response to : " + (String)output.getProperties().get("_send_redirect_")));
            blockingInteractionResponse.setRedirectURL((String)output.getProperties().get("_send_redirect_"));
            blockingInteractionResponse.setUpdateResponse(null);
        } else {
            MarkupContext markupContext = null;
            if (this.conf.isBlockingInteractionOptimized()) {
                markupParams.setNavigationalState(ns);
                MarkupResponse markupResponse = this.getMarkup(registrationContext, portletContext, runtimeContext, userContext, markupParams);
                markupContext = markupResponse.getMarkupContext();
            }
            UpdateResponse updateResponse = new UpdateResponse();
            updateResponse.setNavigationalState(ns);
            if (output.getNextMode() != null) {
                updateResponse.setNewMode(Modes.getWSRPModeString(output.getNextMode()));
            }
            if (output.getNextState() != null) {
                updateResponse.setNewWindowState(WindowStates.getWSRPStateString(output.getNextState()));
            }
            updateResponse.setSessionContext(sessionContext);
            updateResponse.setMarkupContext(markupContext);
            if (this.conf.isSavePortletStateOnConsumer()) {
                portletContext.setPortletState(output.getPortletState());
            }
            updateResponse.setPortletContext(portletContext);
            blockingInteractionResponse.setUpdateResponse(updateResponse);
        }
        return blockingInteractionResponse;
    }

    @Override
    public ReturnAny initCookie(RegistrationContext registrationContext) throws RemoteException {
        if (this.conf.isRegistrationRequired()) {
            this.log.debug((Object)"Registration required");
            if (registrationContext == null) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        return new ReturnAny();
    }

    @Override
    public ReturnAny releaseSessions(RegistrationContext registrationContext, String[] sessionIDs) throws RemoteException {
        if (this.conf.isRegistrationRequired()) {
            this.log.debug((Object)"Registration required");
            if (registrationContext == null) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        }
        for (int i = 0; i < sessionIDs.length; ++i) {
            this.transientStateManager.releaseSession(sessionIDs[i]);
        }
        return new ReturnAny();
    }

    private WSRPHttpSession resolveSession(String sessionID, String user, Integer sessiontimeperiod) throws RemoteException {
        WSRPHttpSession session = null;
        try {
            session = this.transientStateManager.resolveSession(sessionID, user, sessiontimeperiod);
        }
        catch (WSRPException e) {
            this.log.debug((Object)("Can not lookup or create new session, sessionID parameter : " + sessionID));
            Exception2Fault.handleException(e);
        }
        this.log.debug((Object)("Use session with ID : " + session.getId()));
        return session;
    }

    private String manageRegistration(String portletHandle, RegistrationContext registrationContext) throws RemoteException {
        this.log.debug((Object)("manageRegistration called for portlet handle : " + portletHandle));
        if (!this.proxy.isPortletOffered(portletHandle)) {
            this.log.debug((Object)"The latter handle is not offered by the Producer");
            Exception2Fault.handleException(new WSRPException("InvalidHandle"));
        } else {
            String[] keys = StringUtils.split((String)portletHandle, (String)"/");
            if (keys.length == 2) {
                portletHandle = portletHandle + "/" + String.valueOf(portletHandle.hashCode());
            }
        }
        if (this.conf.isRegistrationRequired()) {
            this.log.debug((Object)"Registration required");
            if (registrationContext == null) {
                Exception2Fault.handleException(new WSRPException("InvalidRegistration"));
            }
        } else {
            this.log.debug((Object)"Registration non required");
        }
        return portletHandle;
    }

    private Map<String, String[]> processNavigationalState(String navigationalState) throws RemoteException {
        this.log.debug((Object)("Lookup navigational state : " + navigationalState));
        if (navigationalState == null) {
            return null;
        }
        Map<String, String[]> map = null;
        try {
            map = this.persistentStateManager.getNavigationalSate(navigationalState);
            if (this.log.isDebugEnabled() && map != null) {
                for (String s : map.keySet()) {
                    this.log.debug((Object)("attribute in map referenced by ns : " + s));
                }
            }
        }
        catch (WSRPException e) {
            Exception2Fault.handleException(e);
        }
        return map;
    }

    private String getMimeType(String[] mimeTypes, PortletData portletData) throws WSRPException {
        if (mimeTypes == null || mimeTypes.length == 0) {
            this.log.debug((Object)"the given array of MimeTypes is empty or null");
            throw new WSRPException("MissingParameters");
        }
        List l = portletData.getSupports();
        for (int i = 0; i < mimeTypes.length; ++i) {
            String mimeType = mimeTypes[i];
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                String supports = ((Supports)iterator.next()).getMimeType();
                if (!supports.equalsIgnoreCase(mimeType)) continue;
                return mimeType;
            }
        }
        this.log.debug((Object)"No mime type is supported");
        throw new WSRPException("UnsupportedMimeType");
    }

    private byte[] managePortletState(PortletContext portletContext) {
        if (this.conf.isSavePortletStateOnConsumer()) {
            this.log.debug((Object)"Save state on consumer");
            return portletContext.getPortletState();
        }
        this.log.debug((Object)"Save state on producer");
        return null;
    }

    private Templates manageTemplates(RuntimeContext runtimeContext, WSRPHttpSession session) {
        Templates templates = runtimeContext.getTemplates();
        if (this.conf.isTemplatesStoredInSession()) {
            this.log.debug((Object)"Optimized mode : templates store in session");
            if (templates == null) {
                this.log.debug((Object)"Optimized mode : retrieves the template from session");
                templates = this.transientStateManager.getTemplates(session);
            } else {
                this.log.debug((Object)"Optimized mode : store the templates in session");
                this.transientStateManager.storeTemplates(templates, session);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("MarkupOperationsInterfaceImpl.manageTemplates() templates.getRenderTemplate() = " + templates.getRenderTemplate()));
        }
        return templates;
    }

    private Integer getSessionTimePeriod() {
        try {
            WSRPHttpSession wsrpHttpSession = (WSRPHttpSession)WSRPHTTPContainer.getInstance().getRequest().getSession();
            return wsrpHttpSession.getMaxInactiveInterval();
        }
        catch (Exception e) {
            System.out.println("Exception: WSRPHttpServletRequest e.getCause() = " + e.getCause());
            return 900;
        }
    }

    private String removeNonValidXMLCharacters(String in) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }
}

