/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.producer.impl;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.IdentifierUtil;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.helper.WindowInfosContainer;
import org.exoplatform.services.portletcontainer.pci.PortletData;
import org.exoplatform.services.wsrp.exceptions.WSRPException;
import org.exoplatform.services.wsrp.producer.TransientStateManager;
import org.exoplatform.services.wsrp.producer.impl.WSRPConfiguration;
import org.exoplatform.services.wsrp.producer.impl.helpers.CacheControlProxy;
import org.exoplatform.services.wsrp.producer.impl.helpers.WSRPHttpSession;
import org.exoplatform.services.wsrp.type.CacheControl;
import org.exoplatform.services.wsrp.type.Templates;
import org.exoplatform.services.wsrp.type.UserContext;

public class TransientStateManagerImpl
implements TransientStateManager {
    private static final String TEMPLATE_KEY = "org.exoplatform.services.wsrp.templates.key";
    private static final String USER_CONTEXT_KEY = "org.exoplatform.services.wsrp.user.context.key";
    private Log log;
    private ExoCache cache;
    private WSRPConfiguration conf;
    protected ExoContainer cont;

    public TransientStateManagerImpl(ExoContainerContext ctx, CacheService cacheService, WSRPConfiguration conf) {
        block2: {
            this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp.producer.impl.TransientStateManagerImpl");
            this.conf = conf;
            try {
                this.cache = cacheService.getCacheInstance("wsrp");
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug((Object)"Can not lookup cache : wsrp", (Throwable)e);
            }
        }
        this.cont = ctx.getContainer();
    }

    public WSRPHttpSession resolveSession(String sessionID, String user, Integer sessiontimeperiod) throws WSRPException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Try to lookup session with ID : " + sessionID));
        }
        if (sessiontimeperiod == null) {
            sessiontimeperiod = 900;
        }
        try {
            WSRPHttpSession session = null;
            if (sessionID != null) {
                session = (WSRPHttpSession)this.cache.get((Serializable)((Object)sessionID));
            }
            WindowInfosContainer.createInstance((ExoContainer)this.cont, (String)sessionID, (String)user);
            if (session != null) {
                if (session.isInvalidated()) {
                    session = new WSRPHttpSession(sessionID, sessiontimeperiod);
                } else {
                    session.setLastAccessTime(System.currentTimeMillis());
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Lookup session success");
                }
            } else {
                if (sessionID != null) {
                    throw new Exception("Session doesn't exist anymore");
                }
                sessionID = IdentifierUtil.generateUUID((Object)this);
                session = new WSRPHttpSession(sessionID, sessiontimeperiod);
                this.cache.put((Serializable)((Object)sessionID), (Object)session);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Create new session with ID : " + sessionID));
                }
            }
            return session;
        }
        catch (Exception e) {
            throw new WSRPException("InvalidSession", e);
        }
    }

    public void releaseSession(String sessionID) {
        block2: {
            try {
                this.cache.remove((Serializable)((Object)sessionID));
                WindowInfosContainer.removeInstance((ExoContainer)this.cont, (String)sessionID);
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug((Object)("Can not release session : " + sessionID), (Throwable)e);
            }
        }
    }

    public CacheControl getCacheControl(PortletData portletDatas) throws WSRPException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Fill a CacheControl object for the portlet");
        }
        CacheControl cacheControl = null;
        try {
            cacheControl = new CacheControl();
            String key = IdentifierUtil.generateUUID((Object)cacheControl);
            cacheControl.setExpires(Integer.parseInt(portletDatas.getExpirationCache()));
            if (portletDatas.isCacheGlobal()) {
                cacheControl.setUserScope("wsrp:forAll");
            } else {
                cacheControl.setUserScope("wsrp:perUser");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Use Cache key : " + key));
            }
            cacheControl.setValidateTag(key);
            CacheControlProxy proxy = new CacheControlProxy(cacheControl);
            this.cache.put((Serializable)((Object)key), (Object)proxy);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Unable to cache CacheControlProxy", (Throwable)e);
            }
            throw new WSRPException("OperationFailed", e);
        }
        return cacheControl;
    }

    public boolean validateCache(String validateTag) throws WSRPException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Validate a CacheControl object : " + validateTag));
        }
        try {
            CacheControlProxy cacheControlProxy = (CacheControlProxy)this.cache.get((Serializable)((Object)validateTag));
            if (cacheControlProxy != null && cacheControlProxy.isValid()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Consumer cache validated");
                }
                return true;
            }
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Unable to lookup CacheControlProxy", (Throwable)e);
            }
            throw new WSRPException("OperationFailed", e);
        }
        return false;
    }

    public Templates getTemplates(WSRPHttpSession session) {
        return (Templates)session.getAttribute(TEMPLATE_KEY);
    }

    public void storeTemplates(Templates templates, WSRPHttpSession session) {
        session.setAttribute(TEMPLATE_KEY, templates);
    }

    public UserContext resolveUserContext(UserContext userContext, WSRPHttpSession session) {
        if (this.conf.isUserContextStoredInSession()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Optimized mode : user context store in session");
            }
            if (userContext == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Optimized mode : retrieve the user context from session");
                }
                return (UserContext)session.getAttribute(USER_CONTEXT_KEY);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Optimized mode : store the user context in session");
            }
            session.setAttribute(USER_CONTEXT_KEY, userContext);
        }
        return userContext;
    }
}

