/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.producer.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.services.portletcontainer.PortletContainerService;
import org.exoplatform.services.portletcontainer.pci.ActionInput;
import org.exoplatform.services.portletcontainer.pci.ActionOutput;
import org.exoplatform.services.portletcontainer.pci.ExoWindowID;
import org.exoplatform.services.portletcontainer.pci.Input;
import org.exoplatform.services.portletcontainer.pci.PortletData;
import org.exoplatform.services.portletcontainer.pci.RenderInput;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.portletcontainer.pci.model.Description;
import org.exoplatform.services.portletcontainer.pci.model.DisplayName;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.pci.model.UserAttribute;
import org.exoplatform.services.portletcontainer.persistence.PortletPreferencesPersister;
import org.exoplatform.services.wsrp.exceptions.WSRPException;
import org.exoplatform.services.wsrp.producer.PortletContainerProxy;
import org.exoplatform.services.wsrp.producer.impl.WSRPConfiguration;
import org.exoplatform.services.wsrp.producer.impl.WSRPPortletPreferencesPersister;
import org.exoplatform.services.wsrp.producer.impl.helpers.WSRPHTTPContainer;
import org.exoplatform.services.wsrp.producer.impl.helpers.WSRPHttpServletRequest;
import org.exoplatform.services.wsrp.producer.impl.helpers.WSRPHttpServletResponse;
import org.exoplatform.services.wsrp.type.LocalizedString;
import org.exoplatform.services.wsrp.type.MarkupType;
import org.exoplatform.services.wsrp.type.PortletDescription;
import org.exoplatform.services.wsrp.type.Property;
import org.exoplatform.services.wsrp.type.PropertyList;
import org.exoplatform.services.wsrp.type.ResourceList;
import org.exoplatform.services.wsrp.utils.Modes;
import org.exoplatform.services.wsrp.utils.Utils;
import org.exoplatform.services.wsrp.utils.WindowStates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSR168ContainerProxyImpl
implements PortletContainerProxy {
    private Log log;
    private PortletContainerService pcService;
    private WSRPConfiguration conf;
    private WSRPPortletPreferencesPersister persister;

    public JSR168ContainerProxyImpl(PortletContainerService service, WSRPConfiguration conf) {
        this.pcService = service;
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp1");
        this.conf = conf;
        this.persister = WSRPPortletPreferencesPersister.getInstance();
    }

    @Override
    public boolean isPortletOffered(String portletHandle) {
        String[] key = StringUtils.split((String)portletHandle, (String)"/");
        String pcPortletHandle = key[0] + "/" + key[1];
        return pcPortletHandle != null && this.pcService.getAllPortletMetaData().get(pcPortletHandle) != null;
    }

    @Override
    public ResourceList getResourceList(String[] desiredLocales) {
        return new ResourceList();
    }

    @Override
    public PortletDescription getPortletDescription(String portletHandle, String[] desiredLocales) {
        List portletDisplayNames;
        String[] k = StringUtils.split((String)portletHandle, (String)"/");
        String portletApplicationName = k[0];
        String portletName = k[1];
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("get description of portlet in application : " + portletApplicationName));
            this.log.debug((Object)("get description of portlet : " + portletName));
        }
        Map portletMetaDatas = this.pcService.getAllPortletMetaData();
        PortletData portlet = (PortletData)portletMetaDatas.get(k[0] + "/" + k[1]);
        PortletDescription pD = new PortletDescription();
        pD.setPortletHandle(portletHandle);
        pD.setOnlySecure(new Boolean(portlet.isSecure()));
        pD.setDefaultMarkupSecure(new Boolean(portlet.isSecure()));
        List portletDescriptions = portlet.getDescription();
        if (portletDescriptions != null && portletDescriptions.size() != 0) {
            pD.setDescription(this.getDescription(portletDescriptions, desiredLocales));
        }
        if ((portletDisplayNames = portlet.getDisplayName()) != null && portletDisplayNames.size() != 0) {
            pD.setDisplayName(this.getDisplayName(portletDisplayNames, desiredLocales));
        }
        pD.setGroupID(portletApplicationName);
        pD.setKeywords(this.getKeyWords(portletApplicationName, portletName, desiredLocales));
        pD.setMarkupTypes(this.setMarkupTypes(portlet.getSupports(), desiredLocales));
        pD.setTitle(this.getTitle(portletApplicationName, portletName, desiredLocales));
        pD.setShortTitle(this.getShortTitle(portletApplicationName, portletName, desiredLocales));
        pD.setUserProfileItems(this.getUserProfileItems(portlet.getUserAttributes()));
        pD.setHasUserSpecificState(new Boolean(this.conf.isHasUserSpecificState()));
        pD.setDoesUrlTemplateProcessing(new Boolean(this.conf.isDoesUrlTemplateProcessing()));
        pD.setTemplatesStoredInSession(new Boolean(this.conf.isTemplatesStoredInSession()));
        pD.setUserContextStoredInSession(new Boolean(this.conf.isUserContextStoredInSession()));
        pD.setUsesMethodGet(new Boolean(this.conf.isUsesMethodGet()));
        return pD;
    }

    @Override
    public void setPortletProperties(String portletHandle, String owner, PropertyList propertyList) throws WSRPException {
        this.log.debug((Object)("portlet handle to split in setPortletProperties : " + portletHandle));
        String[] key = StringUtils.split((String)portletHandle, (String)"/");
        Property[] properties = propertyList.getProperties();
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (int i = 0; i < properties.length; ++i) {
            Property property = properties[i];
            String preferenceName = property.getName();
            String preferenceValue = property.getStringValue();
            propertiesMap.put(preferenceName, preferenceValue);
        }
        Input input = new Input();
        ExoWindowID windowID = new ExoWindowID();
        windowID.setOwner(owner);
        windowID.setPortletApplicationName(key[0]);
        windowID.setPortletName(key[1]);
        windowID.setUniqueID(key[2]);
        input.setInternalWindowID((WindowID)windowID);
        input.setPortletPreferencesPersister((PortletPreferencesPersister)this.persister);
        try {
            this.pcService.setPortletPreference(input, propertiesMap);
        }
        catch (Exception e) {
            this.log.error((Object)"error while storing preferences", (Throwable)e);
            throw new WSRPException("OperationFailed");
        }
    }

    @Override
    public Map<String, String[]> getPortletProperties(String portletHandle, String owner) throws WSRPException {
        String[] key = StringUtils.split((String)portletHandle, (String)"/");
        try {
            Input input = new Input();
            ExoWindowID windowID = new ExoWindowID();
            windowID.setOwner(owner);
            windowID.setPortletApplicationName(key[0]);
            windowID.setPortletName(key[1]);
            windowID.setUniqueID(key[2]);
            input.setInternalWindowID((WindowID)windowID);
            input.setPortletPreferencesPersister((PortletPreferencesPersister)this.persister);
            return this.pcService.getPortletPreference(input);
        }
        catch (Exception e) {
            throw new WSRPException("OperationFailed");
        }
    }

    @Override
    public Map<String, PortletData> getAllPortletMetaData() {
        return this.pcService.getAllPortletMetaData();
    }

    @Override
    public Collection<WindowState> getSupportedWindowStates() {
        return this.pcService.getSupportedWindowStates();
    }

    @Override
    public RenderOutput render(WSRPHttpServletRequest request, WSRPHttpServletResponse response, RenderInput input) throws WSRPException {
        try {
            return this.pcService.render((HttpServletRequest)request, (HttpServletResponse)response, input);
        }
        catch (PortletContainerException e) {
            throw new WSRPException("OperationFailed", e);
        }
    }

    @Override
    public ActionOutput processAction(WSRPHttpServletRequest request, WSRPHttpServletResponse response, ActionInput input) throws WSRPException {
        try {
            ActionOutput out = this.pcService.processAction((HttpServletRequest)request, (HttpServletResponse)response, input);
            Map propertiesMap = out.getProperties();
            Set set = propertiesMap.keySet();
            for (String key : set) {
                if (!key.startsWith("org.exoplatform.portal.container.exception")) continue;
                this.log.error((Object)("Error body : " + propertiesMap.get(key)));
                throw new WSRPException("PortletStateChangeRequired");
            }
            return out;
        }
        catch (PortletContainerException e) {
            throw new WSRPException("OperationFailed", e);
        }
    }

    private LocalizedString getDescription(List<Description> list, String[] desiredLocales) {
        for (int i = 0; i < desiredLocales.length; ++i) {
            String desiredLocale = desiredLocales[i];
            for (Description desc : list) {
                if (desc == null || desc.getLang() == null || !desc.getLang().equalsIgnoreCase(desiredLocale)) continue;
                return Utils.getLocalizedString(desc.getDescription(), desiredLocale);
            }
        }
        return null;
    }

    private LocalizedString getDisplayName(List<DisplayName> list, String[] desiredLocales) {
        for (int i = 0; i < desiredLocales.length; ++i) {
            String desiredLocale = desiredLocales[i];
            for (DisplayName displayName : list) {
                if (displayName == null || displayName.getLang() == null || !displayName.getLang().equalsIgnoreCase(desiredLocale)) continue;
                return Utils.getLocalizedString(displayName.getDisplayName(), desiredLocale);
            }
        }
        return null;
    }

    private LocalizedString[] getKeyWords(String portletAppName, String portletName, String[] desiredLocales) {
        for (int i = 0; i < desiredLocales.length; ++i) {
            String desiredLocale = desiredLocales[i];
            ResourceBundle resourceBundle = this.getBundle(portletAppName, portletName, new Locale(desiredLocale));
            System.out.println(" ---- " + portletAppName + "/" + portletName + "/" + desiredLocale);
            System.out.println(" ---- 1:" + resourceBundle);
            System.out.println(" ---- 2:" + resourceBundle.getLocale());
            if (!resourceBundle.getLocale().getLanguage().equalsIgnoreCase(desiredLocale) && i != desiredLocales.length - 1) continue;
            try {
                String keyWords = resourceBundle.getString("javax.portlet.keywords");
                String[] a = StringUtils.split((String)keyWords, (String)",");
                LocalizedString[] b = new LocalizedString[a.length];
                for (int j = 0; j < a.length; ++j) {
                    b[j] = Utils.getLocalizedString(a[j], desiredLocale);
                }
                return b;
            }
            catch (MissingResourceException ex) {
                this.log.debug((Object)("No keyword defined for the portlet " + portletAppName + "/" + portletName));
                return null;
            }
        }
        return null;
    }

    private MarkupType[] setMarkupTypes(List<Supports> supports, String[] locales) {
        MarkupType[] array = new MarkupType[supports.size()];
        int i = 0;
        MarkupType mT = null;
        for (Supports support : supports) {
            mT = new MarkupType();
            mT.setMimeType(support.getMimeType());
            List portletModes = support.getPortletMode();
            String[] modesInArray = new String[portletModes.size()];
            int j = 0;
            for (String pM : portletModes) {
                modesInArray[j] = Modes.addPrefixWSRP(pM);
                ++j;
            }
            mT.setModes(modesInArray);
            j = 0;
            List windowStates = support.getWindowState();
            String[] windowStatesInArray = new String[windowStates.size()];
            for (String wS : windowStates) {
                windowStatesInArray[j] = WindowStates.addPrefixWSRP(wS);
                ++j;
            }
            mT.setWindowStates(windowStatesInArray);
            mT.setLocales(locales);
            array[i] = mT;
            ++i;
        }
        return array;
    }

    private LocalizedString getTitle(String portletAppName, String portletName, String[] desiredLocales) {
        for (int i = 0; i < desiredLocales.length; ++i) {
            String desiredLocale = desiredLocales[i];
            ResourceBundle resourceBundle = this.getBundle(portletAppName, portletName, new Locale(desiredLocale));
            if (!resourceBundle.getLocale().getLanguage().equalsIgnoreCase(desiredLocale) && i != desiredLocales.length - 1) continue;
            return Utils.getLocalizedString(resourceBundle.getString("javax.portlet.title"), desiredLocale);
        }
        return null;
    }

    private LocalizedString getShortTitle(String portletAppName, String portletName, String[] desiredLocales) {
        for (int i = 0; i < desiredLocales.length; ++i) {
            String desiredLocale = desiredLocales[i];
            ResourceBundle resourceBundle = this.getBundle(portletAppName, portletName, new Locale(desiredLocale));
            if (!resourceBundle.getLocale().getLanguage().equalsIgnoreCase(desiredLocale) && i != desiredLocales.length - 1) continue;
            try {
                return Utils.getLocalizedString(resourceBundle.getString("javax.portlet.short-title"), desiredLocale);
            }
            catch (MissingResourceException ex) {
                this.log.debug((Object)("No short title defined for the portlet " + portletAppName + "/" + portletName));
                return null;
            }
        }
        return null;
    }

    private String[] getUserProfileItems(List<UserAttribute> userAttributes) {
        String[] toReturnArray = new String[userAttributes.size()];
        int i = 0;
        for (UserAttribute userAttr : userAttributes) {
            toReturnArray[i] = userAttr.getName();
            ++i;
        }
        return toReturnArray;
    }

    private ResourceBundle getBundle(String portletAppName, String portletName, Locale locale) {
        try {
            WSRPHttpServletRequest request = WSRPHTTPContainer.getInstance().getRequest();
            WSRPHttpServletResponse response = WSRPHTTPContainer.getInstance().getResponse();
            return this.pcService.getBundle((HttpServletRequest)request, (HttpServletResponse)response, portletAppName, portletName, locale);
        }
        catch (PortletContainerException e) {
            e.printStackTrace();
            return null;
        }
    }
}

