/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.utils;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletMode;

public class Modes
implements Serializable {
    private static final long serialVersionUID = -6024244156120091359L;
    private String _value_;
    private static Map<String, Modes> _table_ = new HashMap<String, Modes>();
    private static final String _view_jsr = PortletMode.VIEW.toString();
    private static final String _edit_jsr = PortletMode.EDIT.toString();
    private static final String _help_jsr = PortletMode.HELP.toString();
    private static final String _preview_jsr = "preview";
    public static final String _view_wsrp = "wsrp:" + _view_jsr;
    public static final String _edit_wsrp = "wsrp:" + _edit_jsr;
    public static final String _help_wsrp = "wsrp:" + _help_jsr;
    public static final String _preview_wsrp = "wsrp:preview";
    public static final Modes VIEW = new Modes(_view_wsrp);
    public static final Modes EDIT = new Modes(_edit_wsrp);
    public static final Modes HELP = new Modes(_help_wsrp);
    public static final Modes PREVIEW = new Modes("wsrp:preview");

    public Modes(String value) {
        this._value_ = value.toLowerCase(Locale.ENGLISH);
        _table_.put(this._value_, this);
    }

    public String getValue() {
        return this._value_;
    }

    public static Modes fromValue(String value) {
        return _table_.get(value);
    }

    public static Modes fromString(String value) {
        return Modes.fromValue(value);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this._value_;
    }

    public Object readResolve() throws ObjectStreamException {
        return Modes.fromValue(this._value_);
    }

    public static PortletMode getJsrPortletMode(String mode) {
        if (mode == null) {
            throw new IllegalArgumentException("WSRP portlet mode must not be null.");
        }
        if ((mode = Modes.delAllPrefixesWSRP(mode)).equalsIgnoreCase(_view_jsr)) {
            return PortletMode.VIEW;
        }
        if (mode.equalsIgnoreCase(_edit_jsr)) {
            return PortletMode.EDIT;
        }
        if (mode.equalsIgnoreCase(_help_jsr)) {
            return PortletMode.HELP;
        }
        if (mode.equalsIgnoreCase(_preview_jsr)) {
            return new PortletMode(_preview_jsr);
        }
        return new PortletMode(mode);
    }

    public static String addPrefixWSRP(String forAddWSRP) {
        return "wsrp:" + forAddWSRP.toLowerCase(Locale.ENGLISH);
    }

    public static String getWSRPModeString(PortletMode jsrPortletMode) {
        return Modes.addPrefixWSRP(jsrPortletMode.toString().toLowerCase(Locale.ENGLISH));
    }

    public static String delAllPrefixesWSRP(String forDelWSRP) {
        forDelWSRP = forDelWSRP.toLowerCase(Locale.ENGLISH);
        while (forDelWSRP.startsWith("wsrp:")) {
            forDelWSRP = forDelWSRP.substring("wsrp:".length());
        }
        return forDelWSRP;
    }
}

