/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.producer.impl;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.portletcontainer.PortletContainerConf;
import org.exoplatform.services.portletcontainer.pci.CustomModeWithDescription;
import org.exoplatform.services.portletcontainer.pci.CustomWindowStateWithDescription;
import org.exoplatform.services.portletcontainer.pci.LocalisedDescription;
import org.exoplatform.services.portletcontainer.pci.PortletData;
import org.exoplatform.services.wsrp.producer.PortletContainerProxy;
import org.exoplatform.services.wsrp.producer.ServiceDescriptionInterface;
import org.exoplatform.services.wsrp.producer.impl.WSRPConfiguration;
import org.exoplatform.services.wsrp.type.CookieProtocol;
import org.exoplatform.services.wsrp.type.ItemDescription;
import org.exoplatform.services.wsrp.type.ModelDescription;
import org.exoplatform.services.wsrp.type.PortletDescription;
import org.exoplatform.services.wsrp.type.RegistrationContext;
import org.exoplatform.services.wsrp.type.ResourceList;
import org.exoplatform.services.wsrp.type.ServiceDescription;
import org.exoplatform.services.wsrp.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDescriptionInterfaceImpl
implements ServiceDescriptionInterface {
    private PortletContainerProxy cont;
    public static String[] localesArray = new String[]{"en", "fr"};
    private WSRPConfiguration conf;
    private Log log;
    private ExoContainer container;
    private PortletContainerConf config;

    public ServiceDescriptionInterfaceImpl(PortletContainerProxy cont, WSRPConfiguration conf, ExoContainerContext context) {
        this.cont = cont;
        this.conf = conf;
        this.log = ExoLogger.getLogger((String)"org.exoplatform.services.wsrp");
        this.container = context.getContainer();
        this.config = (PortletContainerConf)this.container.getComponentInstanceOfType(PortletContainerConf.class);
    }

    @Override
    public ServiceDescription getServiceDescription(RegistrationContext registrationContext, String[] desiredLocales) throws RemoteException {
        if (desiredLocales == null) {
            desiredLocales = new String[]{"en", "fr"};
        }
        this.log.debug((Object)("getServiceDescription entered with registrationContext : " + registrationContext));
        Map<String, PortletData> portletMetaDatas = this.cont.getAllPortletMetaData();
        Set<String> keys = portletMetaDatas.keySet();
        HashSet<String> keys2 = new HashSet<String>(keys);
        if (this.conf.getExcludeList() != null) {
            for (String handle : this.conf.getExcludeList()) {
                if (handle.endsWith("*")) {
                    for (String object : keys2) {
                        if (!object.startsWith(handle.substring(0, handle.length() - 1))) continue;
                        keys.remove(object);
                    }
                    continue;
                }
                if (!keys.contains(handle)) continue;
                keys.remove(handle);
            }
        }
        PortletDescription[] pdescription = new PortletDescription[keys.size()];
        int i = 0;
        for (String producerOfferedPortletHandle : keys) {
            this.log.debug((Object)"fill service description with portlet description ");
            pdescription[i] = this.cont.getPortletDescription(producerOfferedPortletHandle, desiredLocales);
            ++i;
        }
        ServiceDescription sD = new ServiceDescription();
        sD.setRequiresRegistration(this.conf.isRegistrationRequired());
        sD.setRegistrationPropertyDescription(new ModelDescription());
        sD.setRequiresInitCookie(CookieProtocol.none);
        sD.setCustomModeDescriptions(this.getCustomModeDescriptions(this.config.getSupportedPortletModesWithDescriptions()));
        sD.setCustomUserProfileItemDescriptions(new ItemDescription[0]);
        sD.setCustomWindowStateDescriptions(this.getCustomWindowStateDescriptions(this.config.getSupportedWindowStatesWithDescriptions()));
        sD.setLocales(localesArray);
        sD.setOfferedPortlets(pdescription);
        sD.setResourceList(new ResourceList());
        return sD;
    }

    private ItemDescription[] getCustomWindowStateDescriptions(Collection<CustomWindowStateWithDescription> collection) {
        ArrayList<ItemDescription> c = new ArrayList<ItemDescription>();
        for (CustomWindowStateWithDescription element : collection) {
            List l = element.getDescriptions();
            ItemDescription iD = null;
            for (LocalisedDescription d : l) {
                iD = new ItemDescription();
                iD.setItemName(element.getWindowState().toString());
                iD.setDescription(Utils.getLocalizedString(d.getDescription(), d.getLocale().getLanguage()));
                c.add(iD);
            }
        }
        ItemDescription[] iDTab = new ItemDescription[c.size()];
        int i = 0;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            iDTab[i] = (ItemDescription)iter.next();
            ++i;
        }
        return iDTab;
    }

    private ItemDescription[] getCustomModeDescriptions(Collection<CustomModeWithDescription> collection) {
        ArrayList<ItemDescription> c = new ArrayList<ItemDescription>();
        for (CustomModeWithDescription element : collection) {
            List l = element.getDescriptions();
            ItemDescription iD = null;
            for (LocalisedDescription d : l) {
                iD = new ItemDescription();
                iD.setItemName(element.getPortletMode().toString());
                iD.setDescription(Utils.getLocalizedString(d.getDescription(), d.getLocale().getLanguage()));
                c.add(iD);
            }
        }
        ItemDescription[] iDTab = new ItemDescription[c.size()];
        int i = 0;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            iDTab[i] = (ItemDescription)iter.next();
            ++i;
        }
        return iDTab;
    }
}

