/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wsrp.consumer.portlets;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import javax.portlet.PortletMode;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.portletcontainer.PortletContainerConf;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.services.portletcontainer.PortletContainerService;
import org.exoplatform.services.portletcontainer.pci.ActionInput;
import org.exoplatform.services.portletcontainer.pci.ActionOutput;
import org.exoplatform.services.portletcontainer.pci.RenderInput;
import org.exoplatform.services.portletcontainer.pci.RenderOutput;
import org.exoplatform.services.portletcontainer.plugins.pc.portletAPIImp.PortletURLImp;
import org.exoplatform.services.wsrp.consumer.ConsumerEnvironment;
import org.exoplatform.services.wsrp.consumer.Producer;
import org.exoplatform.services.wsrp.consumer.ProducerRegistry;
import org.exoplatform.services.wsrp.exceptions.WSRPException;
import org.exoplatform.services.wsrp.producer.impl.WSRPConfiguration;
import org.exoplatform.services.wsrp.type.CookieProtocol;
import org.exoplatform.services.wsrp.type.LocalizedString;
import org.exoplatform.services.wsrp.type.MarkupType;
import org.exoplatform.services.wsrp.type.PortletDescription;
import org.exoplatform.services.wsrp.type.RegistrationData;
import org.exoplatform.services.wsrp.type.ServiceDescription;

public class WSRPAdminPortlet {
    private String portletTitle;
    private String producerName;
    private String producerURL;
    private String markupIntfEndpoint;
    private String portletManagementIntfEndpoint;
    private String registrationIntfEndpoint;
    private String serviceDescriptionIntfEndpoint;
    private String description = "";
    private String[] consumerModes;
    private String[] consumerStates;
    private String consumerName = "www.exoplatform.org";
    private String consumerAgent = "exoplatform.1.0";
    private ConsumerEnvironment consumer;
    private WSRPConfiguration conf;
    private PortletContainerConf pcConf;
    private PortletContainerService pcService;

    public void init(ExoContainer cont) {
        this.consumer = (ConsumerEnvironment)cont.getComponentInstanceOfType(ConsumerEnvironment.class);
        this.conf = (WSRPConfiguration)cont.getComponentInstanceOfType(WSRPConfiguration.class);
        this.pcService = (PortletContainerService)cont.getComponentInstanceOfType(PortletContainerService.class);
        this.pcConf = (PortletContainerConf)cont.getComponentInstanceOfType(PortletContainerConf.class);
        Collection modes = this.pcService.getSupportedPortletModes();
        Collection states = this.pcService.getSupportedWindowStates();
        this.consumerModes = new String[modes.size()];
        Iterator mIterator = modes.iterator();
        int j = 0;
        while (mIterator.hasNext()) {
            PortletMode mode = (PortletMode)mIterator.next();
            this.consumerModes[j] = "wsrp:" + mode.toString();
            ++j;
        }
        this.consumerStates = new String[states.size()];
        Iterator sIterator = states.iterator();
        j = 0;
        while (sIterator.hasNext()) {
            WindowState state = (WindowState)sIterator.next();
            this.consumerStates[j] = "wsrp:" + state.toString();
            ++j;
        }
        this.reset();
    }

    public void render(RenderInput input, RenderOutput output) throws PortletContainerException {
        try {
            output.setTitle(this.portletTitle);
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            PrintWriter w = new PrintWriter(charArrayWriter);
            PortletURL actionURL = null;
            if (input.getPortletURLFactory() != null) {
                actionURL = input.getPortletURLFactory().createPortletURL("action");
            }
            actionURL = new PortletURLImp("action", input.getBaseURL(), input.getMarkup(), null, true, input.getEscapeXml(), null);
            actionURL.setWindowState(WindowState.NORMAL);
            actionURL.setPortletMode(PortletMode.VIEW);
            w.println("<center><b>Register remote producer for WSRP1 plugin.</b></center><br>");
            w.println("<form name=\"producer_wsrp1_form\" method=\"post\" action=\"" + actionURL.toString() + "\">");
            w.println("  <input type=\"hidden\" name=\"op\" value=\"\"/>");
            w.println("    <table>");
            w.println("    <tr><td><label>Producer Name</label></td>");
            w.println("      <td><input name=\"producerName\" value=\"" + this.producerName + "\" type=\"text\" size=\"45\"></td></tr>");
            w.println("    <tr><td><label>Producer URL</label></td>");
            w.println("      <td><input name=\"producerURL\" value=\"" + this.producerURL + "\" type=\"text\" size=\"45\"></td></tr>");
            w.println("    <tr><td><label>Markup Interface End Point</label></td>");
            w.println("      <td><input name=\"markupIntfEndpoint\" value=\"" + this.markupIntfEndpoint + "\" type=\"text\" size=\"45\"></td></tr>");
            w.println("    <tr><td><label>Portlet Management Interface End Point</label></td>");
            w.println("      <td><input name=\"portletManagementIntfEndpoint\" value=\"" + this.portletManagementIntfEndpoint + "\" type=\"text\" size=\"45\"></td></tr>");
            w.println("    <tr><td><label>Registration Interface End Point</label></td>");
            w.println("      <td><input name=\"registrationIntfEndpoint\" value=\"" + this.registrationIntfEndpoint + "\" type=\"text\" size=\"45\"></td></tr>");
            w.println("    <tr><td><label>Service Description Interface End Point</label></td>");
            w.println("      <td><input name=\"serviceDescriptionIntfEndpoint\" value=\"" + this.serviceDescriptionIntfEndpoint + "\" type=\"text\" size=\"45\"></td></tr>");
            w.println("    <tr><td><label>Description</label></td>");
            w.println("      <td><textarea id=\"description\" name=\"description\" cols=\"35\" rows=\"5\">" + this.description + "</textarea></td></tr>");
            w.println("    <tr><td colspan='2' align='center'>");
            w.println("      <a href=\"javascript:submit_producer_wsrp1_form('save');\">Save</a>");
            w.println("      <a href=\"javascript:submit_producer_wsrp1_form('reset');\">Reset</a>");
            w.println("    </td></tr>");
            w.println("  </table>");
            w.println("<script type=\"text/javascript\">");
            w.println("  function submit_producer_wsrp1_form(action) {");
            w.println("    document.producer_wsrp1_form.elements['op'].value = action;");
            w.println("    document.producer_wsrp1_form.submit();");
            w.println("  }");
            w.println("</script>");
            w.println("</form>");
            w.println("<hr>");
            w.println("<table>");
            ProducerRegistry pregistry = this.consumer.getProducerRegistry();
            Iterator<Producer> i = pregistry.getAllProducers();
            ServiceDescription serviceDescr = null;
            while (i.hasNext()) {
                PortletDescription[] portletDescriptions;
                CookieProtocol cookie;
                Producer producer = i.next();
                try {
                    serviceDescr = producer.getServiceDescription();
                }
                catch (WSRPException e) {
                    e.printStackTrace(w);
                }
                w.println("<tr>");
                w.println("<td colspan='2'>");
                w.println("<b>Name - " + producer.getName() + ", ID - " + producer.getID() + "</b><br><br>");
                w.println("RegistrationInterfaceEndpoint - " + producer.getRegistrationInterfaceEndpoint() + "<br>");
                w.println("</td>");
                w.println("</tr>");
                w.println("<tr>");
                w.println("<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>");
                w.println("<td>");
                w.println("<table>");
                w.println("<tr>");
                w.println("<td>Requires Registration </td>");
                String answer = "N/A";
                if (serviceDescr != null) {
                    answer = Boolean.toString(serviceDescr.isRequiresRegistration());
                }
                w.println("<td>" + answer + "</td>");
                w.println("</tr>");
                w.println("<tr>");
                w.println("<td>Requires Init Cookie </td>");
                answer = "none";
                if (serviceDescr != null && (cookie = serviceDescr.getRequiresInitCookie()) != null) {
                    answer = cookie.getValue();
                }
                w.println("<td>" + answer + "</td>");
                w.println("</tr>");
                if (serviceDescr != null && (portletDescriptions = serviceDescr.getOfferedPortlets()) != null) {
                    for (int k = 0; k < portletDescriptions.length; ++k) {
                        PortletDescription portletDescription = portletDescriptions[k];
                        w.println("<tr><td colspan='2'><b><br>" + this.getValue(portletDescription.getDisplayName()) + "</b></td></tr>");
                        w.println("<tr><td>portletHandle</td><td>" + portletDescription.getPortletHandle().toString() + "</td></tr>");
                        w.println("<tr><td>groupId</td><td>" + portletDescription.getGroupID().toString() + "</td></tr>");
                        w.println("<tr><td>title</td><td>" + this.getValue(portletDescription.getTitle()) + "</td></tr>");
                        w.println("<tr><td>shortTitle</td><td>" + this.getValue(portletDescription.getShortTitle()) + "</td></tr>");
                        w.println("<tr><td>displayName</td><td>" + this.getValue(portletDescription.getDisplayName()) + "</td></tr>");
                        StringBuffer value = new StringBuffer();
                        LocalizedString[] keywords = portletDescription.getKeywords();
                        if (keywords != null) {
                            for (int j = 0; j < keywords.length; ++j) {
                                value.append(this.getValue(keywords[j])).append(" ");
                            }
                        }
                        w.println("<tr><td>keywords</td><td>" + value.toString() + "</td></tr>");
                        MarkupType[] types = portletDescription.getMarkupTypes();
                        value.setLength(0);
                        for (int j = 0; j < types.length; ++j) {
                            value.append(types[j].getMimeType()).append(" ");
                        }
                        w.println("<tr><td>markupType</td><td>" + value.toString() + "</td></tr>");
                        String[] userCategories = portletDescription.getUserCategories();
                        String valueCategories = "";
                        if (userCategories != null) {
                            value.setLength(0);
                            for (int j = 0; j < userCategories.length; ++j) {
                                value.append(userCategories[j]).append(" ");
                            }
                            valueCategories = value.toString();
                        }
                        w.println("<tr><td>userCategory</td><td>" + valueCategories + "</td></tr>");
                        String[] userProfileItems = portletDescription.getUserProfileItems();
                        String valueProfileItem = "";
                        if (userProfileItems != null) {
                            value.setLength(0);
                            for (int j = 0; j < userProfileItems.length; ++j) {
                                value.append(userProfileItems[j]).append(" ");
                            }
                            valueProfileItem = value.toString();
                        }
                        w.println("<tr><td>userProfileItem</td><td>" + valueProfileItem + "</td></tr>");
                        w.println("<tr><td>usesMethodGet</td><td>" + portletDescription.getUsesMethodGet().toString() + "</td></tr>");
                        if (portletDescription.getDefaultMarkupSecure() != null) {
                            w.println("<tr><td>defaultMarkupSecure</td><td>" + portletDescription.getDefaultMarkupSecure().toString() + "</td></tr>");
                        }
                        if (portletDescription.getOnlySecure() != null) {
                            w.println("<tr><td>onlySecure</td><td>" + portletDescription.getOnlySecure().toString() + "</td></tr>");
                        }
                        if (portletDescription.getUserContextStoredInSession() != null) {
                            w.println("<tr><td>userContextStoredInSession</td><td>" + portletDescription.getUserContextStoredInSession().toString() + "</td></tr>");
                        }
                        if (portletDescription.getTemplatesStoredInSession() != null) {
                            w.println("<tr><td>templatesStoredInSession</td><td>" + portletDescription.getTemplatesStoredInSession().toString() + "</td></tr>");
                        }
                        if (portletDescription.getHasUserSpecificState() != null) {
                            w.println("<tr><td>hasUserSpecificState</td><td>" + portletDescription.getHasUserSpecificState().toString() + "</td></tr>");
                        }
                        if (portletDescription.getDoesUrlTemplateProcessing() != null) {
                            w.println("<tr><td>doesUrlTemplateProcessing</td><td>" + portletDescription.getDoesUrlTemplateProcessing().toString() + "</td></tr>");
                        }
                        w.println("<tr><td>extensions</td><td>N/A</td></tr>");
                    }
                }
                w.println("</table>");
                w.println("</td>");
                w.println("</tr>");
            }
            w.println("</table>");
            try {
                output.setContent(new String(charArrayWriter.toCharArray()).getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                output.setContent(new String(charArrayWriter.toCharArray()).getBytes());
            }
        }
        catch (Exception e) {
            throw new PortletContainerException("Exception in WSRPAdminPortlet");
        }
    }

    public void processAction(ActionInput input, ActionOutput output, HttpServletRequest request) {
        try {
            String action = request.getParameter("op");
            if (action.equals("reset")) {
                this.reset();
            }
            if (action.equals("save")) {
                this.producerName = request.getParameter("producerName");
                this.producerURL = request.getParameter("producerURL");
                this.markupIntfEndpoint = request.getParameter("markupIntfEndpoint");
                this.portletManagementIntfEndpoint = request.getParameter("portletManagementIntfEndpoint");
                this.registrationIntfEndpoint = request.getParameter("registrationIntfEndpoint");
                this.serviceDescriptionIntfEndpoint = request.getParameter("serviceDescriptionIntfEndpoint");
                this.description = request.getParameter("description");
                String pURL = this.producerURL;
                String producerId = "producer1" + Integer.toString(pURL.hashCode());
                ProducerRegistry pregistry = this.consumer.getProducerRegistry();
                Producer producer = pregistry.createProducerInstance();
                producer.setID(producerId);
                producer.setName(this.producerName);
                producer.setMarkupInterfaceEndpoint(pURL + this.markupIntfEndpoint);
                producer.setPortletManagementInterfaceEndpoint(pURL + this.portletManagementIntfEndpoint);
                producer.setRegistrationInterfaceEndpoint(pURL + this.registrationIntfEndpoint);
                producer.setServiceDescriptionInterfaceEndpoint(pURL + this.serviceDescriptionIntfEndpoint);
                producer.setDescription(this.description);
                producer.setDesiredLocales(new String[]{"en"});
                if (producer.isRegistrationRequired()) {
                    String[] CONSUMER_SCOPES = new String[]{"chunk_data"};
                    String[] CONSUMER_CUSTOM_PROFILES = new String[]{"what_more"};
                    RegistrationData registrationData = new RegistrationData();
                    registrationData.setConsumerName(this.consumerName);
                    registrationData.setConsumerAgent(this.consumerAgent);
                    registrationData.setMethodGetSupported(false);
                    registrationData.setConsumerModes(this.consumerModes);
                    registrationData.setConsumerWindowStates(this.consumerStates);
                    registrationData.setConsumerUserScopes(CONSUMER_SCOPES);
                    registrationData.setCustomUserProfileData(CONSUMER_CUSTOM_PROFILES);
                    registrationData.setRegistrationProperties(null);
                    registrationData.setExtensions(null);
                    producer.register(registrationData);
                }
                pregistry.addProducer(producer);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void reset() {
        if (this.conf != null && this.conf.getAdminPortletParams() != null) {
            this.portletTitle = this.conf.getAdminPortletParams().get("portletTitle");
            this.consumerName = this.conf.getAdminPortletParams().get("consumerName");
            this.consumerAgent = this.conf.getAdminPortletParams().get("consumerAgent");
            this.producerName = this.conf.getAdminPortletParams().get("producerName");
            this.producerURL = this.conf.getAdminPortletParams().get("producerURL");
            this.markupIntfEndpoint = this.conf.getAdminPortletParams().get("markupIntfEndpoint");
            this.portletManagementIntfEndpoint = this.conf.getAdminPortletParams().get("portletManagementIntfEndpoint");
            this.registrationIntfEndpoint = this.conf.getAdminPortletParams().get("registrationIntfEndpoint");
            this.serviceDescriptionIntfEndpoint = this.conf.getAdminPortletParams().get("serviceDescriptionIntfEndpoint");
            this.description = this.conf.getAdminPortletParams().get("description");
            return;
        }
        this.portletTitle = "WSRPAdminPortlet";
        this.consumerName = "www.exoplatform.org";
        this.consumerAgent = "exoplatform.1.0";
        this.producerName = "exo producer";
        this.producerURL = "http://localhost:8080/portal/services/";
        this.markupIntfEndpoint = "WSRPMarkupService";
        this.portletManagementIntfEndpoint = "WSRPPortletManagementService";
        this.registrationIntfEndpoint = "WSRPRegistrationService";
        this.serviceDescriptionIntfEndpoint = "WSRPServiceDescriptionService";
        this.description = "";
    }

    protected String getValue(LocalizedString s) {
        if (s == null) {
            return "";
        }
        return s.getValue();
    }
}

