/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.notification.plugin;

import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.processes.notification.utils.NotificationArguments;
import org.exoplatform.processes.notification.utils.NotificationUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CreateRequestPlugin
extends BaseNotificationPlugin {
    private static final Log LOG = ExoLogger.getLogger(CreateRequestPlugin.class);
    public static final String ID = "CreateRequestPlugin";

    public CreateRequestPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext notificationContext) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext notificationContext) {
        String requester = (String)notificationContext.value(NotificationArguments.REQUEST_CREATOR);
        String process = (String)notificationContext.value(NotificationArguments.REQUEST_PROCESS);
        String processUrl = (String)notificationContext.value(NotificationArguments.PROCESS_URL);
        String requestTitle = (String)notificationContext.value(NotificationArguments.REQUEST_TITLE);
        String requestDescription = (String)notificationContext.value(NotificationArguments.REQUEST_DESCRIPTION);
        String requestUrl = (String)notificationContext.value(NotificationArguments.REQUEST_URL);
        String workflowProjectId = (String)notificationContext.value(NotificationArguments.WORKFLOW_PROJECT_ID);
        List<String> receivers = NotificationUtils.getReceivers(Long.parseLong(workflowProjectId), requester, true);
        return NotificationInfo.instance().setFrom(requester).to(receivers).with(NotificationArguments.REQUEST_CREATOR.getKey(), requester).with(NotificationArguments.REQUEST_PROCESS.getKey(), process).with(NotificationArguments.REQUEST_TITLE.getKey(), requestTitle).with(NotificationArguments.REQUEST_DESCRIPTION.getKey(), requestDescription).with(NotificationArguments.PROCESS_URL.getKey(), processUrl).with(NotificationArguments.REQUEST_URL.getKey(), requestUrl).key(this.getKey()).end();
    }
}

