/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.service;

import java.io.IOException;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.processes.model.IllustrativeAttachment;
import org.exoplatform.processes.model.ProcessesFilter;
import org.exoplatform.processes.model.Work;
import org.exoplatform.processes.model.WorkFilter;
import org.exoplatform.processes.model.WorkFlow;
import org.exoplatform.processes.model.WorkStatus;
import org.exoplatform.processes.service.ProcessesService;
import org.exoplatform.processes.storage.ProcessesStorage;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ProcessesServiceImpl
implements ProcessesService {
    private static final Log LOG = ExoLogger.getLogger(ProcessesServiceImpl.class);
    private final ProcessesStorage processesStorage;

    public ProcessesServiceImpl(ProcessesStorage processesStorage) {
        this.processesStorage = processesStorage;
    }

    public List<WorkFlow> getWorkFlows(ProcessesFilter filter, int offset, int limit, long userIdentityId) throws IllegalAccessException {
        return this.processesStorage.findWorkFlows(filter, userIdentityId, offset, limit);
    }

    public int countWorkFlows(ProcessesFilter filter, long userIdentityId) throws IllegalAccessException {
        return this.processesStorage.countWorkFlows(filter);
    }

    public WorkFlow getWorkFlow(long id) throws IllegalAccessException {
        return this.processesStorage.getWorkFlowById(id);
    }

    public WorkFlow createWorkFlow(WorkFlow workFlow, long userId) throws IllegalAccessException {
        if (workFlow == null) {
            throw new IllegalArgumentException("workFlow is mandatory");
        }
        if (workFlow.getId() != 0L) {
            throw new IllegalArgumentException("workFlow id must be equal to 0");
        }
        return this.processesStorage.saveWorkFlow(workFlow, userId);
    }

    public WorkFlow updateWorkFlow(WorkFlow workFlow, long userId) throws IllegalArgumentException, ObjectNotFoundException, IllegalAccessException {
        if (workFlow == null) {
            throw new IllegalArgumentException("Workflow Type is mandatory");
        }
        if (workFlow.getId() == 0L) {
            throw new IllegalArgumentException("workflow type id must not be equal to 0");
        }
        WorkFlow oldWorkFlow = this.processesStorage.getWorkFlowById(workFlow.getId());
        if (oldWorkFlow == null) {
            throw new ObjectNotFoundException("oldWorkFlow is not exist");
        }
        if (oldWorkFlow.equals((Object)workFlow)) {
            throw new IllegalArgumentException("there are no changes to save");
        }
        return this.processesStorage.saveWorkFlow(workFlow, userId);
    }

    public List<Work> getWorks(long userIdentityId, WorkFilter workFilter, int offset, int limit) throws Exception {
        return this.processesStorage.getWorks(userIdentityId, workFilter, offset, limit);
    }

    public WorkFlow getWorkFlowByProjectId(long projectId) {
        return this.processesStorage.getWorkFlowByProjectId(projectId);
    }

    public Work createWork(Work work, long userId) throws IllegalAccessException {
        if (work == null) {
            throw new IllegalArgumentException("work is mandatory");
        }
        if (work.getId() != 0L) {
            throw new IllegalArgumentException("work id must be equal to 0");
        }
        return this.processesStorage.saveWork(work, userId);
    }

    public Work updateWork(Work work, long userId) throws IllegalArgumentException, ObjectNotFoundException, IllegalAccessException {
        if (work == null) {
            throw new IllegalArgumentException("Work is mandatory");
        }
        if (work.getId() == 0L) {
            throw new IllegalArgumentException("work id must not be equal to 0");
        }
        Work oldWork = this.processesStorage.getWorkById(work.getId());
        if (oldWork == null) {
            throw new ObjectNotFoundException("oldWork is not exist");
        }
        if (oldWork.equals((Object)work)) {
            throw new IllegalArgumentException("there are no changes to save");
        }
        return this.processesStorage.saveWork(work, userId);
    }

    public void deleteWorkflowById(Long workflowId) {
        this.processesStorage.deleteWorkflowById(workflowId);
    }

    public int countWorksByWorkflow(Long projectId, Boolean isCompleted) throws Exception {
        if (projectId == null) {
            throw new IllegalArgumentException("Project Id is mandatory");
        }
        if (isCompleted == null) {
            throw new IllegalArgumentException("isCompleted should not be null");
        }
        return this.processesStorage.countWorksByWorkflow(projectId.longValue(), isCompleted.booleanValue());
    }

    public void deleteWorkById(Long workId) {
        if (workId == null) {
            throw new IllegalArgumentException("Work Id is mandatory");
        }
        this.processesStorage.deleteWorkById(workId);
    }

    public Work updateWorkCompleted(Long workId, boolean completed) {
        if (workId == null) {
            throw new IllegalArgumentException("Work id is mandatory");
        }
        return this.processesStorage.updateWorkCompleted(workId, completed);
    }

    public Work createWorkDraft(Work work, long userId) throws IllegalArgumentException {
        if (work == null) {
            throw new IllegalArgumentException("WorkDraft is mandatory");
        }
        if (work.getId() != 0L) {
            throw new IllegalArgumentException("WorkDraft id must be equal to 0");
        }
        return this.processesStorage.saveWorkDraft(work, userId);
    }

    public Work updateWorkDraft(Work work, long userId) throws IllegalArgumentException, ObjectNotFoundException {
        if (work == null) {
            throw new IllegalArgumentException("WorkDraft Type is mandatory");
        }
        if (work.getId() == 0L) {
            throw new IllegalArgumentException("WorkDraft type id must not be equal to 0");
        }
        Work oldWork = this.processesStorage.getWorkDraftyId(work.getId());
        if (oldWork == null) {
            throw new ObjectNotFoundException("oldWorkDraft is not exist");
        }
        if (oldWork.equals((Object)work)) {
            throw new IllegalArgumentException("there are no changes to save");
        }
        return this.processesStorage.saveWorkDraft(work, userId);
    }

    public List<Work> getWorkDrafts(long userIdentityId, WorkFilter workFilter, int offset, int limit) {
        return this.processesStorage.findAllWorkDraftsByUser(workFilter, offset, limit, userIdentityId);
    }

    public void deleteWorkDraftById(Long draftId) {
        if (draftId == null) {
            throw new IllegalArgumentException("WorkDraft id is mandatory");
        }
        this.processesStorage.deleteWorkDraftById(draftId.longValue());
    }

    public List<WorkStatus> getAvailableWorkStatuses() {
        return this.processesStorage.getAvailableWorkStatuses();
    }

    public Work getWorkById(long userIdentityId, Long workId) {
        if (workId == null) {
            throw new IllegalArgumentException("Work id is mandatory");
        }
        return this.processesStorage.getWorkById(userIdentityId, workId.longValue());
    }

    public IllustrativeAttachment getIllustrationImageById(Long illustrationId) throws FileStorageException, ObjectNotFoundException, IOException {
        if (illustrationId == null) {
            throw new IllegalArgumentException("IllustrationId id is mandatory");
        }
        return this.processesStorage.getIllustrationImageById(illustrationId);
    }
}

