/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.listener;

import java.util.Collection;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class ProcessesMemberShipListener
extends MembershipEventListener {
    private static final String PROCESSES_GROUP_ID = "/platform/processes";
    private static final String PROCESSES_SPACE_GROUP_ID = "/spaces/processes_space";
    private static final String MEMBER = "member";
    private static final String MANAGER = "manager";
    private SpaceService spaceService;
    private OrganizationService organizationService;

    public ProcessesMemberShipListener(SpaceService spaceService, OrganizationService organizationService) {
        this.spaceService = spaceService;
        this.organizationService = organizationService;
    }

    public void postSave(Membership m, boolean isNew) throws Exception {
        Space space = this.spaceService.getSpaceByGroupId(PROCESSES_SPACE_GROUP_ID);
        if (space == null) {
            return;
        }
        if (m.getGroupId().equals(PROCESSES_GROUP_ID) && !this.spaceService.isManager(space, m.getUserName())) {
            this.spaceService.setManager(space, m.getUserName(), true);
        }
        if (m.getGroupId().equals(PROCESSES_SPACE_GROUP_ID) && m.getMembershipType().equals(MANAGER)) {
            Group group = this.organizationService.getGroupHandler().findGroupById(PROCESSES_GROUP_ID);
            User user = this.organizationService.getUserHandler().findUserByName(m.getUserName());
            MembershipType membershipType = this.organizationService.getMembershipTypeHandler().findMembershipType(MEMBER);
            this.organizationService.getMembershipHandler().linkMembership(user, group, membershipType, true);
        }
    }

    public void postDelete(Membership m) throws Exception {
        Space space = this.spaceService.getSpaceByGroupId(PROCESSES_SPACE_GROUP_ID);
        if (space == null) {
            return;
        }
        if (m.getGroupId().equals(PROCESSES_GROUP_ID) && this.spaceService.isManager(space, m.getUserName())) {
            this.spaceService.setManager(space, m.getUserName(), false);
        }
        if (m.getGroupId().equals(PROCESSES_SPACE_GROUP_ID) && m.getMembershipType().equals(MANAGER)) {
            Group group = this.organizationService.getGroupHandler().findGroupById(PROCESSES_GROUP_ID);
            Collection memberships = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(m.getUserName(), group.getId());
            for (Membership membership : memberships) {
                this.organizationService.getMembershipHandler().removeMembership(membership.getId(), true);
            }
        }
    }
}

