/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.processes.entity.WorkEntity;
import org.exoplatform.processes.model.WorkFilter;

public class WorkDraftDAO
extends GenericDAOJPAImpl<WorkEntity, Long> {
    private Query buildWorkQueryCriteria(WorkFilter workFilter, Long userId) {
        String q = workFilter.getQuery();
        Boolean isDraft = workFilter.getIsDraft();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(WorkEntity.class);
        Root root = criteriaQuery.from(WorkEntity.class);
        Join work = root.join("workFlow", JoinType.LEFT);
        if (q != null) {
            ArrayList<Predicate> qPredicates = new ArrayList<Predicate>();
            qPredicates.add(criteriaBuilder.like((Expression)work.get("title"), "%" + q + "%"));
            qPredicates.add(criteriaBuilder.like((Expression)root.get("title"), "%" + q + "%"));
            qPredicates.add(criteriaBuilder.like((Expression)root.get("description"), "%" + q + "%"));
            predicates.add(criteriaBuilder.or(qPredicates.toArray(new Predicate[0])));
        }
        if (isDraft != null) {
            predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get("isDraft"), (Object)isDraft)}));
        }
        if (userId != null) {
            predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get("creatorId"), (Object)userId)}));
        }
        criteriaQuery.select((Selection)root).where(predicates.toArray(new Predicate[0]));
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get("id"))});
        TypedQuery query = this.getEntityManager().createQuery(criteriaQuery);
        return query;
    }

    public List<WorkEntity> findAllWorkDraftsByUser(WorkFilter workFilter, long userId, int offset, int limit) {
        List resultList;
        Query query = this.buildWorkQueryCriteria(workFilter, userId);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public List<WorkEntity> getDraftsByWorkflowId(long workflowId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Work.findAllWorkDraftsByWorkflowId", WorkEntity.class);
        query.setParameter("workflowId", (Object)workflowId);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList;
    }
}

