/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.notification.provider;

import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.annotation.TemplateConfig;
import org.exoplatform.commons.api.notification.annotation.TemplateConfigs;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.processes.notification.utils.NotificationArguments;
import org.exoplatform.processes.notification.utils.NotificationUtils;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.webui.utils.TimeConvertUtils;

@TemplateConfigs(templates={@TemplateConfig(pluginId="CreateRequestPlugin", template="war:/notification/templates/web/CreateRequestPlugin.gtmpl"), @TemplateConfig(pluginId="CancelRequestPlugin", template="war:/notification/templates/web/CancelRequestPlugin.gtmpl"), @TemplateConfig(pluginId="RequestCommentPlugin", template="war:/notification/templates/web/RequestCommentPlugin.gtmpl")})
public class WebTemplateProvider
extends TemplateProvider {
    public WebTemplateProvider(InitParams initParams) {
        super(initParams);
        this.templateBuilders.put(PluginKey.key((String)"CreateRequestPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"CancelRequestPlugin"), new TemplateBuilder());
        this.templateBuilders.put(PluginKey.key((String)"RequestCommentPlugin"), new RequestCommentTemplateBuilder());
    }

    private void buildCommonTemplateParams(TemplateContext templateContext, NotificationInfo notificationInfo, String language, String user) {
        Profile userProfile = NotificationUtils.getUserProfile(user);
        templateContext.put((Object)"USER", (Object)userProfile.getFullName());
        templateContext.put((Object)"PROFILE_URL", (Object)userProfile.getUrl());
        templateContext.put((Object)"AVATAR", (Object)userProfile.getAvatarUrl());
        Calendar lastModified = Calendar.getInstance();
        lastModified.setTimeInMillis(notificationInfo.getLastModifiedDate());
        templateContext.put((Object)"LAST_UPDATED_TIME", (Object)TimeConvertUtils.convertXTimeAgoByTimeServer((Date)lastModified.getTime(), (String)"EE, dd yyyy", (Locale)new Locale(language), (int)TimeConvertUtils.YEAR));
        boolean isRead = Boolean.parseBoolean(notificationInfo.getValueOwnerParameter(NotificationMessageUtils.READ_PORPERTY.getKey()));
        templateContext.put((Object)"READ", (Object)(isRead ? "read" : "unread"));
        templateContext.put((Object)"NOTIFICATION_ID", (Object)notificationInfo.getId());
    }

    private class RequestCommentTemplateBuilder
    extends AbstractTemplateBuilder {
        private RequestCommentTemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext notificationContext) {
            NotificationInfo notificationInfo = notificationContext.getNotificationInfo();
            String pluginId = notificationInfo.getKey().getId();
            String processTitle = notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_PROCESS.getKey());
            String requestTitle = notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_TITLE.getKey());
            String commentAuthor = notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_COMMENT_AUTHOR.getKey());
            String comment = notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_COMMENT.getKey());
            String requestCommentUrl = notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_COMMENT_URL.getKey());
            String language = this.getLanguage(notificationInfo);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            templateContext.put((Object)"PROCESS_TITLE", (Object)processTitle);
            templateContext.put((Object)"REQUEST_TITLE", (Object)requestTitle);
            templateContext.put((Object)"REQUEST_COMMENT_AUTHOR", (Object)commentAuthor);
            templateContext.put((Object)"REQUEST_COMMENT_URL", (Object)requestCommentUrl);
            templateContext.put((Object)"REQUEST_COMMENT", (Object)comment);
            WebTemplateProvider.this.buildCommonTemplateParams(templateContext, notificationInfo, language, commentAuthor);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            notificationContext.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext notificationContext, Writer writer) {
            return false;
        }
    }

    private class TemplateBuilder
    extends AbstractTemplateBuilder {
        private TemplateBuilder() {
        }

        protected MessageInfo makeMessage(NotificationContext notificationContext) {
            NotificationInfo notificationInfo = notificationContext.getNotificationInfo();
            String pluginId = notificationInfo.getKey().getId();
            String requester = notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_CREATOR.getKey());
            String processUrl = notificationInfo.getValueOwnerParameter(NotificationArguments.PROCESS_URL.getKey());
            String requestUrl = notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_URL.getKey());
            String language = this.getLanguage(notificationInfo);
            TemplateContext templateContext = TemplateContext.newChannelInstance((ChannelKey)WebTemplateProvider.this.getChannelKey(), (String)pluginId, (String)language);
            if (pluginId.equals("CreateRequestPlugin")) {
                String processTitle = notificationInfo.getValueOwnerParameter(NotificationArguments.REQUEST_PROCESS.getKey());
                templateContext.put((Object)"PROCESS_TITLE", (Object)processTitle);
            }
            templateContext.put((Object)"PROCESS_URL", (Object)processUrl);
            templateContext.put((Object)"REQUEST_URL", (Object)requestUrl);
            WebTemplateProvider.this.buildCommonTemplateParams(templateContext, notificationInfo, language, requester);
            String body = TemplateUtils.processGroovy((TemplateContext)templateContext);
            notificationContext.setException(templateContext.getException());
            MessageInfo messageInfo = new MessageInfo();
            return messageInfo.body(body).end();
        }

        protected boolean makeDigest(NotificationContext notificationContext, Writer writer) {
            return false;
        }
    }
}

