/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.jaxrs.PATCH;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.jcr.ItemExistsException;
import javax.persistence.EntityNotFoundException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.processes.model.IllustrativeAttachment;
import org.exoplatform.processes.model.ProcessesFilter;
import org.exoplatform.processes.model.Work;
import org.exoplatform.processes.model.WorkFilter;
import org.exoplatform.processes.model.WorkFlow;
import org.exoplatform.processes.rest.model.WorkEntity;
import org.exoplatform.processes.rest.model.WorkFlowEntity;
import org.exoplatform.processes.rest.util.EntityBuilder;
import org.exoplatform.processes.rest.util.RestUtils;
import org.exoplatform.processes.service.ProcessesAttachmentService;
import org.exoplatform.processes.service.ProcessesService;
import org.exoplatform.services.attachments.model.Attachment;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

@Path(value="/v1/processes")
@Api(value="/v1/processes", description="Manages processes")
public class ProcessesRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ProcessesRest.class);
    private ProcessesService processesService;
    private IdentityManager identityManager;
    private ProcessesAttachmentService processesAttachmentService;
    private static final int CACHE_DURATION_SECONDS = 31536000;
    private static final long CACHE_DURATION_MILLISECONDS = 31536000000L;
    private static final CacheControl ILLUSTRATION_CACHE_CONTROL = new CacheControl();

    public ProcessesRest(ProcessesService processesService, IdentityManager identityManager, ProcessesAttachmentService processesAttachmentService) {
        this.processesService = processesService;
        this.identityManager = identityManager;
        this.processesAttachmentService = processesAttachmentService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/workflows")
    @ApiOperation(value="Retrieves the list of workFlows for an authenticated user", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getWorkFlows(@ApiParam(value="Identity technical identifier", required=false) @QueryParam(value="userId") Long userId, @ApiParam(value="filter workflow by status", required=false) @QueryParam(value="enabled") Boolean enabled, @ApiParam(value="Search query entered by the user", required=false) @QueryParam(value="query") String query, @ApiParam(value="Processes properties to expand.", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Offset of results to return", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit of results to return", required=false, defaultValue="10") @QueryParam(value="limit") int limit) {
        try {
            long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
            if (currentIdentityId == 0L) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            ProcessesFilter filter = new ProcessesFilter();
            if (enabled != null) {
                filter.setEnabled(enabled);
            }
            if (query != null) {
                filter.setQuery(query);
            }
            long userIdentityId = currentIdentityId;
            if (userId != null) {
                userIdentityId = userId;
            }
            List workFlows = this.processesService.getWorkFlows(filter, offset, limit, userIdentityId);
            return Response.ok(EntityBuilder.toRestEntities(workFlows, expand)).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of workFlows", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/workflows")
    @ApiOperation(value="Creates a new WorkFlow", httpMethod="POST", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createWorkFlow(@ApiParam(value="WorkFlow object to create", required=true) WorkFlowEntity workFlowEntity) {
        if (workFlowEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"WorkFlow object is mandatory").build();
        }
        long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (currentIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            WorkFlow newWorkFlow = this.processesService.createWorkFlow(EntityBuilder.fromEntity(workFlowEntity), currentIdentityId);
            return Response.ok((Object)EntityBuilder.toEntity(newWorkFlow, "")).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)"User '{}' attempts to create a Work WorkFlow", (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error creating a WorkFlow", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/workflows")
    @ApiOperation(value="Updates a workFlow", httpMethod="PUT", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=404, message="Object to update not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateWorkFlow(@ApiParam(value="WorkFlow object to update", required=true) WorkFlowEntity workFlowEntity) {
        if (workFlowEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"WorkFlow object is mandatory").build();
        }
        long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (currentIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            WorkFlow newWorkFlow = this.processesService.updateWorkFlow(EntityBuilder.fromEntity(workFlowEntity), currentIdentityId);
            return Response.ok((Object)EntityBuilder.toEntity(newWorkFlow, "")).build();
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("User '{}' attempts to update a not existing work workFlow '{}'", new Object[]{currentIdentityId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Work workFlow not found").build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to update a work workFlow for owner '{}'", new Object[]{currentIdentityId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error updating a work workFlow", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/works")
    @ApiOperation(value="Retrieves the list of works for an authenticated user", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getWorks(@ApiParam(value="Identity technical identifier", required=false) @QueryParam(value="userId") Long userId, @ApiParam(value="Processes properties to expand.", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="work completed property") @QueryParam(value="completed") Boolean completed, @ApiParam(value="Works status") @QueryParam(value="status") String status, @ApiParam(value="Works query") @QueryParam(value="query") String query, @ApiParam(value="Offset of results to return", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit of results to return", required=false, defaultValue="10") @QueryParam(value="limit") int limit) {
        try {
            long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
            if (currentIdentityId == 0L) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            long userIdentityId = currentIdentityId;
            if (userId != null) {
                userIdentityId = userId;
            }
            WorkFilter workFilter = new WorkFilter();
            if (status != null) {
                workFilter.setStatus(status);
            }
            if (query != null) {
                workFilter.setQuery(query);
            }
            if (completed != null) {
                workFilter.setCompleted(completed);
            }
            List works = this.processesService.getWorks(userIdentityId, workFilter, offset, limit);
            return Response.ok(EntityBuilder.toWorkEntityList(this.processesService, works, expand)).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of works", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/works")
    @ApiOperation(value="Creates a Work", httpMethod="POST", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createWork(@ApiParam(value="Work object to create", required=true) WorkEntity workEntity) {
        if (workEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Work object is mandatory").build();
        }
        if (workEntity.getProjectId() == 0L && workEntity.getWorkFlow().getProjectId() == 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Work projectId object is mandatory").build();
        }
        if (!workEntity.getWorkFlow().isEnabled()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Workflow is disabled").build();
        }
        long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (currentIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            Work newWork = this.processesService.createWork(EntityBuilder.toWork(this.processesService, workEntity), currentIdentityId);
            return Response.ok((Object)EntityBuilder.toWorkEntity(this.processesService, newWork, "workFlow")).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)"User '{}' attempts to create a Work Work", (Throwable)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error creating a Work", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/works")
    @ApiOperation(value="Updates a new work", httpMethod="PUT", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateWork(@ApiParam(value="Work object to update", required=true) WorkEntity workEntity) {
        if (workEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Work object is mandatory").build();
        }
        long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (currentIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            Work newWork = this.processesService.updateWork(EntityBuilder.toWork(this.processesService, workEntity), currentIdentityId);
            return Response.ok((Object)EntityBuilder.toWorkEntity(this.processesService, newWork, "workFlow")).build();
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("User '{}' attempts to update a not existing work workFlow '{}'", new Object[]{currentIdentityId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Work workFlow not found").build();
        }
        catch (IllegalAccessException e) {
            LOG.error("User '{}' attempts to update a work workFlow for owner '{}'", new Object[]{currentIdentityId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error updating a work workFlow", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @Path(value="/permissions")
    @ApiOperation(value="checks is current user is a processes manager", httpMethod="GET", response=Response.class, produces="text/plain")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response isProcessesManager() {
        long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (currentIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            Identity identity = ConversationState.getCurrent().getIdentity();
            boolean isProcessesGroupMember = RestUtils.isProcessesGroupMember(identity);
            return Response.ok((Object)String.valueOf(isProcessesGroupMember)).type("text/plain").build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while checking user permissions", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"processes"})
    @Path(value="/workflow/{workflowId}")
    @ApiOperation(value="delete a workflow by its id", httpMethod="DELETE", response=Response.class, produces="text/plain")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=404, message="Object not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteWorkflow(@ApiParam(value="Workflow id to delete", required=true) @PathParam(value="workflowId") Long workflowId) {
        if (workflowId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Workflow id is mandatory").build();
        }
        long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        Identity identity = ConversationState.getCurrent().getIdentity();
        if (currentIdentityId == 0L || !RestUtils.isProcessesGroupMember(identity)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.processesService.deleteWorkflowById(workflowId);
            return Response.ok((Object)"ok").type("text/plain").build();
        }
        catch (EntityNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while deleting a workflow", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @Path(value="/countWorks/{projectId}")
    @ApiOperation(value="Count tasks by completed and uncompleted status", httpMethod="GET", response=Response.class, produces="text/plain")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Object not found"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response countWorksByWorkflow(@ApiParam(value="Tasks project id", required=true) @PathParam(value="projectId") Long projectId, @ApiParam(value="Processes properties to expand.") @QueryParam(value="isCompleted") @DefaultValue(value="true") Boolean isCompleted) {
        long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (currentIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (projectId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Project id is mandatory").build();
        }
        try {
            WorkFlow workFlow = this.processesService.getWorkFlowByProjectId(projectId.longValue());
            if (workFlow == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"workflow not found").build();
            }
            int worksCount = this.processesService.countWorksByWorkflow(projectId, isCompleted);
            return Response.ok((Object)String.valueOf(worksCount)).type("text/plain").build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting works count", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @Path(value="/work/{workId}")
    @ApiOperation(value="delete a work by its id", httpMethod="DELETE", response=Response.class, produces="text/plain")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteWork(@ApiParam(value="work id to delete", required=true) @PathParam(value="workId") Long workId) {
        if (workId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"work id is mandatory").build();
        }
        long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (currentIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.processesService.deleteWorkById(workId);
            return Response.ok((Object)"ok").type("text/plain").build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while deleting a work", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @PATCH
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/work/{workId}")
    @ApiOperation(value="cancel or resume a work by its id", httpMethod="PATCH", response=Response.class, produces="text/plain")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateWorkCompleted(@ApiParam(value="completed object property", required=true) Map<String, Boolean> completed, @ApiParam(value="work id to be updated", required=true) @PathParam(value="workId") Long workId) {
        long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (currentIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (workId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"work id is mandatory").build();
        }
        if (completed == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"completed object is mandatory").build();
        }
        Boolean completedValue = completed.get("value");
        if (completedValue == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"completed property value should not be null").build();
        }
        try {
            Work newWork = this.processesService.updateWorkCompleted(workId, completedValue.booleanValue());
            return Response.ok((Object)EntityBuilder.toWorkEntity(this.processesService, newWork, "workFlow")).build();
        }
        catch (EntityNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while canceling a work", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/workDraft")
    @ApiOperation(value="Creates a new WorkDraft", httpMethod="POST", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createWorkDraft(@ApiParam(value="WorkDaft object to create", required=true) WorkEntity workEntity) {
        if (workEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"workDraft object is mandatory").build();
        }
        long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (currentIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            Work newWork = this.processesService.createWorkDraft(EntityBuilder.fromEntity(workEntity), currentIdentityId);
            return Response.ok((Object)EntityBuilder.toEntity(newWork)).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error creating a work draft", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/workDraft")
    @ApiOperation(value="Updates a new workDraft", httpMethod="PUT", response=Response.class, consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateWorkDraft(@ApiParam(value="Work object to update", required=true) WorkEntity workEntity) {
        if (workEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"workDraft object is mandatory").build();
        }
        long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (currentIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            Work newWork = this.processesService.updateWorkDraft(EntityBuilder.fromEntity(workEntity), currentIdentityId);
            return Response.ok((Object)EntityBuilder.toEntity(newWork)).build();
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("User '{}' attempts to update a not existing Work draft '{}'", new Object[]{currentIdentityId, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Work draft not found").build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error updating a Work draft", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/workDrafts")
    @ApiOperation(value="Retrieves the list of workDrafts for an authenticated user", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getWorkDrafts(@ApiParam(value="Identity technical identifier", required=false) @QueryParam(value="userId") Long userId, @ApiParam(value="Processes properties to expand.", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Work query.", required=false) @QueryParam(value="query") String query, @ApiParam(value="Offset of results to return", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit of results to return", required=false, defaultValue="10") @QueryParam(value="limit") int limit) {
        try {
            long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
            if (currentIdentityId == 0L) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            long userIdentityId = currentIdentityId;
            if (userId != null) {
                userIdentityId = userId;
            }
            WorkFilter workFilter = new WorkFilter();
            if (query != null) {
                workFilter.setQuery(query);
            }
            workFilter.setIsDraft(Boolean.valueOf(true));
            List works = this.processesService.getWorkDrafts(userIdentityId, workFilter, offset, limit);
            return Response.ok(EntityBuilder.toWorkEntityList(works)).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of work drafts", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @DELETE
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @Path(value="/workDraft/{draftId}")
    @ApiOperation(value="delete a work draft by its id", httpMethod="DELETE", response=Response.class, produces="text/plain")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=404, message="Object not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteWorkDraft(@ApiParam(value="Work draft id to delete", required=true) @PathParam(value="draftId") Long workflowId) {
        if (workflowId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Work draft id is mandatory").build();
        }
        long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (currentIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        try {
            this.processesService.deleteWorkDraftById(workflowId);
            return Response.ok((Object)"ok").type("text/plain").build();
        }
        catch (EntityNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Work draft not found").build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while deleting a work draft", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/works/statuses")
    @ApiOperation(value="Retrieves the list of workDrafts for an authenticated user", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAvailableWorkStatuses() {
        try {
            long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
            if (currentIdentityId == 0L) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            List statuses = this.processesService.getAvailableWorkStatuses();
            return Response.ok((Object)statuses).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of work drafts", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/works/{workId}")
    @ApiOperation(value="Retrieves a work by its given id", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Object not found"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getWorkById(@ApiParam(value="Work id.", required=true) @PathParam(value="workId") Long workId, @ApiParam(value="Processes properties to expand.") @QueryParam(value="expand") String expand) {
        try {
            long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
            if (currentIdentityId == 0L) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (workId == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Work work = this.processesService.getWorkById(currentIdentityId, workId);
            return Response.ok((Object)EntityBuilder.toWorkEntity(this.processesService, work, expand)).build();
        }
        catch (EntityNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while getting work", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Path(value="/workflows/{workflowId}")
    @ApiOperation(value="Retrieves a workflow by its given id", httpMethod="GET", response=Response.class, produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getWorkFlowById(@ApiParam(value="workflow id", required=true) @PathParam(value="workflowId") Long workflowId, @ApiParam(value="Processes properties to expand") @QueryParam(value="expand") String expand) {
        try {
            long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
            if (currentIdentityId == 0L) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (workflowId == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            WorkFlow workFlow = this.processesService.getWorkFlow(workflowId.longValue());
            if (workFlow == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)EntityBuilder.toEntity(workFlow, expand)).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while getting workflow", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="/attachment/newDoc")
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @ApiOperation(value="create new form document", httpMethod="POST", response=Response.class, notes="This returns a new created document")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Not found"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response createNewFormDocument(@ApiParam(value="title", required=true, defaultValue="20") @FormParam(value="title") String title, @ApiParam(value="path of new document", required=true) @FormParam(value="path") String path, @ApiParam(value="New destination path's drive", required=true) @FormParam(value="pathDrive") String pathDrive, @ApiParam(value="template name of new document", required=true, defaultValue="20") @FormParam(value="templateName") String templateName, @ApiParam(value="entity type") @FormParam(value="entityType") String entityType, @ApiParam(value="entity id") @FormParam(value="entityId") Long entityId) {
        long currentIdentityId = RestUtils.getCurrentUserIdentityId(this.identityManager);
        if (currentIdentityId == 0L) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (StringUtils.isEmpty((String)title)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New document title is mandatory").build();
        }
        if (StringUtils.isEmpty((String)templateName)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New document template name is mandatory").build();
        }
        if (StringUtils.isEmpty((String)path)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New document path is mandatory").build();
        }
        if (StringUtils.isEmpty((String)pathDrive)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"New destination path's drive is mandatory").build();
        }
        try {
            Attachment attachment = this.processesAttachmentService.createNewFormDocument(Long.valueOf(currentIdentityId), title, path, pathDrive, templateName, entityType, entityId);
            return Response.ok((Object)org.exoplatform.services.attachments.utils.EntityBuilder.fromAttachment((IdentityManager)this.identityManager, (Attachment)attachment)).build();
        }
        catch (ItemExistsException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Document with the same name already exist in this current path").build();
        }
        catch (Exception e) {
            LOG.error("Error when trying to a new document with type ", new Object[]{templateName, e});
            return Response.serverError().entity((Object)("Error when trying to a new document with type " + templateName)).build();
        }
    }

    @GET
    @Path(value="/illustration/{workflowId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets a workflow illustration image by its id", httpMethod="GET", response=Response.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=404, message="Resource not found")})
    public Response getImageIllustration(@Context Request request, @ApiParam(value="workflow id", required=true) @PathParam(value="workflowId") Long workflowId, @ApiParam(value="Optional last modified parameter") @QueryParam(value="v") long lastModified) {
        if (workflowId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"workflow id is mandatory").build();
        }
        try {
            WorkFlow workFlow = this.processesService.getWorkFlow(workflowId.longValue());
            if (workFlow == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"workflow not found").build();
            }
            Long illustrationId = workFlow.getIllustrativeAttachment().getId();
            IllustrativeAttachment illustrativeAttachment = this.processesService.getIllustrationImageById(illustrationId);
            Long lastUpdated = illustrativeAttachment.getLastUpdated();
            EntityTag eTag = new EntityTag(String.valueOf(lastUpdated), true);
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                InputStream stream = illustrativeAttachment.getFileInputStream();
                builder = Response.ok((Object)stream, (String)illustrativeAttachment.getMimeType());
                builder.tag(eTag);
                if (lastModified > 0L) {
                    builder.lastModified(new Date(lastUpdated));
                    builder.expires(new Date(System.currentTimeMillis() + 31536000000L));
                    builder.cacheControl(ILLUSTRATION_CACHE_CONTROL);
                }
            }
            return builder.build();
        }
        catch (ObjectNotFoundException e) {
            LOG.error((Object)"Illustrative image not found", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred while getting image illustration", (Throwable)e);
            return Response.serverError().build();
        }
    }

    static {
        ILLUSTRATION_CACHE_CONTROL.setMaxAge(31536000);
    }
}

