/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.processes.entity.WorkFlowEntity;
import org.exoplatform.processes.model.ProcessesFilter;

public class WorkFlowDAO
extends GenericDAOJPAImpl<WorkFlowEntity, Long> {
    public List<WorkFlowEntity> findAllWorkFlowsByUser(long userId, int offset, int limit) {
        List resultList;
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.findAllWorkFlowsByUser", WorkFlowEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public List<WorkFlowEntity> findEnabledWorkFlowsByUser(long userId, int offset, int limit) {
        List resultList;
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.findEnabledWorkFlowsByUser", WorkFlowEntity.class);
        query.setParameter("userId", (Object)userId);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public List<WorkFlowEntity> findAllWorkFlows(int offset, int limit) {
        List resultList;
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.findAllWorkFlows", WorkFlowEntity.class);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    private String buildWorkflowQuery(ProcessesFilter processesFilter, List<String> memberships) {
        String q = processesFilter.getQuery();
        Boolean enabled = processesFilter.getEnabled();
        Boolean manager = processesFilter.getManager();
        Object queryString = "SELECT DISTINCT workFlow FROM WorkFlow workFlow";
        if (memberships != null) {
            queryString = (String)queryString + " LEFT JOIN workFlow.manager manager  LEFT JOIN workFlow.participator participator ";
        }
        if (StringUtils.isNotEmpty((String)q) || memberships != null || enabled != null) {
            queryString = (String)queryString + " WHERE";
            if (StringUtils.isNotEmpty((String)q)) {
                queryString = (String)queryString + " ( workFlow.title like '%" + q + "%'";
                queryString = (String)queryString + " OR workFlow.description like '%" + q + "%'";
                queryString = (String)queryString + " OR workFlow.summary like '%" + q + "%' )";
                queryString = (String)queryString + " AND";
            }
            if (enabled != null) {
                queryString = (String)queryString + " workFlow.enabled = " + enabled;
                queryString = (String)queryString + " AND";
            }
            if (memberships != null) {
                queryString = (String)queryString + " manager IN ('" + String.join((CharSequence)"','", this.getMembersShipGroup(memberships)) + "') ";
                if (Boolean.FALSE.equals(manager)) {
                    queryString = (String)queryString + " OR participator IN ('" + String.join((CharSequence)"','", memberships) + "') ";
                }
            }
            if (((String)queryString).endsWith(" AND")) {
                queryString = ((String)queryString).substring(0, ((String)queryString).length() - 4);
            }
        }
        return queryString;
    }

    private List<String> getMembersShipGroup(List<String> memberships) {
        return memberships.stream().map(s -> !s.startsWith("manager:/") && !s.startsWith("member:/") ? s : s.replace("manager:", "").replace("member:", "")).collect(Collectors.toList());
    }

    private Query buildWorkflowQueryCriteria(ProcessesFilter processesFilter) {
        String q = processesFilter.getQuery();
        Boolean enabled = processesFilter.getEnabled();
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        CriteriaBuilder criteriaBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(WorkFlowEntity.class);
        Root root = criteriaQuery.from(WorkFlowEntity.class);
        if (q != null) {
            ArrayList<Predicate> qPredicates = new ArrayList<Predicate>();
            qPredicates.add(criteriaBuilder.like((Expression)root.get("title"), "%" + q + "%"));
            qPredicates.add(criteriaBuilder.like((Expression)root.get("description"), "%" + q + "%"));
            qPredicates.add(criteriaBuilder.like((Expression)root.get("summary"), "%" + q + "%"));
            predicates.add(criteriaBuilder.or(qPredicates.toArray(new Predicate[0])));
        }
        if (enabled != null) {
            predicates.add(criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)root.get("enabled"), (Object)enabled)}));
        }
        criteriaQuery.select((Selection)root).where(predicates.toArray(new Predicate[0]));
        criteriaQuery.orderBy(new Order[]{criteriaBuilder.desc((Expression)root.get("id"))});
        TypedQuery query = this.getEntityManager().createQuery(criteriaQuery);
        return query;
    }

    public List<WorkFlowEntity> findWorkFlows(ProcessesFilter processesFilter, int offset, int limit) {
        List resultList;
        Query query = this.buildWorkflowQueryCriteria(processesFilter);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public int countWorkFlows(ProcessesFilter processesFilter) {
        Query query = this.buildWorkflowQueryCriteria(processesFilter);
        return query.getMaxResults();
    }

    public List<WorkFlowEntity> findWorkFlows(ProcessesFilter processesFilter, List<String> memberships, int offset, int limit) {
        List resultList;
        String queryString = this.buildWorkflowQuery(processesFilter, memberships);
        Query query = this.getEntityManager().createQuery(queryString);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public int countWorkFlows(ProcessesFilter processesFilter, List<String> memberships) {
        String queryString = this.buildWorkflowQuery(processesFilter, memberships);
        TypedQuery query = this.getEntityManager().createQuery(queryString, Long.class);
        return query.getMaxResults();
    }

    public List<WorkFlowEntity> findEnabledWorkFlows(int offset, int limit) {
        List resultList;
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.findEnabledWorkFlows", WorkFlowEntity.class);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public List<WorkFlowEntity> findDisabledWorkFlows(int offset, int limit) {
        List resultList;
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.findDisabledWorkFlows", WorkFlowEntity.class);
        query.setFirstResult(offset);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return (resultList = query.getResultList()) == null ? Collections.emptyList() : resultList;
    }

    public WorkFlowEntity getWorkFlowByProjectId(long projectId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("WorkFlow.getWorkFlowByProjectId", WorkFlowEntity.class);
        query.setParameter("projectId", (Object)projectId);
        try {
            return (WorkFlowEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }
}

