/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.notification.plugin;

import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.processes.notification.utils.NotificationArguments;
import org.exoplatform.processes.notification.utils.NotificationUtils;

public class RequestCommentPlugin
extends BaseNotificationPlugin {
    public static final String ID = "RequestCommentPlugin";

    public RequestCommentPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext notificationContext) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext notificationContext) {
        String requester = (String)notificationContext.value(NotificationArguments.REQUEST_CREATOR);
        String processUrl = (String)notificationContext.value(NotificationArguments.PROCESS_URL);
        String processTitle = (String)notificationContext.value(NotificationArguments.REQUEST_PROCESS);
        String requestTitle = (String)notificationContext.value(NotificationArguments.REQUEST_TITLE);
        String commentAuthor = (String)notificationContext.value(NotificationArguments.REQUEST_COMMENT_AUTHOR);
        String comment = (String)notificationContext.value(NotificationArguments.REQUEST_COMMENT);
        String requestCommentUrl = (String)notificationContext.value(NotificationArguments.REQUEST_COMMENT_URL);
        String workflowProjectId = (String)notificationContext.value(NotificationArguments.WORKFLOW_PROJECT_ID);
        List<String> receivers = NotificationUtils.getReceivers(Long.parseLong(workflowProjectId), commentAuthor, false);
        if (!receivers.contains(requester) && !requester.equals(commentAuthor)) {
            receivers.add(requester);
        }
        return NotificationInfo.instance().setFrom(commentAuthor).to(receivers).with(NotificationArguments.REQUEST_CREATOR.getKey(), requester).with(NotificationArguments.REQUEST_PROCESS.getKey(), processTitle).with(NotificationArguments.REQUEST_TITLE.getKey(), requestTitle).with(NotificationArguments.REQUEST_COMMENT_AUTHOR.getKey(), commentAuthor).with(NotificationArguments.PROCESS_URL.getKey(), processUrl).with(NotificationArguments.REQUEST_COMMENT.getKey(), comment).with(NotificationArguments.REQUEST_COMMENT_URL.getKey(), requestCommentUrl).key(this.getKey()).end();
    }
}

