/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.notification.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.processes.model.WorkFlow;
import org.exoplatform.processes.service.ProcessesService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class NotificationUtils {
    private static final Log LOG = ExoLogger.getLogger(NotificationUtils.class);
    private static final String PROCESSES_GROUP = "/platform/processes";

    public static List<String> getProcessAdmins(String currentUser) {
        ArrayList<String> admins = new ArrayList<String>();
        try {
            OrganizationService organizationService = (OrganizationService)CommonsUtils.getService(OrganizationService.class);
            ListAccess list = organizationService.getUserHandler().findUsersByGroupId(PROCESSES_GROUP);
            Arrays.stream((User[])list.load(0, list.getSize())).map(User::getUserName).filter(userName -> !userName.equals(currentUser)).forEach(userName -> admins.add((String)userName));
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting process admins", (Throwable)e);
        }
        return admins;
    }

    public static Profile getUserProfile(String userName) {
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity identity = identityManager.getOrCreateIdentity("organization", userName);
        if (identity != null) {
            return identity.getProfile();
        }
        return null;
    }

    public static String getProcessLink(Long projectId) {
        StringBuilder stringBuilder = new StringBuilder();
        String portalOwner = CommonsUtils.getCurrentPortalOwner();
        String domain = CommonsUtils.getCurrentDomain();
        stringBuilder.append(domain).append("/").append(LinkProvider.getPortalName(null)).append("/").append(portalOwner).append("/tasks/projectDetail/").append(projectId);
        return stringBuilder.toString();
    }

    public static String getRequestLink(Long taskId) {
        StringBuilder stringBuilder = new StringBuilder();
        String portalOwner = CommonsUtils.getCurrentPortalOwner();
        String domain = CommonsUtils.getCurrentDomain();
        stringBuilder.append(domain).append("/").append(LinkProvider.getPortalName(null)).append("/").append(portalOwner).append("/tasks/taskDetail/").append(taskId);
        return stringBuilder.toString();
    }

    public static Object getRequestCommentsLink(Long taskId) {
        StringBuilder stringBuilder = new StringBuilder();
        String portalOwner = CommonsUtils.getCurrentPortalOwner();
        String domain = CommonsUtils.getCurrentDomain();
        stringBuilder.append(domain).append("/").append(LinkProvider.getPortalName(null)).append("/").append(portalOwner).append("/processes/myRequests/requestDetails/").append(taskId).append("/comments");
        return stringBuilder.toString();
    }

    public static List<String> getSpacesMembers(Set<String> spacesGroupsId) {
        ArrayList<String> members = new ArrayList<String>();
        SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        spacesGroupsId.forEach(groupId -> {
            Space space = spaceService.getSpaceByGroupId(groupId);
            if (space != null) {
                members.addAll(Arrays.stream(space.getMembers()).collect(Collectors.toList()));
            }
        });
        return members;
    }

    public static WorkFlow getWorkFlowByProjectId(long workflowProjectId) {
        ProcessesService processesService = (ProcessesService)CommonsUtils.getService(ProcessesService.class);
        return processesService != null ? processesService.getWorkFlowByProjectId(workflowProjectId) : null;
    }

    public static List<String> getReceivers(long workflowProjectId, String requester, boolean withAdministrators) {
        WorkFlow workFlow;
        ArrayList<String> receivers = new ArrayList<String>();
        if (withAdministrators) {
            receivers.addAll(NotificationUtils.getProcessAdmins(requester));
        }
        if ((workFlow = NotificationUtils.getWorkFlowByProjectId(workflowProjectId)) != null) {
            receivers.addAll(NotificationUtils.getSpacesMembers(workFlow.getManager()));
        }
        receivers.remove(requester);
        return receivers.stream().distinct().collect(Collectors.toList());
    }
}

