/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.processes.model.ProcessesFilter;
import org.exoplatform.processes.model.Work;
import org.exoplatform.processes.model.WorkFilter;
import org.exoplatform.processes.model.WorkFlow;
import org.exoplatform.processes.service.ProcessesService;
import org.exoplatform.processes.service.ProcessesServiceImpl;
import org.exoplatform.processes.storage.ProcessesStorage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class ProcessesServiceImplTest {
    @Mock
    private ProcessesStorage processesStorage;
    private ProcessesService processesService;
    private WorkFlow disabledWorkFlow;
    private WorkFlow enabledWorkFlow;
    private Work work1;
    private Work work2;
    private final List<WorkFlow> enabledWorkFlowList = new ArrayList<WorkFlow>();
    private final List<WorkFlow> disabledWorkFlowList = new ArrayList<WorkFlow>();
    private final List<WorkFlow> allWorkFlowList = new ArrayList<WorkFlow>();
    private final List<Work> allWorkList = new ArrayList<Work>();

    @Before
    public void setUp() throws Exception {
        this.processesService = new ProcessesServiceImpl(this.processesStorage);
        this.disabledWorkFlow = new WorkFlow();
        this.disabledWorkFlow.setEnabled(false);
        this.enabledWorkFlow = new WorkFlow();
        this.enabledWorkFlow.setId(1L);
        this.enabledWorkFlow.setEnabled(true);
        this.allWorkFlowList.add(this.disabledWorkFlow);
        this.allWorkFlowList.add(this.disabledWorkFlow);
        this.enabledWorkFlowList.add(this.enabledWorkFlow);
        this.disabledWorkFlowList.add(this.disabledWorkFlow);
        this.allWorkList.add(this.work1);
        this.allWorkList.add(this.work2);
    }

    @Test
    public void getWorkFlows() throws IllegalAccessException {
        ProcessesFilter processesFilter = new ProcessesFilter();
        processesFilter.setEnabled(Boolean.valueOf(true));
        processesFilter.setQuery("test");
        Mockito.when((Object)this.processesStorage.findWorkFlows(processesFilter, 0L, 0, 10)).thenReturn(this.enabledWorkFlowList);
        List enabledResult = this.processesService.getWorkFlows(processesFilter, 0, 10, 0L);
        Assert.assertEquals(this.enabledWorkFlowList, (Object)enabledResult);
        Assert.assertEquals((long)1L, (long)enabledResult.size());
        Assert.assertTrue((boolean)((WorkFlow)enabledResult.get(0)).isEnabled());
    }

    @Test
    public void getWorks() throws Exception {
        WorkFilter workFilter = new WorkFilter();
        workFilter.setQuery("test");
        Mockito.when((Object)this.processesStorage.getWorks(0L, workFilter, 0, 10)).thenReturn(this.allWorkList);
        Assert.assertEquals((Object)this.processesService.getWorks(0L, workFilter, 0, 10), this.allWorkList);
    }

    @Test
    public void getWorkFlowByProjectId() throws Exception {
        Mockito.when((Object)this.processesStorage.getWorkFlowByProjectId(0L)).thenReturn((Object)this.enabledWorkFlow);
        Assert.assertEquals((long)this.processesService.getWorkFlowByProjectId(0L).getId(), (long)1L);
    }

    @Test
    public void getWorkFlow() throws IllegalAccessException {
        Mockito.when((Object)this.processesStorage.getWorkFlowById(1L)).thenReturn((Object)this.enabledWorkFlow);
        Assert.assertEquals((long)this.processesService.getWorkFlow(1L).getId(), (long)1L);
    }

    @Test
    public void countWorkFlows() throws IllegalAccessException {
        ProcessesFilter processesFilter = new ProcessesFilter();
        processesFilter.setEnabled(Boolean.valueOf(true));
        processesFilter.setQuery("test");
        Mockito.when((Object)this.processesStorage.countWorkFlows(processesFilter)).thenReturn((Object)this.enabledWorkFlowList.size());
        Assert.assertEquals((long)this.processesService.countWorkFlows(processesFilter, 0L), (long)this.enabledWorkFlowList.size());
    }

    @Test
    public void updateWorkflow() throws ObjectNotFoundException, IllegalAccessException {
        WorkFlow workFlow = new WorkFlow();
        WorkFlow updatedWorkflow = new WorkFlow();
        updatedWorkflow.setId(1L);
        updatedWorkflow.setDescription("anything");
        workFlow.setId(0L);
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.updateWorkFlow(null, 1L));
        Assert.assertEquals((Object)"Workflow Type is mandatory", (Object)exception1.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).getWorkById(1L);
        Throwable exception2 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.updateWorkFlow(workFlow, 1L));
        Assert.assertEquals((Object)"workflow type id must not be equal to 0", (Object)exception2.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).getWorkById(1L);
        workFlow.setId(1L);
        Mockito.when((Object)this.processesStorage.getWorkFlowById(workFlow.getId())).thenReturn(null);
        Throwable exception3 = Assert.assertThrows(ObjectNotFoundException.class, () -> this.processesService.updateWorkFlow(workFlow, 1L));
        Assert.assertEquals((Object)"oldWorkFlow is not exist", (Object)exception3.getMessage());
        Mockito.when((Object)this.processesStorage.getWorkFlowById(workFlow.getId())).thenReturn((Object)workFlow);
        Throwable exception4 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.updateWorkFlow(workFlow, 1L));
        Assert.assertEquals((Object)"there are no changes to save", (Object)exception4.getMessage());
        Mockito.when((Object)this.processesStorage.getWorkFlowById(workFlow.getId())).thenReturn((Object)updatedWorkflow);
        this.processesService.updateWorkFlow(workFlow, 1L);
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)1))).saveWorkFlow(workFlow, 1L);
    }

    @Test
    public void createWorkflow() throws IllegalAccessException {
        WorkFlow workFlow = new WorkFlow();
        workFlow.setId(1L);
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.createWorkFlow(null, 1L));
        Assert.assertEquals((Object)"workFlow is mandatory", (Object)exception1.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).saveWorkFlow(workFlow, 1L);
        Throwable exception2 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.createWorkFlow(workFlow, 1L));
        Assert.assertEquals((Object)"workFlow id must be equal to 0", (Object)exception2.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).saveWorkFlow(workFlow, 1L);
        workFlow.setId(0L);
        this.processesService.createWorkFlow(workFlow, 1L);
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)1))).saveWorkFlow(workFlow, 1L);
    }

    @Test
    public void createWork() throws IllegalAccessException {
        Work work = new Work();
        work.setId(1L);
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.createWork(null, 1L));
        Assert.assertEquals((Object)"work is mandatory", (Object)exception1.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).saveWork(work, 1L);
        Throwable exception2 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.createWork(work, 1L));
        Assert.assertEquals((Object)"work id must be equal to 0", (Object)exception2.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).saveWork(work, 1L);
        work.setId(0L);
        this.processesService.createWork(work, 1L);
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)1))).saveWork(work, 1L);
    }

    @Test
    public void updateWork() throws ObjectNotFoundException, IllegalAccessException {
        Work work = new Work();
        work.setId(0L);
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.updateWork(null, 1L));
        Assert.assertEquals((Object)"Work is mandatory", (Object)exception1.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).saveWork(work, 1L);
        Throwable exception2 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.updateWork(work, 1L));
        Assert.assertEquals((Object)"work id must not be equal to 0", (Object)exception2.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).saveWork(work, 1L);
        work.setId(1L);
        Mockito.when((Object)this.processesStorage.getWorkById(work.getId())).thenReturn(null);
        Throwable exception3 = Assert.assertThrows(ObjectNotFoundException.class, () -> this.processesService.updateWork(work, 1L));
        Assert.assertEquals((Object)"oldWork is not exist", (Object)exception3.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).saveWork(work, 1L);
        Mockito.when((Object)this.processesStorage.getWorkById(work.getId())).thenReturn((Object)work);
        Throwable exception4 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.updateWork(work, 1L));
        Assert.assertEquals((Object)"there are no changes to save", (Object)exception4.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).saveWork(work, 1L);
        Work newWork = new Work();
        Mockito.when((Object)this.processesStorage.getWorkById(newWork.getId())).thenReturn((Object)newWork);
        newWork.setId(work.getId());
        newWork.setDescription("anything");
        this.processesService.updateWork(newWork, 1L);
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)1))).saveWork(newWork, 1L);
    }

    @Test
    public void countWorksByWorkflow() throws Exception {
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.countWorksByWorkflow(null, Boolean.valueOf(false)));
        Assert.assertEquals((Object)"Project Id is mandatory", (Object)exception1.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).countWorksByWorkflow(1L, false);
        Throwable exception2 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.countWorksByWorkflow(Long.valueOf(1L), null));
        Assert.assertEquals((Object)"isCompleted should not be null", (Object)exception2.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).countWorksByWorkflow(1L, false);
        this.processesService.countWorksByWorkflow(Long.valueOf(1L), Boolean.valueOf(false));
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)1))).countWorksByWorkflow(1L, false);
    }

    @Test
    public void deleteWorkById() {
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.deleteWorkById(null));
        Assert.assertEquals((Object)"Work Id is mandatory", (Object)exception1.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).deleteWorkById(Long.valueOf(ArgumentMatchers.anyLong()));
        this.processesService.deleteWorkById(Long.valueOf(1L));
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)1))).deleteWorkById(Long.valueOf(1L));
    }

    @Test
    public void createWorkDraft() {
        Work work = new Work();
        work.setId(1L);
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.createWorkDraft(null, 1L));
        Assert.assertEquals((Object)"WorkDraft is mandatory", (Object)exception1.getMessage());
        Throwable exception2 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.createWorkDraft(work, 1L));
        Assert.assertEquals((Object)"WorkDraft id must be equal to 0", (Object)exception2.getMessage());
        work.setId(0L);
        this.processesService.createWorkDraft(work, 1L);
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)1))).saveWorkDraft(work, 1L);
    }

    @Test
    public void updateWorkDraft() throws ObjectNotFoundException {
        Work work = new Work();
        work.setId(0L);
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.updateWorkDraft(null, 1L));
        Assert.assertEquals((Object)"WorkDraft Type is mandatory", (Object)exception1.getMessage());
        Throwable exception2 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.updateWorkDraft(work, 1L));
        Assert.assertEquals((Object)"WorkDraft type id must not be equal to 0", (Object)exception2.getMessage());
        work.setId(1L);
        Mockito.when((Object)this.processesStorage.getWorkDraftyId(1L)).thenReturn(null);
        Throwable exception3 = Assert.assertThrows(ObjectNotFoundException.class, () -> this.processesService.updateWorkDraft(work, 1L));
        Assert.assertEquals((Object)"oldWorkDraft is not exist", (Object)exception3.getMessage());
        Mockito.when((Object)this.processesStorage.getWorkDraftyId(1L)).thenReturn((Object)work);
        Work newWork = new Work();
        newWork.setId(work.getId());
        newWork.setDescription("test");
        Throwable exception4 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.updateWorkDraft(work, 1L));
        Assert.assertEquals((Object)"there are no changes to save", (Object)exception4.getMessage());
        this.processesService.updateWorkDraft(newWork, 1L);
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)1))).saveWorkDraft(newWork, 1L);
    }

    @Test
    public void getWorkDrafts() {
        ArrayList<Work> workList = new ArrayList<Work>();
        WorkFilter workFilter = new WorkFilter();
        workFilter.setIsDraft(Boolean.valueOf(true));
        workFilter.setQuery("test");
        workList.add(new Work());
        Mockito.when((Object)this.processesStorage.findAllWorkDraftsByUser(workFilter, 0, 10, 1L)).thenReturn(workList);
        List list = this.processesService.getWorkDrafts(1L, workFilter, 0, 10);
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)1))).findAllWorkDraftsByUser(workFilter, 0, 10, 1L);
        Assert.assertEquals((Object)list, workList);
    }

    @Test
    public void deleteWorkDraftById() {
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.deleteWorkDraftById(null));
        Assert.assertEquals((Object)"WorkDraft id is mandatory", (Object)exception1.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).deleteWorkDraftById(1L);
        this.processesService.deleteWorkDraftById(Long.valueOf(1L));
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)1))).deleteWorkDraftById(1L);
    }

    @Test
    public void getWorkById() {
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.getWorkById(1L, null));
        Assert.assertEquals((Object)"Work id is mandatory", (Object)exception1.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).getWorkById(1L, 1L);
        this.processesService.getWorkById(1L, Long.valueOf(1L));
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)1))).getWorkById(1L, 1L);
    }

    @Test
    public void updateWorkCompleted() {
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.updateWorkCompleted(null, false));
        Assert.assertEquals((Object)"Work id is mandatory", (Object)exception1.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).updateWorkCompleted(Long.valueOf(1L), false);
        this.processesService.updateWorkCompleted(Long.valueOf(1L), true);
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)1))).updateWorkCompleted(Long.valueOf(1L), true);
    }

    @Test
    public void getIllustrationImageById() throws ObjectNotFoundException, IOException, FileStorageException {
        Throwable exception1 = Assert.assertThrows(IllegalArgumentException.class, () -> this.processesService.getIllustrationImageById(null));
        Assert.assertEquals((Object)"IllustrationId id is mandatory", (Object)exception1.getMessage());
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)0))).getIllustrationImageById(Long.valueOf(1L));
        this.processesService.getIllustrationImageById(Long.valueOf(1L));
        ((ProcessesStorage)Mockito.verify((Object)this.processesStorage, (VerificationMode)Mockito.times((int)1))).getIllustrationImageById(Long.valueOf(1L));
    }
}

